/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vcha.impl;

import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.SearchIndex;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.vcha.FailoverClusterConfigurator;
import com.vmware.vim.binding.vim.vcha.FailoverClusterManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.vcha.impl.VchaMockDataProvider;
import com.vmware.vsphere.client.vcha.model.VchaClusterVmInfo;
import com.vmware.vsphere.client.vcha.util.VchaUtil;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VchaVmLocationProvider
implements PropertyProviderBean {
    private static final String PROPERTY_VCHA_VM_SINGLE_VC = "vchaVmSingleVc";
    private static final String PROPERTY_VCHA_VM_ACTIVE = "vchaVmActiveNodeInt";
    private static final String PROPERTY_VCHA_VM_PASSIVE = "vchaVmPassiveNodeInt";
    private static final String PROPERTY_VCHA_VM_WITNESS = "vchaVmWitnessNodeInt";
    private static final String PROPERTY_VCHA_CONFIG = "vchaConfig";
    private static final String PROPERTY_VCHA_HEALTH = "vchaClusterHealth";
    private static final String OPTION_KEY_HOST_BIOS_UUID = "VirtualCenter.HostBiosUuid";
    private static final int MAX_FIND_NAME_ATTEMPTS_BEFORE_RND = 10;
    private static final int NAME_RND_IDX_BASE = 10000;
    private static final Log _logger = LogFactory.getLog(VchaVmLocationProvider.class);
    private QueryExecutor _queryExecutor;
    private QuerySpecBuilder _querySpecBuilder;
    private VchaMockDataProvider _mockDataProvider;

    public VchaVmLocationProvider(QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder, VchaMockDataProvider mockDataProvider) {
        this._queryExecutor = queryExecutor;
        this._querySpecBuilder = querySpecBuilder;
        this._mockDataProvider = mockDataProvider;
    }

    @type(value="Folder")
    public VchaClusterVmInfo getVchaClusterVmSingleDomain(ManagedObjectReference moRef) throws Exception {
        boolean searchForWitnessVm;
        if (this._mockDataProvider.getUseMockData("vchaClusterVmSingleDomain")) {
            return this._mockDataProvider.getVchaClusterVmSingleDomain();
        }
        VchaClusterVmInfo clusterVmInfo = new VchaClusterVmInfo();
        PropertyValue[] pv = this._queryExecutor.getProperties((Object)moRef, new String[]{PROPERTY_VCHA_CONFIG, PROPERTY_VCHA_HEALTH});
        FailoverClusterConfigurator.VchaClusterConfigInfo clusterConfig = VchaUtil.getPropertyValue(pv, PROPERTY_VCHA_CONFIG, FailoverClusterConfigurator.VchaClusterConfigInfo.class);
        FailoverClusterManager.VchaClusterHealth clusterHealth = VchaUtil.getPropertyValue(pv, PROPERTY_VCHA_HEALTH, FailoverClusterManager.VchaClusterHealth.class);
        if (clusterConfig == null || clusterHealth == null) {
            return clusterVmInfo;
        }
        String activeBiosUuid = this.getBiosUuid(clusterConfig, clusterHealth, FailoverClusterManager.VchaNodeRole.active.name());
        String passiveBiosUuid = this.getBiosUuid(clusterConfig, clusterHealth, FailoverClusterManager.VchaNodeRole.passive.name());
        String witnessBiosUuid = this.getBiosUuid(clusterConfig, clusterHealth, FailoverClusterManager.VchaNodeRole.witness.name());
        boolean searchForActiveVm = !StringUtil.isNullOrEmpty((String)activeBiosUuid);
        boolean searchForPassiveVm = !StringUtil.isNullOrEmpty((String)passiveBiosUuid);
        boolean bl = searchForWitnessVm = !StringUtil.isNullOrEmpty((String)witnessBiosUuid);
        if (!(searchForActiveVm || searchForPassiveVm || searchForWitnessVm)) {
            return clusterVmInfo;
        }
        ArrayList<PropertySpec> propSpecList = new ArrayList<PropertySpec>();
        if (searchForActiveVm) {
            propSpecList.add(VchaUtil.createPropertySpecWithParam(this._querySpecBuilder, Folder.class.getSimpleName(), PROPERTY_VCHA_VM_ACTIVE, activeBiosUuid));
        }
        if (searchForPassiveVm) {
            propSpecList.add(VchaUtil.createPropertySpecWithParam(this._querySpecBuilder, Folder.class.getSimpleName(), PROPERTY_VCHA_VM_PASSIVE, passiveBiosUuid));
        }
        if (searchForWitnessVm) {
            propSpecList.add(VchaUtil.createPropertySpecWithParam(this._querySpecBuilder, Folder.class.getSimpleName(), PROPERTY_VCHA_VM_WITNESS, witnessBiosUuid));
        }
        ResourceSpec resourceSpec = this._querySpecBuilder.createEmptyResourceSpec();
        resourceSpec.propertySpecs = propSpecList.toArray(new PropertySpec[propSpecList.size()]);
        resourceSpec.constraint = VchaUtil.createObjectIdentityConstraint(this._querySpecBuilder, VchaUtil.getRootFolders(moRef));
        QuerySpec querySpec = new QuerySpec();
        querySpec.resourceSpec = resourceSpec;
        _logger.debug((Object)"Searching Active, Passive, Witness VMs on all VCs.");
        ResultSet resultSet = this._queryExecutor.getData(querySpec);
        _logger.debug((Object)"Search for  Active, Passive, Witness VMs on all VCs complete.");
        if (searchForActiveVm) {
            clusterVmInfo.activeVm = VchaUtil.getPropertyValue(resultSet, PROPERTY_VCHA_VM_ACTIVE, ManagedObjectReference.class);
        }
        if (searchForPassiveVm) {
            clusterVmInfo.passiveVm = VchaUtil.getPropertyValue(resultSet, PROPERTY_VCHA_VM_PASSIVE, ManagedObjectReference.class);
        }
        if (searchForWitnessVm) {
            clusterVmInfo.witnessVm = VchaUtil.getPropertyValue(resultSet, PROPERTY_VCHA_VM_WITNESS, ManagedObjectReference.class);
        }
        return clusterVmInfo;
    }

    @type(value="Folder")
    public ManagedObjectReference getVchaCloudVmSingleDomain(ManagedObjectReference moRef) throws Exception {
        if (this._mockDataProvider.getUseMockData("vchaCloudVmSingleDomain")) {
            return this._mockDataProvider.getVchaCloudVmSingleDomain();
        }
        Object optionVal = VchaUtil.getVcOption(moRef, OPTION_KEY_HOST_BIOS_UUID);
        if (!(optionVal instanceof String)) {
            _logger.error((Object)String.format("Required %s setting not found or in unexpected type. CloudVM search aborted.", OPTION_KEY_HOST_BIOS_UUID));
            return null;
        }
        String hostBiosUuid = optionVal.toString();
        _logger.debug((Object)String.format("Retrieved %s: %s", OPTION_KEY_HOST_BIOS_UUID, hostBiosUuid));
        PropertySpec propertySpec = VchaUtil.createPropertySpecWithParam(this._querySpecBuilder, Folder.class.getSimpleName(), PROPERTY_VCHA_VM_SINGLE_VC, hostBiosUuid);
        ResourceSpec resourceSpec = this._querySpecBuilder.createEmptyResourceSpec();
        resourceSpec.constraint = VchaUtil.createObjectIdentityConstraint(this._querySpecBuilder, VchaUtil.getRootFolders(moRef));
        resourceSpec.propertySpecs = new PropertySpec[]{propertySpec};
        QuerySpec querySpec = new QuerySpec();
        querySpec.resourceSpec = resourceSpec;
        _logger.debug((Object)"Searching CloudVM on all VCs.");
        ResultSet resultSet = this._queryExecutor.getData(querySpec);
        _logger.debug((Object)"Search for CloudVM on all VCs complete.");
        return VchaUtil.getPropertyValue(resultSet, PROPERTY_VCHA_VM_SINGLE_VC, ManagedObjectReference.class);
    }

    @type(value="Folder")
    public ManagedObjectReference getVchaVmSingleVc(ManagedObjectReference moRef, String biosUuid) throws Exception {
        ManagedObjectReference[] vmRef = null;
        try {
            SearchIndex searchIndex = this.getSearchIndex(moRef);
            _logger.debug((Object)"SearchIndex retrieved. Calling SearchIndex.findAllByUuid.");
            vmRef = searchIndex.findAllByUuid(null, biosUuid, true, Boolean.valueOf(false));
        }
        catch (Exception ex) {
            _logger.debug((Object)"SearchIndex.findAllByUuid failed to retrieve a result.");
        }
        if (ArrayUtil.isNullOrEmpty(vmRef)) {
            _logger.debug((Object)"No VM found in this inventory.");
            return null;
        }
        if (vmRef.length > 1) {
            _logger.warn((Object)String.format("%d VMs found by the biosUuid: %s. First picked.", vmRef.length, biosUuid));
        }
        _logger.debug((Object)"VM found in this inventory.");
        return vmRef[0];
    }

    @type(value="Folder")
    public ManagedObjectReference getVchaVmActiveNodeInt(ManagedObjectReference moRef, String biosUuid) throws Exception {
        return this.getVchaVmSingleVc(moRef, biosUuid);
    }

    @type(value="Folder")
    public ManagedObjectReference getVchaVmPassiveNodeInt(ManagedObjectReference moRef, String biosUuid) throws Exception {
        return this.getVchaVmSingleVc(moRef, biosUuid);
    }

    @type(value="Folder")
    public ManagedObjectReference getVchaVmWitnessNodeInt(ManagedObjectReference moRef, String biosUuid) throws Exception {
        return this.getVchaVmSingleVc(moRef, biosUuid);
    }

    @type(value="Folder")
    public String getVchaVmUniqueName(ManagedObjectReference folderRef, String suggestedName) throws Exception {
        SearchIndex searchIndex = this.getSearchIndex(folderRef);
        _logger.debug((Object)"SearchIndex retrieved. Calling SearchIndex.findChild.");
        String uniqueName = suggestedName;
        int uniqueIdx = 1;
        int attemptsCount = 0;
        while (searchIndex.findChild(folderRef, uniqueName) != null) {
            uniqueName = suggestedName + uniqueIdx;
            ++uniqueIdx;
            if (++attemptsCount / 10 != 0) continue;
            uniqueIdx = (int)(Math.random() * 10000.0);
        }
        return uniqueName;
    }

    private String getBiosUuid(FailoverClusterConfigurator.VchaClusterConfigInfo clusterConfig, FailoverClusterManager.VchaClusterHealth clusterHealth, String nodeRole) {
        if (clusterConfig == null || clusterHealth == null || clusterHealth.runtimeInfo == null || ArrayUtil.isNullOrEmpty((Object[])clusterHealth.runtimeInfo.nodeInfo) || nodeRole == null) {
            _logger.debug((Object)"Required VCHA config, health and role properties not set");
            return null;
        }
        String nodeRoleIpAddress = null;
        for (FailoverClusterManager.VchaNodeRuntimeInfo nodeInfo : clusterHealth.runtimeInfo.nodeInfo) {
            if (nodeInfo == null || !nodeRole.equals(nodeInfo.nodeRole)) continue;
            nodeRoleIpAddress = nodeInfo.nodeIp;
        }
        if (StringUtil.isNullOrEmpty(nodeRoleIpAddress)) {
            return null;
        }
        if (clusterConfig.failoverNodeInfo1 != null && clusterConfig.failoverNodeInfo1.clusterIpSettings != null && VchaUtil.hasIpAddress(clusterConfig.failoverNodeInfo1.clusterIpSettings, nodeRoleIpAddress)) {
            return clusterConfig.failoverNodeInfo1.biosUuid;
        }
        if (clusterConfig.failoverNodeInfo2 != null && clusterConfig.failoverNodeInfo2.clusterIpSettings != null && VchaUtil.hasIpAddress(clusterConfig.failoverNodeInfo2.clusterIpSettings, nodeRoleIpAddress)) {
            return clusterConfig.failoverNodeInfo2.biosUuid;
        }
        if (clusterConfig.witnessNodeInfo != null && clusterConfig.witnessNodeInfo.ipSettings != null && VchaUtil.hasIpAddress(clusterConfig.witnessNodeInfo.ipSettings, nodeRoleIpAddress)) {
            if (nodeRole.equals(FailoverClusterManager.VchaNodeRole.witness.name())) {
                return clusterConfig.witnessNodeInfo.biosUuid;
            }
            _logger.error((Object)"VCHA config IP address found in unexpected role.");
        }
        return null;
    }

    private SearchIndex getSearchIndex(ManagedObjectReference moRef) throws Exception {
        VcService vcService = VimSessionUtil.getService((String)moRef.getServerGuid());
        ServiceInstanceContent serviceContent = vcService.getServiceInstanceContent();
        SearchIndex searchIndex = (SearchIndex)ManagedObjectUtil.getManagedObject((ManagedObjectReference)serviceContent.getSearchIndex());
        return searchIndex;
    }
}

