/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vcha.util;

import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.option.OptionManager;
import com.vmware.vim.binding.vim.option.OptionValue;
import com.vmware.vim.binding.vim.vcha.FailoverClusterConfigurator;
import com.vmware.vim.binding.vim.vcha.FailoverClusterManager;
import com.vmware.vim.binding.vim.vm.customization.FixedIp;
import com.vmware.vim.binding.vim.vm.customization.FixedIpV6;
import com.vmware.vim.binding.vim.vm.customization.IPSettings;
import com.vmware.vim.binding.vim.vm.customization.IpV6Generator;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.security.sso.SsoUtil;
import com.vmware.vsphere.client.common.compositecommand.BaseCommandSpec;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VchaUtil {
    private static final String RESOURCE_BUNDLE_NAME = "vchaservice";
    private static final String SYS_CONFIG_SSO_GROUP_NAME = "SystemConfiguration.Administrators";
    private static final Log _logger = LogFactory.getLog(VchaUtil.class);

    public static String getLocalizedString(String key) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)key, (ClassLoader)VchaUtil.class.getClassLoader());
    }

    public static boolean isUserSysConfigAuthorized() {
        Set ssoGroups = SsoUtil.getGroups();
        if (ssoGroups == null || ssoGroups.isEmpty()) {
            return false;
        }
        for (String ssoGroup : ssoGroups) {
            int delimiterIndex = ssoGroup.indexOf("\\");
            String groupSimpleName = delimiterIndex != -1 ? ssoGroup.substring(delimiterIndex + 1) : ssoGroup;
            if (!SYS_CONFIG_SSO_GROUP_NAME.equalsIgnoreCase(groupSimpleName)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasIpAddress(IPSettings ipSettings, String ipAddress) {
        if (ipSettings == null) {
            return false;
        }
        if (StringUtil.isNullOrEmpty((String)ipAddress)) {
            return false;
        }
        if (ipSettings.ip instanceof FixedIp) {
            String ipv4Address = ((FixedIp)ipSettings.ip).ipAddress;
            if (ipv4Address != null) {
                ipv4Address = ipv4Address.trim();
            }
            if (ipAddress.equals(ipv4Address)) {
                return true;
            }
        }
        if (ipSettings.ipV6Spec != null && ipSettings.ipV6Spec.ip != null) {
            for (IpV6Generator ipv6Gen : ipSettings.ipV6Spec.ip) {
                if (!(ipv6Gen instanceof FixedIpV6)) continue;
                String ipv6Address = ((FixedIpV6)ipv6Gen).ipAddress;
                if (ipv6Address != null) {
                    ipv6Address = ipv6Address.trim();
                }
                if (!ipAddress.equals(ipv6Address)) continue;
                return true;
            }
        }
        return false;
    }

    public static FailoverClusterManager getFailoverClusterManager(ManagedObjectReference moRef) throws Exception {
        ManagedObjectReference clusterManagerRef = VchaUtil.getServiceContent((ManagedObjectReference)moRef).failoverClusterManager;
        if (clusterManagerRef == null) {
            throw new Exception("FailoverClusterManager reference unset.");
        }
        return (FailoverClusterManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)clusterManagerRef);
    }

    public static FailoverClusterConfigurator getFailoverClusterConfigurator(ManagedObjectReference moRef) throws Exception {
        ManagedObjectReference clusterConfiguratorRef = VchaUtil.getServiceContent((ManagedObjectReference)moRef).failoverClusterConfigurator;
        if (clusterConfiguratorRef == null) {
            throw new Exception("FailoverClusterConfigurator reference unset.");
        }
        return (FailoverClusterConfigurator)ManagedObjectUtil.getManagedObject((ManagedObjectReference)clusterConfiguratorRef);
    }

    public static ServiceInstanceContent getServiceContent(ManagedObjectReference moRef) throws Exception {
        VcService vcService = VimSessionUtil.getService((String)moRef.getServerGuid());
        if (vcService == null) {
            throw new Exception("VcService cannot be retrieved.");
        }
        ServiceInstanceContent serviceContent = vcService.getServiceInstanceContent();
        if (serviceContent == null) {
            throw new Exception("ServiceContent cannot be retrieved.");
        }
        return serviceContent;
    }

    public static Object getVcOption(ManagedObjectReference moRef, String optionKey) throws Exception {
        ManagedObjectReference optionManagerRef = VchaUtil.getServiceContent((ManagedObjectReference)moRef).setting;
        if (optionManagerRef == null) {
            throw new Exception("OptionManager reference unset.");
        }
        OptionManager optionManager = (OptionManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)optionManagerRef);
        if (optionManager == null) {
            throw new Exception("OptionManager cannot be retrieved.");
        }
        Object[] optionValue = optionManager.queryView(optionKey);
        if (!ArrayUtil.isNullOrEmpty((Object[])optionValue)) {
            return ((OptionValue)optionValue[0]).value;
        }
        _logger.debug((Object)String.format("VC option key %s not found or unset.", optionKey));
        return null;
    }

    public static ManagedObjectReference[] getRootFolders(ManagedObjectReference moRef) {
        VcService vcService = VimSessionUtil.getService((String)moRef.getServerGuid());
        Object[] vcEndpoints = vcService.getServiceEndPoints();
        if (ArrayUtil.isNullOrEmpty((Object[])vcEndpoints)) {
            _logger.error((Object)"No VC endpoints found. VM seearch aborted.");
            return new ManagedObjectReference[0];
        }
        HashSet<ManagedObjectReference> rootFolderSet = new HashSet<ManagedObjectReference>();
        for (Object vcEndpoint : vcEndpoints) {
            ManagedObjectReference rootFolderMor = ManagedObjectUtil.getRootFolder((String)vcEndpoint.getVcGuid());
            if (rootFolderMor == null) continue;
            rootFolderSet.add(rootFolderMor);
        }
        return rootFolderSet.toArray(new ManagedObjectReference[0]);
    }

    public static String convertPrefixToSubnetMask(int prefixLength) {
        int bits = 32 - prefixLength;
        int mask = bits == 32 ? 0 : -1 - ((1 << bits) - 1);
        return Integer.toString(mask >> 24 & 0xFF, 10) + "." + Integer.toString(mask >> 16 & 0xFF, 10) + "." + Integer.toString(mask >> 8 & 0xFF, 10) + "." + Integer.toString(mask >> 0 & 0xFF, 10);
    }

    public static <T> T getPropertyValue(PropertyValue[] properties, String propertyName, Class<T> clazz) {
        return VchaUtil.getPropertyValue(properties, propertyName, clazz, null);
    }

    public static <T> T getPropertyValue(PropertyValue[] properties, String propertyName, Class<T> clazz, ManagedObjectReference moRef) {
        if (ArrayUtil.isNullOrEmpty((Object[])properties)) {
            return null;
        }
        if (StringUtil.isNullOrEmpty((String)propertyName)) {
            return null;
        }
        if (clazz == null) {
            return null;
        }
        Object propertyValue = null;
        for (PropertyValue pv : properties) {
            if (pv == null || moRef != null && !pv.resourceObject.equals(moRef) || !propertyName.equals(pv.propertyName) || pv.value == null) continue;
            if (propertyValue == null) {
                propertyValue = pv.value;
                continue;
            }
            _logger.warn((Object)String.format("Property %s returned unexpectedly more than once", pv.propertyName));
        }
        try {
            return clazz.cast(propertyValue);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public static <T> T getPropertyValue(ResultSet resultSet, String propertyName, Class<T> clazz) {
        if (resultSet == null || ArrayUtil.isNullOrEmpty((Object[])resultSet.items)) {
            return null;
        }
        if (StringUtil.isNullOrEmpty((String)propertyName)) {
            return null;
        }
        Object propertyValue = null;
        for (ResultItem resultItem : resultSet.items) {
            if (resultItem == null) continue;
            for (PropertyValue pv : resultItem.properties) {
                if (pv == null || !propertyName.equals(pv.propertyName) || pv.value == null) continue;
                if (propertyValue == null) {
                    propertyValue = pv.value;
                    continue;
                }
                _logger.warn((Object)String.format("Property %s returned unexpectedly more than once", pv.propertyName));
            }
        }
        try {
            return clazz.cast(propertyValue);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public static PropertySpec createPropertySpecWithParam(QuerySpecBuilder querySpecBuild, String targetType, String propertyName, String paramValue) {
        ParameterSpec parameterSpec = new ParameterSpec();
        parameterSpec.parameter = paramValue;
        parameterSpec.propertyName = propertyName;
        PropertySpec propertySpec = querySpecBuild.createPropertySpec(new String[]{propertyName}, targetType);
        propertySpec.parameters = new ParameterSpec[]{parameterSpec};
        return propertySpec;
    }

    public static CompositeConstraint createObjectIdentityConstraint(QuerySpecBuilder querySpecBuilder, ManagedObjectReference[] moRefs) {
        ObjectIdentityConstraint[] rootFolderOIC = new ObjectIdentityConstraint[moRefs.length];
        for (int i = 0; i < moRefs.length; ++i) {
            rootFolderOIC[i] = querySpecBuilder.createObjectIdentityConstraint((Object)moRefs[i]);
        }
        return querySpecBuilder.createCompositeConstraint((Constraint[])rootFolderOIC, Conjoiner.OR);
    }

    public static void appendDependentCommandSpec(BaseCommandSpec targetCmdSpec, BaseCommandSpec newCmdSpec) {
        if (targetCmdSpec == null || newCmdSpec == null) {
            return;
        }
        if (targetCmdSpec.dependentSpecs == null) {
            targetCmdSpec.dependentSpecs = new BaseCommandSpec[0];
        }
        targetCmdSpec.dependentSpecs = (BaseCommandSpec[])ArrayUtil.append((Object[])targetCmdSpec.dependentSpecs, (Object)newCmdSpec);
    }
}

