/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.is;

import com.vmware.vapi.CoreException;
import com.vmware.vapi.bindings.DynamicStructClassResolver;
import com.vmware.vapi.bindings.DynamicStructure;
import com.vmware.vapi.bindings.StaticStructure;
import com.vmware.vapi.bindings.Structure;
import com.vmware.vapi.bindings.type.DynamicStructType;
import com.vmware.vapi.bindings.type.Type;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.BindingsUtil;
import com.vmware.vapi.internal.bindings.TypeConverter;
import com.vmware.vapi.internal.bindings.TypeConverterImpl;
import com.vmware.vapi.internal.bindings.convert.ConverterFactory;
import com.vmware.vapi.internal.bindings.convert.NameToTypeResolver;
import com.vmware.vapi.internal.bindings.convert.impl.DefaultConverterFactory;
import com.vmware.vapi.internal.bindings.convert.impl.MapBasedNameToTypeResolver;
import com.vmware.vapi.internal.is.ValueDeserializer;
import com.vmware.vapi.is.XmlInputSource;
import com.vmware.vapi.is.exception.DeserializationException;
import org.apache.commons.lang.Validate;

public class Deserializer
implements com.vmware.vapi.is.Deserializer {
    private final TypeConverter typeConverter;
    private final ValueDeserializer deserializer;

    public Deserializer(TypeConverter typeConverter) {
        this.typeConverter = typeConverter;
        this.deserializer = new ValueDeserializer();
    }

    public Deserializer() {
        this((TypeConverter)new TypeConverterImpl());
    }

    public Deserializer(final DynamicStructClassResolver resolver) {
        this((TypeConverter)new TypeConverterImpl((ConverterFactory)new DefaultConverterFactory(new NameToTypeResolver(){

            public Type resolve(String name) {
                Class c = resolver.resolveTargetClass(new StructValue(name));
                if (c != null) {
                    return BindingsUtil.extractBindingType((Class)c);
                }
                return (Type)MapBasedNameToTypeResolver.STANDARD_ERRORS.get(name);
            }
        })));
    }

    @Override
    public <T extends Structure> T deserialize(XmlInputSource inputSource, Class<T> clazz) throws DeserializationException {
        Validate.notNull(clazz);
        Type type = Deserializer.getType(clazz);
        return (T)((Structure)this.deserialize(inputSource, type));
    }

    @Override
    public Object deserialize(XmlInputSource inputSource, Type type) throws DeserializationException {
        Validate.notNull((Object)inputSource);
        Validate.notNull((Object)type);
        DataValue value = this.deserializer.deserialize(inputSource);
        try {
            return this.typeConverter.convertToJava(value, type);
        }
        catch (CoreException ex) {
            throw new DeserializationException("Failed to convert deserialized DataValue to binding structure", ex);
        }
    }

    private static <T extends Structure> Type getType(Class<T> clazz) {
        if (DynamicStructure.class.isAssignableFrom(clazz)) {
            return new DynamicStructType();
        }
        if (StaticStructure.class.isAssignableFrom(clazz)) {
            try {
                return BindingsUtil.extractBindingType(clazz);
            }
            catch (Exception e) {
                throw new DeserializationException("Error getting binding class type information.");
            }
        }
        throw new DeserializationException("Unknown structure type " + clazz.getName());
    }
}

