/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.is;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import org.apache.commons.lang.Validate;

public final class FieldNameUtil {
    private FieldNameUtil() {
    }

    public static String toMixedCase(String canonicalName) {
        Validate.notNull((Object)canonicalName, (String)"Canonical name argument is required.");
        String capWords = FieldNameUtil.toCapitalizedWords(canonicalName);
        ArrayList<String> tokens = new ArrayList<String>(Arrays.asList(canonicalName.split("_")));
        StringBuilder result = new StringBuilder();
        if (((String)tokens.get(0)).matches("^[A-Z]+$")) {
            result.append(capWords);
        } else if (!capWords.isEmpty()) {
            result.append(capWords.substring(0, 1).toLowerCase(Locale.ENGLISH));
            result.append(capWords.substring(1));
        }
        return result.toString();
    }

    private static String toCapitalizedWords(String canonicalName) {
        StringBuilder result = new StringBuilder();
        ArrayList<String> tokens = new ArrayList<String>(Arrays.asList(canonicalName.split("_")));
        while (canonicalName.endsWith("_")) {
            tokens.add("");
            canonicalName = canonicalName.substring(0, canonicalName.length() - 1);
        }
        for (String token : tokens) {
            if (!token.isEmpty()) {
                result.append(FieldNameUtil.firstCharToUpperCase(token));
                continue;
            }
            result.append("_");
        }
        return result.toString();
    }

    private static String firstCharToUpperCase(String word) {
        if (word.isEmpty()) {
            return word;
        }
        return word.substring(0, 1).toUpperCase(Locale.ENGLISH) + word.substring(1);
    }
}

