/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.is.common;

import com.vmware.vapi.is.XmlOutputHandler;
import java.util.Stack;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DomXmlOutputHandler
implements XmlOutputHandler {
    private Document _doc;
    private Node _node;
    private Stack<Node> _stack = new Stack();

    public DomXmlOutputHandler(Document doc) throws RuntimeException {
        this._doc = doc;
    }

    @Override
    public void writeStartDocument() {
    }

    @Override
    public void writeEndDocument() {
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws RuntimeException {
        try {
            this.appendChild(this._doc.createElementNS(namespaceURI, localName));
        }
        catch (DOMException e) {
            throw new RuntimeException(String.format("Unable to create element %2$s", localName), e);
        }
    }

    @Override
    public void writeCharacters(String text) throws RuntimeException {
        try {
            this._node.appendChild(this._doc.createTextNode(text));
        }
        catch (DOMException e) {
            throw new RuntimeException(String.format("Unable to append text element %1$s", text), e);
        }
    }

    @Override
    public void writeEndElement() {
        this._node = this._stack.size() > 0 ? this._stack.pop() : null;
    }

    @Override
    public void writeNamespace(String namespaceURI, String prefix) {
        if (prefix.isEmpty()) {
            Attr attr = null;
            attr = this._doc.createAttribute("xmlns");
            attr.setValue(namespaceURI);
            ((Element)this._node).setAttributeNode(attr);
        } else {
            this.writeAttribute("http://www.w3.org/2000/xmlns/", "xmlns", prefix, namespaceURI);
        }
    }

    @Override
    public void writeAttribute(String namespaceURI, String prefix, String localName, String value) throws RuntimeException {
        try {
            Attr attr = null;
            attr = this._doc.createAttributeNS(namespaceURI, prefix + ":" + localName);
            attr.setValue(value);
            ((Element)this._node).setAttributeNode(attr);
        }
        catch (DOMException e) {
            throw new RuntimeException(String.format("Unable to write attribute %1$s", localName), e);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws RuntimeException {
    }

    protected void appendChild(Element element) {
        if (this._node != null) {
            this._stack.push(this._node);
            this._node.appendChild(element);
        } else {
            this._doc.appendChild(element);
        }
        this._node = element;
    }
}

