/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.is.metadata;

import com.vmware.vapi.internal.is.ModelMetadataImpl;
import com.vmware.vapi.is.ModelMetadata;
import com.vmware.vapi.is.exception.SerializationException;
import com.vmware.vapi.metadata.metamodel.ElementMap;
import com.vmware.vapi.metadata.metamodel.ElementValue;
import com.vmware.vapi.metadata.metamodel.FieldInfo;
import com.vmware.vapi.metadata.metamodel.GenericInstantiation;
import com.vmware.vapi.metadata.metamodel.StructureInfo;
import com.vmware.vapi.metadata.metamodel.Type;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;

public final class MetadataConverter {
    public ModelMetadata convert(Map<String, StructureInfo> metadata) throws SerializationException {
        Validate.notNull(metadata, (String)"The metadata must not be null");
        ModelMetadataImpl result = new ModelMetadataImpl();
        for (String structName : metadata.keySet()) {
            StructureInfo si = metadata.get(structName);
            this.processStructure(result, structName, si);
        }
        return result;
    }

    private void processStructure(ModelMetadataImpl metadata, String structName, StructureInfo structInfo) {
        String modelKeyField;
        HashMap<String, ModelMetadataImpl.FieldInfoImpl> fieldInfos = new HashMap<String, ModelMetadataImpl.FieldInfoImpl>();
        for (FieldInfo fieldInfo : structInfo.getFields()) {
            if (Type.Category.GENERIC.equals((Object)fieldInfo.getType().getCategory()) && GenericInstantiation.GenericType.MAP.equals((Object)fieldInfo.getType().getGenericInstantiation().getGenericType())) {
                String mapMetadataKey = String.format("%s-%s", structName, fieldInfo.getName());
                this.processMap(mapMetadataKey, metadata, fieldInfo, fieldInfo.getType().getGenericInstantiation());
                continue;
            }
            ModelMetadataImpl.FieldInfoImpl converted = this.processField(fieldInfo);
            if (converted == null) continue;
            fieldInfos.put(fieldInfo.getName(), converted);
        }
        if (fieldInfos.isEmpty()) {
            return;
        }
        ModelMetadataImpl.StructureInfoImpl result = new ModelMetadataImpl.StructureInfoImpl(modelKeyField, (modelKeyField = this.getModelKeyField(structInfo)) != null ? this.getStructureModelName(structInfo) : null);
        result.getFieldInfo().putAll(fieldInfos);
        metadata.setStructureInfo(structName, result);
    }

    private ModelMetadataImpl.FieldInfoImpl processField(FieldInfo fieldInfo) {
        Validate.notNull((Object)fieldInfo);
        String resourceType = null;
        String resourceTypeField = null;
        for (Map.Entry entry : fieldInfo.getMetadata().entrySet()) {
            ElementMap elementMap = (ElementMap)entry.getValue();
            Map elements = elementMap.getElements();
            ElementValue elementValue = null;
            if (MetadataType.RESOURCE.name().equals(entry.getKey())) {
                elementValue = (ElementValue)elements.get("value");
                resourceType = elementValue.getStringValue();
                continue;
            }
            if (!MetadataType.POLYMORPHIC_RESOURCE.name().equals(entry.getKey())) continue;
            elementValue = (ElementValue)elements.get("typeHolder");
            resourceTypeField = elementValue.getStringValue();
        }
        if (resourceType != null || resourceTypeField != null) {
            return new ModelMetadataImpl.FieldInfoImpl(resourceType, resourceTypeField);
        }
        return null;
    }

    private String getModelKeyField(StructureInfo structInfo) {
        Validate.notNull((Object)structInfo);
        for (FieldInfo fieldInfo : structInfo.getFields()) {
            for (Map.Entry entry : fieldInfo.getMetadata().entrySet()) {
                if (!MetadataType.MODEL_KEY.name().equals(entry.getKey())) continue;
                return fieldInfo.getName();
            }
        }
        return null;
    }

    private void processMap(String mapMetadataKey, ModelMetadataImpl metadata, FieldInfo fieldInfo, GenericInstantiation gi) {
        Validate.notNull((Object)mapMetadataKey);
        Validate.notNull((Object)metadata);
        Validate.notNull((Object)fieldInfo);
        Validate.notNull((Object)gi);
        HashMap<String, ModelMetadataImpl.FieldInfoImpl> fieldInfos = new HashMap<String, ModelMetadataImpl.FieldInfoImpl>();
        if (Type.Category.BUILTIN.equals((Object)gi.getMapKeyType().getCategory()) && Type.BuiltinType.ID.equals((Object)gi.getMapKeyType().getBuiltinType())) {
            fieldInfos.put("key", this.processField(fieldInfo));
        }
        if (Type.Category.GENERIC.equals((Object)gi.getMapValueType().getCategory()) && GenericInstantiation.GenericType.MAP.equals((Object)gi.getMapValueType().getGenericInstantiation().getGenericType())) {
            String nestedMapPath = String.format("%s-%s", mapMetadataKey, "value");
            this.processMap(nestedMapPath, metadata, fieldInfo, gi.getMapValueType().getGenericInstantiation());
        } else if (Type.Category.BUILTIN.equals((Object)gi.getMapValueType().getCategory()) && Type.BuiltinType.ID.equals((Object)gi.getMapValueType().getBuiltinType())) {
            fieldInfos.put("value", this.processField(fieldInfo));
        }
        if (!fieldInfos.isEmpty()) {
            ModelMetadataImpl.StructureInfoImpl si = new ModelMetadataImpl.StructureInfoImpl(null, null);
            si.getFieldInfo().putAll(fieldInfos);
            metadata.setStructureInfo(mapMetadataKey, si);
        }
    }

    private String getStructureModelName(StructureInfo structInfo) {
        ElementValue value;
        Validate.notNull((Object)structInfo);
        ElementMap elementMap = (ElementMap)structInfo.getMetadata().get(MetadataType.MODEL_NAME.name());
        if (elementMap != null && (value = (ElementValue)elementMap.getElements().get("value")) != null && value.getStringValue() != null) {
            return value.getStringValue();
        }
        return null;
    }

    public static enum MetadataType {
        RESOURCE,
        POLYMORPHIC_RESOURCE,
        MODEL_KEY,
        MODEL_NAME;

    }
}

