/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.lookup.client;

import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vim.lookup.client.constants.EndpointTypes;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class LookupSpecFactory {
    public static final String PROP_NODE_ID = "nodeId";
    public static final String PROP_HOST_ID = "hostId";
    public static final String PROP_OWNER_ID = "ownerId";
    public static final String PROP_VERSION = "serviceVersion";
    public static final String PROP_SVCTYPE_PRODUCT = "serviceType.product";
    public static final String PROP_SVCTYPE_TYPE = "serviceType.type";
    public static final String PROP_SERVICE_NAME_KEY = "serviceNameResourceKey";
    public static final String PROP_SERVICE_NAME = "serviceNameDefault";
    public static final String PROP_SERVICE_DESC_KEY = "serviceDescriptionResourceKey";
    public static final String PROP_SERVICE_DESC = "serviceDescriptionDefault";
    public static final String PROP_ENDPOINT = "endpoint";
    public static final String PROP_EPTYPE_PROTOCOL = "type.protocol";
    public static final String PROP_EPTYPE_ID = "type.id";
    public static final String PROP_URL = "url";
    public static final String PROP_SSL_TRUST = "ssltrust";
    public static final String PROP_ATTRIBUTE = "attribute";
    public static final String PROP_DATA = "data";
    public static final String PROP_KEY = "key";
    public static final String PROP_VALUE = "value";

    public static ServiceRegistration.SetSpec createSetSpec(Properties props) throws Exception {
        ServiceRegistration.SetSpec spec = new ServiceRegistration.SetSpec();
        LookupSpecFactory.parseMutableServiceInfo(props, (ServiceRegistration.MutableServiceInfo)spec);
        return spec;
    }

    public static ServiceRegistration.CreateSpec createCreateSpec(Properties props) throws Exception {
        ServiceRegistration.CreateSpec spec = new ServiceRegistration.CreateSpec();
        LookupSpecFactory.parseMutableServiceInfo(props, (ServiceRegistration.MutableServiceInfo)spec);
        String nodeId = props.getProperty(PROP_NODE_ID);
        if (nodeId == null) {
            nodeId = props.getProperty(PROP_HOST_ID);
        }
        spec.setNodeId(nodeId);
        spec.setOwnerId(LookupSpecFactory.getRequiredProperty(props, PROP_OWNER_ID));
        spec.setServiceType(new ServiceRegistration.ServiceType(LookupSpecFactory.getRequiredProperty(props, PROP_SVCTYPE_PRODUCT), LookupSpecFactory.getRequiredProperty(props, PROP_SVCTYPE_TYPE)));
        return spec;
    }

    public static void parseMutableServiceInfo(Properties props, ServiceRegistration.MutableServiceInfo spec) throws Exception {
        String name;
        ServiceRegistration.Attribute attr;
        String name2;
        ServiceRegistration.Endpoint endpoint;
        ArrayList<ServiceRegistration.Endpoint> endpoints = new ArrayList<ServiceRegistration.Endpoint>();
        int i = 0;
        while ((endpoint = LookupSpecFactory.parseEndpoint(name2 = PROP_ENDPOINT + i + ".", props)) != null) {
            endpoints.add(endpoint);
            ++i;
        }
        LookupSpecFactory.parseCommonEndpoint(EndpointTypes.HEALTH_STATUS, props, endpoints);
        LookupSpecFactory.parseCommonEndpoint(EndpointTypes.RESOURCE_BUNDLE, props, endpoints);
        LookupSpecFactory.parseCommonEndpoint(EndpointTypes.CMNOTIFICATION, props, endpoints);
        LookupSpecFactory.parseCommonEndpoint(EndpointTypes.SERVICE_CONFIG_REQUEST, props, endpoints);
        ServiceRegistration.Endpoint[] endpointArray = endpoints.toArray(new ServiceRegistration.Endpoint[endpoints.size()]);
        ArrayList<ServiceRegistration.Attribute> attributes = new ArrayList<ServiceRegistration.Attribute>();
        int i2 = 0;
        while ((attr = LookupSpecFactory.getAttribute(name = PROP_ATTRIBUTE + i2 + ".", props)) != null) {
            attributes.add(attr);
            ++i2;
        }
        ServiceRegistration.Attribute[] attributeArray = attributes.toArray(new ServiceRegistration.Attribute[attributes.size()]);
        spec.setServiceEndpoints(endpointArray);
        spec.setServiceAttributes(attributeArray);
        spec.setServiceVersion(LookupSpecFactory.getRequiredProperty(props, PROP_VERSION));
        spec.setVendorNameResourceKey(props.getProperty("vendorNameResourceKey"));
        spec.setVendorNameDefault(props.getProperty("vendorNameDefault"));
        spec.setVendorProductInfoResourceKey(props.getProperty("vendorProductInfoResourceKey"));
        spec.setVendorProductInfoDefault(props.getProperty("vendorProductInfoDefault"));
        spec.setServiceNameResourceKey(props.getProperty(PROP_SERVICE_NAME_KEY));
        spec.setServiceNameDefault(props.getProperty(PROP_SERVICE_NAME));
        spec.setServiceDescriptionResourceKey(props.getProperty(PROP_SERVICE_DESC_KEY));
        spec.setServiceDescriptionDefault(props.getProperty(PROP_SERVICE_DESC));
    }

    private static void parseCommonEndpoint(ServiceRegistration.EndpointType type, Properties props, List<ServiceRegistration.Endpoint> endpoints) throws Exception {
        ServiceRegistration.Endpoint endpoint = null;
        if (type.equals(EndpointTypes.HEALTH_STATUS)) {
            endpoint = LookupSpecFactory.parseEndpoint("health.", props);
        } else if (type.equals(EndpointTypes.RESOURCE_BUNDLE)) {
            endpoint = LookupSpecFactory.parseEndpoint("resourcebundle.", props);
        } else if (type.equals(EndpointTypes.CMNOTIFICATION)) {
            endpoint = LookupSpecFactory.parseEndpoint("cmnotification.", props);
        } else if (type.equals(EndpointTypes.SERVICE_CONFIG_REQUEST)) {
            endpoint = LookupSpecFactory.parseEndpoint("serviceconfig.", props);
        }
        if (endpoint != null) {
            endpoint.setEndpointType(type);
            endpoints.add(endpoint);
        }
    }

    private static ServiceRegistration.Endpoint parseEndpoint(String name, Properties props) throws Exception {
        String cert;
        String val;
        String url = props.getProperty(name + PROP_URL);
        if (url == null) {
            return null;
        }
        ArrayList<ServiceRegistration.Attribute> endpointData = new ArrayList<ServiceRegistration.Attribute>();
        int d = 0;
        while (true) {
            String data = name + PROP_DATA + d + ".";
            String key = props.getProperty(data + PROP_KEY);
            String val2 = props.getProperty(data + PROP_VALUE);
            if (key == null) break;
            endpointData.add(new ServiceRegistration.Attribute(key, val2));
            ++d;
        }
        String localUrl = props.getProperty(name + "localurl");
        if (localUrl != null) {
            boolean found = false;
            for (ServiceRegistration.Attribute data : endpointData) {
                if (!data.getKey().equals("cis.common.ep.localurl")) continue;
                data.setValue(localUrl);
                found = true;
                break;
            }
            if (!found) {
                endpointData.add(new ServiceRegistration.Attribute("cis.common.ep.localurl", localUrl));
            }
        }
        ArrayList<String> certificateList = new ArrayList<String>();
        int c = 0;
        while ((val = props.getProperty(cert = name + PROP_SSL_TRUST + c)) != null) {
            certificateList.add(val);
            ++c;
        }
        String[] certificates = certificateList.toArray(new String[certificateList.size()]);
        ServiceRegistration.EndpointType endpointType = new ServiceRegistration.EndpointType(LookupSpecFactory.getRequiredProperty(props, name + PROP_EPTYPE_PROTOCOL), LookupSpecFactory.getRequiredProperty(props, name + PROP_EPTYPE_ID));
        ServiceRegistration.Endpoint endpoint = new ServiceRegistration.Endpoint(new URI(url), endpointType, certificates, endpointData.toArray(new ServiceRegistration.Attribute[endpointData.size()]));
        return endpoint;
    }

    private static ServiceRegistration.Attribute getAttribute(String name, Properties props) {
        String key = props.getProperty(name + PROP_KEY);
        String val = props.getProperty(name + PROP_VALUE);
        ServiceRegistration.Attribute ret = null;
        if (key != null) {
            ret = new ServiceRegistration.Attribute(key, val);
        }
        return ret;
    }

    private static String getRequiredProperty(Properties props, String name) throws Exception {
        String value = props.getProperty(name);
        if (value == null) {
            throw new IllegalArgumentException(String.format("Missing required property '%s'", name));
        }
        return value;
    }
}

