/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.lookup.client;

import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.lookup.client.SiteAffinityServerEndpointProvider;
import com.vmware.vim.lookup.client.tool.util.Version;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.ClientConfiguration;
import com.vmware.vim.vmomi.client.ext.ServerEndpointProvider;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import com.vmware.vim.vmomi.core.RequestContext;
import com.vmware.vim.vmomi.core.Stub;
import com.vmware.vim.vmomi.core.exception.VmodlAlreadyLoadedException;
import com.vmware.vim.vmomi.core.impl.RequestContextImpl;
import com.vmware.vim.vmomi.core.security.SignInfo;
import com.vmware.vim.vmomi.core.security.impl.SignInfoImpl;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vim.vmomi.core.types.VmodlVersionMap;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.security.PrivateKey;

public class LookupUtil {
    private static final String VMODL_TYPE = "lookup";
    private static final String DEFAULT_VMODL_VERSION = "3.0";

    private static synchronized void ensureVmodlContextInit() {
        VmodlType vmodlType = VmodlTypeMap.Factory.getTypeMap().getVmodlType(ServiceRegistration.class);
        if (vmodlType == null) {
            String pkg = ServiceRegistration.class.getPackage().getName();
            try {
                VmodlContext.initContext((String[])new String[]{pkg});
            }
            catch (VmodlAlreadyLoadedException vmodlAlreadyLoadedException) {
                // empty catch block
            }
        }
    }

    public static Client createVmomiClient(URI url, KeyStore trustStore, ThumbprintVerifier verifier) throws URISyntaxException {
        return LookupUtil.createVmomiClient(url, LookupUtil.createClientConfig(trustStore, verifier, url));
    }

    public static Client createVmomiClient(URI url, KeyStore trustStore, ThumbprintVerifier verifier, boolean useSiteAffinity) throws URISyntaxException {
        return LookupUtil.createVmomiClient(url, LookupUtil.createClientConfig(trustStore, verifier, url), useSiteAffinity);
    }

    public static Client createVmomiClient(URI url, KeyStore ks, ThumbprintVerifier verifier, boolean useSiteAffinity, Version version) throws URISyntaxException {
        return LookupUtil.createVmomiClient(url, LookupUtil.createClientConfig(ks, verifier, url), useSiteAffinity, version);
    }

    private static HttpClientConfiguration createClientConfig(KeyStore trustStore, ThumbprintVerifier verifier, URI serverUri) {
        HttpClientConfiguration config = HttpClientConfiguration.Factory.newInstance();
        config.getHttpConfiguration().setTrustStore(trustStore);
        config.getHttpConfiguration().setThumbprintVerifier(verifier);
        return config;
    }

    public static Client createVmomiClient(URI url, HttpClientConfiguration config) throws URISyntaxException {
        return LookupUtil.createVmomiClient(url, config, true);
    }

    public static Client createVmomiClient(URI url, HttpClientConfiguration config, boolean useSiteAffinity) throws URISyntaxException {
        return LookupUtil.createVmomiClient(url, config, true, null);
    }

    public static Client createVmomiClient(URI url, HttpClientConfiguration config, boolean useSiteAffinity, Version clientVersion) throws URISyntaxException {
        String vmodlVersion;
        String string = vmodlVersion = clientVersion != null ? clientVersion.getName() : DEFAULT_VMODL_VERSION;
        if (url == null || url.toString().equals("")) {
            throw new URISyntaxException("", "LS address is empty");
        }
        if (url.getScheme() == null) {
            throw new URISyntaxException(url.toString(), "Invalid LS address");
        }
        LookupUtil.ensureVmodlContextInit();
        VmodlVersionMap versionMap = VmodlVersionMap.Factory.getVmodlVersionMap();
        VmodlVersion version = versionMap.findVersion(VMODL_TYPE, vmodlVersion);
        if (useSiteAffinity) {
            config.setServerEndpointProvider((ServerEndpointProvider)new SiteAffinityServerEndpointProvider(url));
            url = null;
        }
        return Client.Factory.createClient((URI)url, (Class)version.getVersionClass(), (ClientConfiguration)config);
    }

    public static <T> T createStub(Client cli, Class<T> klass, String moid) {
        VmodlTypeMap typeMap = VmodlTypeMap.Factory.getTypeMap();
        return (T)cli.createStub(klass, new ManagedObjectReference(typeMap.getVmodlType(klass).getWsdlName(), moid));
    }

    public static void setAuthContext(Stub s, SamlToken token, PrivateKey privateKey) {
        RequestContextImpl ctx = new RequestContextImpl();
        SignInfoImpl authInfo = new SignInfoImpl(privateKey, token);
        ctx.setSignInfo((SignInfo)authInfo);
        s._setRequestContext((RequestContext)ctx);
    }

    public static ServiceRegistration.Filter siteFilter(String siteId) {
        ServiceRegistration.Filter filter = new ServiceRegistration.Filter();
        filter.setSiteId(siteId);
        return filter;
    }

    public static ServiceRegistration.Filter nodeFilter(String nodeId) {
        ServiceRegistration.Filter filter = new ServiceRegistration.Filter();
        filter.setNodeId(nodeId);
        return filter;
    }

    public static ServiceRegistration.Filter typeFilter(ServiceRegistration.ServiceType serviceType) {
        ServiceRegistration.Filter filter = new ServiceRegistration.Filter();
        filter.setServiceType(serviceType);
        return filter;
    }

    public static ServiceRegistration.Filter endpointTypeFilter(ServiceRegistration.EndpointType endpointType) {
        ServiceRegistration.Filter filter = new ServiceRegistration.Filter();
        filter.setEndpointType(endpointType);
        return filter;
    }
}

