/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.lookup.client.tool;

import com.vmware.vim.lookup.client.tool.CliArgumentDescriptor;
import com.vmware.vim.lookup.client.tool.exception.CliInvalidArgumentException;
import com.vmware.vim.lookup.client.tool.exception.CliUsageException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CliArgumentParser {
    public static Map<String, String> parse(String[] args, List<CliArgumentDescriptor> required, List<CliArgumentDescriptor> optional) throws Exception {
        HashMap<String, String> res = new HashMap<String, String>();
        Iterator<String> itArg = Arrays.asList(args).iterator();
        while (itArg.hasNext()) {
            String argValue;
            String cliOption = itArg.next();
            if (!cliOption.startsWith("--")) {
                throw new CliUsageException(String.format("Command option must start with '--'; '%s'", cliOption));
            }
            CliArgumentDescriptor d = CliArgumentParser.find(required, cliOption);
            if (d == null) {
                d = CliArgumentParser.find(optional, cliOption);
            }
            if (d == null) {
                throw new CliUsageException(String.format("Unexpected command option '%s'", cliOption));
            }
            if (d.getParserAction() == CliArgumentDescriptor.PARSER_ACTION.SWITCH) {
                argValue = "";
            } else {
                if (!itArg.hasNext()) {
                    throw new CliUsageException(String.format("Missing value of command option '%s'", cliOption));
                }
                argValue = itArg.next();
                if (d.getValidator() != null) {
                    try {
                        d.getValidator().validate(argValue);
                    }
                    catch (Exception e) {
                        throw new CliInvalidArgumentException(String.format("Invalid value of command option '%s', value:'%s'", cliOption, argValue), e);
                    }
                }
            }
            res.put(d.getName(), argValue);
        }
        for (CliArgumentDescriptor d : required) {
            if (res.get(d.getName()) != null) continue;
            throw new CliUsageException(String.format("Missing required command option '%s'", d.getCliOption()));
        }
        return res;
    }

    private static CliArgumentDescriptor find(List<CliArgumentDescriptor> descriptors, String cliOption) {
        for (CliArgumentDescriptor d : descriptors) {
            if (!d.getCliOption().equals(cliOption)) continue;
            return d;
        }
        return null;
    }
}

