/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.lookup.client.tool;

import com.vmware.vim.lookup.client.tool.CliArgumentParser;
import com.vmware.vim.lookup.client.tool.command.Command;
import com.vmware.vim.lookup.client.tool.command.Get55Command;
import com.vmware.vim.lookup.client.tool.command.GetCommand;
import com.vmware.vim.lookup.client.tool.command.GetSiteIdCommand;
import com.vmware.vim.lookup.client.tool.command.HelpCommand;
import com.vmware.vim.lookup.client.tool.command.List55Command;
import com.vmware.vim.lookup.client.tool.command.ListCommand;
import com.vmware.vim.lookup.client.tool.command.Register55Command;
import com.vmware.vim.lookup.client.tool.command.RegisterCommand;
import com.vmware.vim.lookup.client.tool.command.Reregister55Command;
import com.vmware.vim.lookup.client.tool.command.ReregisterCommand;
import com.vmware.vim.lookup.client.tool.command.UnregisterCommand;
import com.vmware.vim.lookup.client.tool.exception.CliInvalidArgumentException;
import com.vmware.vim.lookup.client.tool.exception.CliUsageException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class LsTool {
    private static final List<Command> _commands = new ArrayList<Command>();

    public static String app(String[] args) throws Exception {
        if (args.length < 1) {
            throw new CliUsageException("Not enough arguments");
        }
        Command cmd = LsTool.findCommand(args[0], _commands);
        Map<String, String> cliArgs = CliArgumentParser.parse(Arrays.copyOfRange(args, 1, args.length), cmd.getRequiredArguments(), cmd.getOptionalArguments());
        return cmd.execute(cliArgs);
    }

    private static Command findCommand(String cmdId, List<Command> commands) throws Exception {
        cmdId = cmdId.toLowerCase();
        for (Command c : commands) {
            if (!c.getCommandId().toLowerCase().equals(cmdId)) continue;
            return c;
        }
        Command found = null;
        for (Command c : commands) {
            if (!c.getCommandId().toLowerCase().startsWith(cmdId)) continue;
            if (found != null) {
                throw new CliUsageException(String.format("Ambiguous command identifier; %s", cmdId));
            }
            found = c;
        }
        if (found == null) {
            throw new CliUsageException(String.format("Unknown command identifier; %s", cmdId));
        }
        return found;
    }

    public static void main(String[] args) {
        try {
            System.out.print(LsTool.app(args));
            System.out.print("\n");
        }
        catch (CliUsageException e) {
            System.err.println(e.getMessage());
            System.err.print(HelpCommand.createHelpMessage(_commands));
            System.exit(1);
        }
        catch (CliInvalidArgumentException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    static {
        _commands.add(new HelpCommand(_commands));
        _commands.add(new ListCommand());
        _commands.add(new List55Command());
        _commands.add(new RegisterCommand());
        _commands.add(new Register55Command());
        _commands.add(new UnregisterCommand());
        _commands.add(new ReregisterCommand());
        _commands.add(new Reregister55Command());
        _commands.add(new GetCommand());
        _commands.add(new Get55Command());
        _commands.add(new GetSiteIdCommand());
    }
}

