/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.lookup.client.tool.command;

import com.vmware.vim.binding.lookup.LookupService;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vim.lookup.client.tool.CliArgumentDescriptor;
import com.vmware.vim.lookup.client.tool.util.LookupHelper;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Command {
    public static final String ARGNAME_URL = "url";
    public static final String ARGNAME_NO_CHECK_CERT = "no-check-cert";
    public static final String ARGNAME_USER = "user";
    public static final String ARGNAME_PASSWORD = "password";
    public static final String ARGNAME_SPEC = "spec";
    public static final String ARGNAME_ID = "id";
    public static final String ARGNAME_AS_SPEC = "as-spec";
    public static final String ARGNAME_ID_ONLY = "id-only";
    protected static Map<String, CliArgumentDescriptor> _knownArguments = new HashMap<String, CliArgumentDescriptor>();
    private final String _commandId;
    private List<CliArgumentDescriptor> _required;
    private List<CliArgumentDescriptor> _optional;
    private String _helpString;

    protected Command(String commandId) {
        this._commandId = commandId;
        this._required = new ArrayList<CliArgumentDescriptor>();
        this._optional = new ArrayList<CliArgumentDescriptor>();
        this._helpString = "";
    }

    protected Command setRequiredArguments(List<CliArgumentDescriptor> args) {
        this._required = Collections.unmodifiableList(args);
        return this;
    }

    protected Command setOptionalArguments(List<CliArgumentDescriptor> args) {
        this._optional = Collections.unmodifiableList(args);
        return this;
    }

    protected Command setHelpString(String helpString) {
        this._helpString = helpString;
        return this;
    }

    public String getCommandId() {
        return this._commandId;
    }

    public List<CliArgumentDescriptor> getRequiredArguments() {
        return this._required;
    }

    public List<CliArgumentDescriptor> getOptionalArguments() {
        return this._optional;
    }

    public String getHelpString() {
        return this._helpString;
    }

    public abstract String execute(Map<String, String> var1) throws Exception;

    protected static String callLs(Map<String, String> args, LsCall call) throws Exception {
        return Command.callLsEx(args, ServiceRegistration.class, "ServiceRegistration", call);
    }

    protected static String callLs55(Map<String, String> args, LsCall55 call) throws Exception {
        return Command.callLsEx(args, LookupService.class, "lookupService", call);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <T> String callLsEx(Map<String, String> args, Class<T> lsKlass, String moid, LsCallEx<T> call) throws Exception {
        boolean skipCertCheck = args.get(ARGNAME_NO_CHECK_CERT) != null;
        LookupHelper.LsClient lsCli = LookupHelper.createLsClient(args.get(ARGNAME_URL), skipCertCheck);
        try {
            String user = args.get(ARGNAME_USER);
            String password = args.get(ARGNAME_PASSWORD);
            T ls = user == null ? lsCli.createStub(lsKlass, moid) : lsCli.createStub(lsKlass, moid, user, password);
            String string = call.execute(ls);
            return string;
        }
        finally {
            lsCli.shutdown();
        }
    }

    static {
        _knownArguments.put(ARGNAME_URL, new CliArgumentDescriptor(ARGNAME_URL, "--url").setHelpString("URL of lookup service").setValidator(new CliArgumentDescriptor.Validator(){

            @Override
            public void validate(String value) throws Exception {
                URI.create(value);
            }
        }));
        _knownArguments.put(ARGNAME_NO_CHECK_CERT, new CliArgumentDescriptor(ARGNAME_NO_CHECK_CERT, "--no-check-cert").setHelpString("Don't validate the server SSL certificate.").setParserAction(CliArgumentDescriptor.PARSER_ACTION.SWITCH));
        _knownArguments.put(ARGNAME_USER, new CliArgumentDescriptor(ARGNAME_USER, "--user").setHelpString("SSO user name"));
        _knownArguments.put(ARGNAME_PASSWORD, new CliArgumentDescriptor(ARGNAME_PASSWORD, "--password").setHelpString("SSO user password"));
        _knownArguments.put(ARGNAME_SPEC, new CliArgumentDescriptor(ARGNAME_SPEC, "--spec").setHelpString("Service spec file path"));
        _knownArguments.put(ARGNAME_ID, new CliArgumentDescriptor(ARGNAME_ID, "--id").setHelpString("Service identifier"));
        _knownArguments.put(ARGNAME_AS_SPEC, new CliArgumentDescriptor(ARGNAME_AS_SPEC, "--as-spec").setHelpString("Print service in spec file format.").setParserAction(CliArgumentDescriptor.PARSER_ACTION.SWITCH));
        _knownArguments.put(ARGNAME_ID_ONLY, new CliArgumentDescriptor(ARGNAME_ID_ONLY, "--id-only").setHelpString("Output service ID(s) only.").setParserAction(CliArgumentDescriptor.PARSER_ACTION.SWITCH));
    }

    protected static interface LsCallEx<T> {
        public String execute(T var1) throws Exception;
    }

    protected static interface LsCall55
    extends LsCallEx<LookupService> {
    }

    protected static interface LsCall
    extends LsCallEx<ServiceRegistration> {
    }
}

