/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.lookup.client.tool.command;

import com.vmware.vim.lookup.client.tool.CliArgumentDescriptor;
import com.vmware.vim.lookup.client.tool.command.Command;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;

public class HelpCommand
extends Command {
    private final List<Command> _commands;

    public HelpCommand(List<Command> commands) {
        super("help");
        this.setHelpString("Print help message");
        this._commands = commands;
    }

    @Override
    public String execute(Map<String, String> args) throws Exception {
        return HelpCommand.createHelpMessage(this._commands);
    }

    public static String createHelpMessage(List<Command> commands) {
        StringBuffer sb = new StringBuffer();
        sb.append("Usage:\n\n");
        for (Command c : commands) {
            sb.append(HelpCommand.createHelpMessage(c)).append("\n");
        }
        sb.append("\n");
        HelpCommand.appendResourceContent(sb, "svcspec-sample.properties", "Sample service registration spec");
        HelpCommand.appendResourceContent(sb, "svcspec55-sample.properties", "Sample service registration 5.5 spec");
        return sb.toString();
    }

    private static void appendResourceContent(StringBuffer sb, String resName, String title) {
        sb.append("----------------------------------------\n");
        sb.append(title).append("\n");
        sb.append("----------------------------------------\n");
        try {
            InputStream in = ClassLoader.getSystemClassLoader().getResourceAsStream(resName);
            BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            int c = br.read();
            while (c != -1) {
                sb.append((char)c);
                c = br.read();
            }
        }
        catch (IOException e) {
            sb.append(String.format("Failed to read resource %s [%s]\n", resName, e));
        }
        sb.append("\n");
    }

    private static String createHelpMessage(Command c) {
        StringBuffer sb = new StringBuffer();
        sb.append(c.getCommandId()).append(" - ").append(c.getHelpString()).append("\n");
        for (CliArgumentDescriptor d : c.getRequiredArguments()) {
            sb.append(HelpCommand.createHelpMessage(d, false)).append("\n");
        }
        for (CliArgumentDescriptor d : c.getOptionalArguments()) {
            sb.append(HelpCommand.createHelpMessage(d, true)).append("\n");
        }
        return sb.toString();
    }

    private static String createHelpMessage(CliArgumentDescriptor d, boolean isOptional) {
        StringBuffer sb = new StringBuffer();
        sb.append("    ").append(isOptional ? "[" : "").append(d.getCliOption()).append(d.getParserAction() == CliArgumentDescriptor.PARSER_ACTION.SWITCH ? "" : " " + d.getCliOption().substring(2).toUpperCase()).append(isOptional ? "]" : "").append(" - ").append(d.getHelpString());
        return sb.toString();
    }
}

