/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.lookup.client.tool.command;

import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vim.lookup.client.tool.CliArgumentDescriptor;
import com.vmware.vim.lookup.client.tool.command.Command;
import com.vmware.vim.lookup.client.tool.command.OutputHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ListCommand
extends Command {
    private static final String ARGNAME_PRODUCT = "product";
    private static final String ARGNAME_TYPE = "type";
    private static final String ARGNAME_NODE = "node";
    private static final String ARGNAME_SITE = "site";
    private static final String ARGNAME_EP_PROTO = "ep-proto";
    private static final String ARGNAME_EP_TYPE = "ep-type";

    public ListCommand() {
        super("list");
        this.setRequiredArguments(ListCommand.getRequiredArgs());
        this.setOptionalArguments(ListCommand.getOptionalArgs());
        this.setHelpString("List service registrations using specified search filter");
    }

    private static List<CliArgumentDescriptor> getRequiredArgs() {
        return Arrays.asList(Command._knownArguments.get("url"));
    }

    private static List<CliArgumentDescriptor> getOptionalArgs() {
        ArrayList<CliArgumentDescriptor> args = new ArrayList<CliArgumentDescriptor>();
        args.add(Command._knownArguments.get("no-check-cert"));
        args.add(Command._knownArguments.get("as-spec"));
        args.add(Command._knownArguments.get("id-only"));
        args.add(new CliArgumentDescriptor(ARGNAME_PRODUCT, "--product").setHelpString("Service product value of search filter"));
        args.add(new CliArgumentDescriptor(ARGNAME_TYPE, "--type").setHelpString("Service type value of search filter"));
        args.add(new CliArgumentDescriptor(ARGNAME_NODE, "--node").setHelpString("Node identifier value of search filter"));
        args.add(new CliArgumentDescriptor(ARGNAME_SITE, "--site").setHelpString("Site identifier value of search filter"));
        args.add(new CliArgumentDescriptor(ARGNAME_EP_PROTO, "--ep-proto").setHelpString("Endpoint protocol value of search filter"));
        args.add(new CliArgumentDescriptor(ARGNAME_EP_TYPE, "--ep-type").setHelpString("Endpoint type value of search filter"));
        return args;
    }

    @Override
    public String execute(Map<String, String> args) throws Exception {
        final ServiceRegistration.Filter filter = ListCommand.getFilter(args);
        final boolean printAsSpec = args.get("as-spec") != null;
        final boolean printIdOnly = args.get("id-only") != null;
        return ListCommand.callLs(args, new Command.LsCall(){

            @Override
            public String execute(ServiceRegistration ls) throws Exception {
                ServiceRegistration.Info[] infos = ls.list(filter);
                StringBuilder sbIDs = new StringBuilder();
                StringBuilder sbInfos = new StringBuilder();
                boolean firstTime = true;
                for (ServiceRegistration.Info info : infos) {
                    sbIDs.append(info.getServiceId()).append("\n");
                    if (!firstTime) {
                        sbInfos.append("-------------------------------------------------------\n");
                    }
                    sbInfos.append(printAsSpec ? OutputHelper.formatServiceAsSpec(info) : OutputHelper.prettyFormatService(info));
                    firstTime = false;
                }
                return printIdOnly ? sbIDs.toString() : sbInfos.toString();
            }
        });
    }

    private static ServiceRegistration.Filter getFilter(Map<String, String> args) {
        String ep_type;
        String svcType;
        ServiceRegistration.Filter filter = new ServiceRegistration.Filter();
        String svcProduct = args.get(ARGNAME_PRODUCT);
        if (null == svcProduct) {
            svcProduct = "";
        }
        if (null == (svcType = args.get(ARGNAME_TYPE))) {
            svcType = "";
        }
        ServiceRegistration.ServiceType type = new ServiceRegistration.ServiceType();
        type.setProduct(svcProduct);
        type.setType(svcType);
        filter.setServiceType(type);
        filter.setNodeId(args.get(ARGNAME_NODE));
        filter.setSiteId(args.get(ARGNAME_SITE));
        String protocol = args.get(ARGNAME_EP_PROTO);
        if (null == protocol) {
            protocol = "";
        }
        if (null == (ep_type = args.get(ARGNAME_EP_TYPE))) {
            ep_type = "";
        }
        ServiceRegistration.EndpointType endpointType = new ServiceRegistration.EndpointType();
        endpointType.setProtocol(protocol);
        endpointType.setType(ep_type);
        filter.setEndpointType(endpointType);
        return filter;
    }
}

