/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.lookup.client.tool.command;

import com.vmware.vim.binding.lookup.Service;
import com.vmware.vim.binding.lookup.ServiceEndpoint;
import com.vmware.vim.binding.lookup.ServiceRegistration;

class OutputHelper {
    OutputHelper() {
    }

    public static String prettyFormatService(ServiceRegistration.Info info) {
        ServiceRegistration.ServiceType serviceType;
        StringBuilder sb = new StringBuilder();
        int indent = 1;
        if (OutputHelper.appendIfSet(sb, "Name: %s", info.getServiceNameDefault(), indent)) {
            if (!OutputHelper.appendIfSet(sb, " (%s)%n", info.getServiceNameResourceKey(), 0)) {
                sb.append('\n');
            }
        } else {
            OutputHelper.appendIfSet(sb, "Name: %s%n", info.getServiceNameResourceKey(), indent);
        }
        if (OutputHelper.appendIfSet(sb, "Description: %s", info.getServiceDescriptionDefault(), indent)) {
            if (!OutputHelper.appendIfSet(sb, " (%s)%n", info.getServiceDescriptionResourceKey(), 0)) {
                sb.append('\n');
            }
        } else {
            OutputHelper.appendIfSet(sb, "Description: %s%n", info.getServiceDescriptionResourceKey(), indent);
        }
        if ((serviceType = info.getServiceType()) != null) {
            OutputHelper.appendIfSet(sb, "Service Product: %s%n", serviceType.getProduct(), indent);
            OutputHelper.appendIfSet(sb, "Service Type: %s%n", serviceType.getType(), indent);
        }
        OutputHelper.appendIfSet(sb, "Service ID: %s%n", info.getServiceId(), indent);
        OutputHelper.appendIfSet(sb, "Site ID: %s%n", info.getSiteId(), indent);
        OutputHelper.appendIfSet(sb, "Node ID: %s%n", info.getNodeId(), indent);
        OutputHelper.appendIfSet(sb, "Owner ID: %s%n", info.getOwnerId(), indent);
        OutputHelper.appendIfSet(sb, "Version: %s%n", info.getServiceVersion(), indent);
        if (OutputHelper.appendIfSet(sb, "Vendor: %s", info.getVendorNameDefault(), indent)) {
            if (!OutputHelper.appendIfSet(sb, " (%s)%n", info.getVendorNameResourceKey(), 0)) {
                sb.append('\n');
            }
        } else {
            OutputHelper.appendIfSet(sb, "Vendor: %s%n", info.getVendorNameResourceKey(), indent);
        }
        if (OutputHelper.appendIfSet(sb, "Vendor Product: %s", info.getVendorProductInfoDefault(), indent)) {
            if (!OutputHelper.appendIfSet(sb, " (%s)%n", info.getVendorProductInfoResourceKey(), 0)) {
                sb.append('\n');
            }
        } else {
            OutputHelper.appendIfSet(sb, "Vendor Product: %s%n", info.getVendorProductInfoResourceKey(), indent);
        }
        if (info.getServiceEndpoints() != null) {
            OutputHelper.append(sb, "Endpoints:%s%n", "", indent);
            for (ServiceRegistration.Endpoint endpoint : info.getServiceEndpoints()) {
                OutputHelper.formatEndpoint(sb, endpoint, indent + 1);
            }
        }
        if (info.getServiceAttributes() != null) {
            OutputHelper.append(sb, "Attributes:%s%n", "", indent);
            for (ServiceRegistration.Endpoint endpoint : info.getServiceAttributes()) {
                OutputHelper.formatAttribute(sb, (ServiceRegistration.Attribute)endpoint, indent + 1);
            }
        }
        return sb.toString();
    }

    public static String prettyFormatService(Service svc) {
        StringBuilder sb = new StringBuilder();
        int indent = 1;
        OutputHelper.appendIfSet(sb, "Name: %s%n", svc.getServiceName(), indent);
        OutputHelper.appendIfSet(sb, "Description: %s%n", svc.getDescription(), indent);
        OutputHelper.appendIfSet(sb, "Service Type: %s%n", svc.getType(), indent);
        OutputHelper.appendIfSet(sb, "Product ID: %s%n", svc.getProductId(), indent);
        OutputHelper.appendIfSet(sb, "Service ID: %s%n", svc.getServiceId(), indent);
        OutputHelper.appendIfSet(sb, "Site ID: %s%n", svc.getViSite(), indent);
        OutputHelper.appendIfSet(sb, "Owner ID: %s%n", svc.getOwnerId(), indent);
        OutputHelper.appendIfSet(sb, "Version: %s%n", svc.getVersion(), indent);
        if (svc.getEndpoints() != null) {
            OutputHelper.append(sb, "Endpoints:%s%n", "", indent);
            for (ServiceEndpoint e : svc.getEndpoints()) {
                OutputHelper.formatEndpoint(sb, e, indent + 1);
            }
        }
        return sb.toString();
    }

    public static String formatServiceAsSpec(ServiceRegistration.Info info) {
        String name;
        StringBuilder sb = new StringBuilder();
        OutputHelper.appendProperty(sb, "serviceId", info.getServiceId());
        OutputHelper.appendProperty(sb, "serviceVersion", info.getServiceVersion());
        OutputHelper.appendProperty(sb, "ownerId", info.getOwnerId());
        OutputHelper.appendProperty(sb, "serviceType.product", info.getServiceType().getProduct());
        OutputHelper.appendProperty(sb, "serviceType.type", info.getServiceType().getType());
        OutputHelper.appendProperty(sb, "nodeId", info.getNodeId());
        OutputHelper.appendProperty(sb, "serviceNameResourceKey", info.getServiceNameResourceKey());
        OutputHelper.appendProperty(sb, "serviceNameDefault", info.getServiceNameDefault());
        OutputHelper.appendProperty(sb, "serviceDescriptionResourceKey", info.getServiceDescriptionResourceKey());
        OutputHelper.appendProperty(sb, "serviceDescriptionDefault", info.getServiceDescriptionDefault());
        if (info.getServiceAttributes() != null) {
            int a_i = 0;
            for (ServiceRegistration.Attribute attribute : info.getServiceAttributes()) {
                name = "attribute" + a_i + ".";
                OutputHelper.formatAttributeAsSpec(sb, name, attribute);
                ++a_i;
            }
        }
        int ep_i = 0;
        for (ServiceRegistration.Attribute attribute : info.getServiceEndpoints()) {
            name = "endpoint" + ep_i + ".";
            OutputHelper.formatEndpointAsSpec(sb, name, (ServiceRegistration.Endpoint)attribute);
            ++ep_i;
        }
        return sb.toString();
    }

    public static String formatServiceAsSpec(Service svc) {
        StringBuilder sb = new StringBuilder();
        OutputHelper.appendProperty(sb, "serviceId", svc.getServiceId());
        OutputHelper.appendProperty(sb, "version", svc.getVersion());
        OutputHelper.appendProperty(sb, "type", svc.getType().toString());
        OutputHelper.appendProperty(sb, "ownerId", svc.getOwnerId());
        OutputHelper.appendProperty(sb, "serviceName", svc.getServiceName());
        OutputHelper.appendProperty(sb, "description", svc.getDescription());
        OutputHelper.appendProperty(sb, "productId", svc.getProductId());
        int ep_i = 0;
        for (ServiceEndpoint ep : svc.getEndpoints()) {
            String name = "endpoint" + ep_i + ".";
            OutputHelper.formatEndpointAsSpec(sb, name, ep);
            ++ep_i;
        }
        return sb.toString();
    }

    private static boolean appendIfSet(StringBuilder sb, String format, Object value, int indent) {
        if (value == null || value.toString().trim().isEmpty()) {
            return false;
        }
        OutputHelper.append(sb, format, value, indent);
        return true;
    }

    private static void append(StringBuilder sb, String format, Object value, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append('\t');
        }
        sb.append(String.format(format, value.toString()));
    }

    private static void formatAttribute(StringBuilder sb, ServiceRegistration.Attribute at, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append('\t');
        }
        sb.append(String.format("%s: %s%n", at.getKey(), at.getValue()));
    }

    private static void formatEndpoint(StringBuilder sb, ServiceRegistration.Endpoint e, int indent) {
        ServiceRegistration.EndpointType type = e.getEndpointType();
        if (type != null) {
            OutputHelper.appendIfSet(sb, "Type: %s%n", type.getType(), indent);
            OutputHelper.appendIfSet(sb, "Protocol: %s%n", type.getProtocol(), indent);
        }
        OutputHelper.appendIfSet(sb, "URL: %s%n", e.getUrl(), indent);
        String[] trusts = e.getSslTrust();
        if (null != trusts) {
            for (int i = 0; i < trusts.length; ++i) {
                OutputHelper.appendIfSet(sb, "SSL trust: %s%n", trusts[i], indent);
            }
        }
        if (e.getEndpointAttributes() != null) {
            OutputHelper.append(sb, "Endpoint Attributes:%s%n", "", indent);
            for (ServiceRegistration.Attribute a : e.getEndpointAttributes()) {
                OutputHelper.formatAttribute(sb, a, indent + 1);
            }
        }
    }

    private static void formatEndpoint(StringBuilder sb, ServiceEndpoint e, int indent) {
        OutputHelper.appendIfSet(sb, "URL: %s%n", e.getUrl(), indent);
        OutputHelper.appendIfSet(sb, "Protocol: %s%n", e.getProtocol(), indent);
        OutputHelper.appendIfSet(sb, "SSL trust: %s%n", e.getSslTrustAnchor(), indent);
    }

    private static void appendProperty(StringBuilder sb, String name, String value) {
        if (value != null && !value.isEmpty()) {
            sb.append(String.format("%s=%s%n", name, value));
        }
    }

    private static void formatAttributeAsSpec(StringBuilder sb, String nameBase, ServiceRegistration.Attribute attr) {
        OutputHelper.appendProperty(sb, nameBase + "key", attr.getKey());
        OutputHelper.appendProperty(sb, nameBase + "value", attr.getValue());
    }

    private static void formatEndpointAsSpec(StringBuilder sb, String nameBase, ServiceRegistration.Endpoint ep) {
        OutputHelper.appendProperty(sb, nameBase + "type.protocol", ep.getEndpointType().getProtocol());
        OutputHelper.appendProperty(sb, nameBase + "type.id", ep.getEndpointType().getType());
        OutputHelper.appendProperty(sb, nameBase + "url", ep.getUrl().toASCIIString());
        String[] sslTrust = ep.getSslTrust();
        if (sslTrust != null) {
            int c_i = 0;
            for (String string : sslTrust) {
                String string2 = string.replace("\r", "").replace("\n", "");
                OutputHelper.appendProperty(sb, nameBase + "ssltrust" + c_i, string2);
                ++c_i;
            }
        }
        if (ep.getEndpointAttributes() != null) {
            int a_i = 0;
            for (String string : ep.getEndpointAttributes()) {
                OutputHelper.formatAttributeAsSpec(sb, nameBase + "data" + a_i + ".", (ServiceRegistration.Attribute)string);
                ++a_i;
            }
        }
    }

    private static void formatEndpointAsSpec(StringBuilder sb, String nameBase, ServiceEndpoint ep) {
        OutputHelper.appendProperty(sb, nameBase + "url", ep.getUrl().toASCIIString());
        String cert = ep.getSslTrustAnchor();
        OutputHelper.appendProperty(sb, nameBase + "protocol", ep.getProtocol());
        if (cert != null) {
            cert = cert.replace("\r", "").replace("\n", "");
            OutputHelper.appendProperty(sb, nameBase + "ssltrust", cert);
        }
    }
}

