/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.lookup.client.tool.command;

import com.vmware.vim.binding.lookup.LookupService;
import com.vmware.vim.binding.lookup.Service;
import com.vmware.vim.binding.lookup.ServiceRegistrationForm;
import com.vmware.vim.lookup.client.ServiceFormFactory;
import com.vmware.vim.lookup.client.tool.CliArgumentDescriptor;
import com.vmware.vim.lookup.client.tool.command.Command;
import com.vmware.vim.lookup.client.tool.exception.CliInvalidArgumentException;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class Register55Command
extends Command {
    public Register55Command() {
        super("register55");
        this.setRequiredArguments(Register55Command.getRequiredArgs());
        this.setOptionalArguments(Register55Command.getOptionalArgs());
        this.setHelpString("Register VC55 service; return service ID");
    }

    private static List<CliArgumentDescriptor> getRequiredArgs() {
        return Arrays.asList(Command._knownArguments.get("url"), Command._knownArguments.get("user"), Command._knownArguments.get("password"), Command._knownArguments.get("spec"));
    }

    private static List<CliArgumentDescriptor> getOptionalArgs() {
        return Arrays.asList(Command._knownArguments.get("no-check-cert"));
    }

    @Override
    public String execute(Map<String, String> args) throws Exception {
        final ServiceRegistrationForm form = Register55Command.createForm(args.get("spec"));
        return Register55Command.callLs55(args, new Command.LsCall55(){

            @Override
            public String execute(LookupService ls) throws Exception {
                Service s = ls.registerService(form);
                return s.getServiceId();
            }
        });
    }

    private static ServiceRegistrationForm createForm(String specFile) throws Exception {
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(specFile));
        }
        catch (IOException e) {
            throw new CliInvalidArgumentException(String.format("Failed to open specified spec file '%s'", specFile), e);
        }
        try {
            return ServiceFormFactory.createForm(props);
        }
        catch (Exception e) {
            throw new CliInvalidArgumentException(String.format("Failed to create registration form from file '%s'", specFile), e);
        }
    }
}

