/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.lookup.client.tool.util;

import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vim.lookup.client.LookupUtil;
import com.vmware.vim.lookup.client.tool.util.AllowAllThumbprintVerifier;
import com.vmware.vim.lookup.client.tool.util.SamlTokenUtil;
import com.vmware.vim.lookup.client.tool.util.Version;
import com.vmware.vim.lookup.client.tool.util.VmwKeyStore;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.core.Stub;
import java.net.URI;
import java.security.KeyStore;

public class LookupHelper {
    public static LsClient createLsClient(String uri, boolean noCertCheck) throws Exception {
        KeyStore ks = noCertCheck ? null : VmwKeyStore.getTrustStore();
        return new LsClient(new URI(uri), ks);
    }

    public static LsClient createLsClient(String uri, boolean noCertCheck, boolean useSiteAffinity) throws Exception {
        KeyStore ks = noCertCheck ? null : VmwKeyStore.getTrustStore();
        return new LsClient(new URI(uri), ks, useSiteAffinity, null);
    }

    public static LsClient createLsClient(String uri, boolean noCertCheck, boolean useSiteAffinity, Version version) throws Exception {
        KeyStore ks = noCertCheck ? null : VmwKeyStore.getTrustStore();
        return new LsClient(new URI(uri), ks, useSiteAffinity, version);
    }

    public static class LsClient {
        private final URI _uri;
        private final KeyStore _ks;
        private final Client _client;

        private LsClient(URI uri, KeyStore ks) throws Exception {
            this(uri, ks, true, null);
        }

        private LsClient(URI uri, KeyStore ks, boolean useSiteAffinity, Version version) throws Exception {
            this._uri = uri;
            this._ks = ks;
            AllowAllThumbprintVerifier v = ks == null ? new AllowAllThumbprintVerifier() : null;
            this._client = LookupUtil.createVmomiClient(uri, ks, v, useSiteAffinity, version);
        }

        public void shutdown() {
            this._client.shutdown();
        }

        public URI getUri() {
            return this._uri;
        }

        public <T> T createStub(Class<T> klass, String moid) {
            return LookupUtil.createStub(this._client, klass, moid);
        }

        public <T> T createStub(Class<T> klass, String moid, String username, String password) throws Exception {
            SamlToken token = SamlTokenUtil.acquireBearerToken(this.createStub(ServiceRegistration.class, "ServiceRegistration"), username, password, this._ks);
            T ls = this.createStub(klass, moid);
            LookupUtil.setAuthContext((Stub)ls, token, null);
            return ls;
        }
    }
}

