/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.lookup.client.tool.util;

import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vim.lookup.client.LookupUtil;
import com.vmware.vim.lookup.client.constants.EndpointTypes;
import com.vmware.vim.lookup.client.constants.ServiceTypes;
import com.vmware.vim.lookup.client.tool.exception.SsoNotFoundException;
import com.vmware.vim.lookup.client.tool.util.SsoConnConfig;
import com.vmware.vim.sso.admin.util.CertificateUtil;
import java.security.cert.X509Certificate;

class SsoEndpointUtil {
    SsoEndpointUtil() {
    }

    static SsoConnConfig createSsoConnConfig(ServiceRegistration ls) throws SsoNotFoundException {
        SsoConnConfig connInfo = new SsoConnConfig();
        ServiceRegistration.Info sso = SsoEndpointUtil.findSso(ls);
        connInfo.put(SsoConnConfig.EndpointType.ADMIN, SsoEndpointUtil.createEndpointConnConfig(SsoEndpointUtil.findSsoEndpoint(sso, EndpointTypes.SSO_ADMIN)));
        connInfo.put(SsoConnConfig.EndpointType.STS, SsoEndpointUtil.createEndpointConnConfig(SsoEndpointUtil.findSsoEndpoint(sso, EndpointTypes.SSO_STS)));
        return connInfo;
    }

    private static ServiceRegistration.Info findSso(ServiceRegistration ls) throws SsoNotFoundException {
        ServiceRegistration.Info[] infos = ls.list(LookupUtil.typeFilter(ServiceTypes.SSO));
        if (infos == null || infos.length < 1) {
            throw new SsoNotFoundException("SSO not found in lookup service");
        }
        return infos[0];
    }

    private static ServiceRegistration.Endpoint findSsoEndpoint(ServiceRegistration.Info sso, ServiceRegistration.EndpointType type) throws SsoNotFoundException {
        for (ServiceRegistration.Endpoint ep : sso.getServiceEndpoints()) {
            if (!SsoEndpointUtil.endpointTypeEquals(type, ep.getEndpointType())) continue;
            return ep;
        }
        throw new SsoNotFoundException(String.format("Endpoint (protocol: %s, type: %s) not found in SSO service, node %s", type.getProtocol(), type.getType(), sso.getNodeId()));
    }

    private static boolean endpointTypeEquals(ServiceRegistration.EndpointType type1, ServiceRegistration.EndpointType type2) {
        return type1.getProtocol().equals(type2.getProtocol()) && type1.getType().equals(type2.getType());
    }

    private static SsoConnConfig.EndpointConnConfig createEndpointConnConfig(ServiceRegistration.Endpoint endpoint) {
        String[] sslTrusts = endpoint.getSslTrust();
        X509Certificate[] certs = null;
        if (sslTrusts != null && sslTrusts.length > 0) {
            certs = new X509Certificate[sslTrusts.length];
            for (int i = 0; i < sslTrusts.length; ++i) {
                certs[i] = CertificateUtil.decodeCertificate((String)sslTrusts[i]);
            }
        }
        return new SsoConnConfig.EndpointConnConfig(endpoint.getUrl(), certs);
    }
}

