/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.lookup.client.tool.util;

import com.vmware.provider.VecsLoadStoreParameter;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmwKeyStore {
    private static final Log _log = LogFactory.getLog(VmwKeyStore.class);
    private static final String VECS_TRUST_STORE = "TRUSTED_ROOTS";

    public static KeyStore getVecsStore(String store) throws Exception {
        KeyStore ret = KeyStore.getInstance("VKS");
        ret.load((KeyStore.LoadStoreParameter)new VecsLoadStoreParameter(store));
        return ret;
    }

    public static KeyStore getTrustStore() throws Exception {
        return VmwKeyStore.getVecsStore(VECS_TRUST_STORE);
    }

    public static X509Certificate[] getTrustStoreArray() throws Exception {
        KeyStore trustStore = VmwKeyStore.getTrustStore();
        ArrayList<X509Certificate> ret = new ArrayList<X509Certificate>();
        Enumeration<String> aliases = trustStore.aliases();
        while (aliases.hasMoreElements()) {
            ret.add((X509Certificate)trustStore.getCertificate(aliases.nextElement()));
        }
        return ret.toArray(new X509Certificate[ret.size()]);
    }
}

