/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.security.impl;

import com.vmware.vim.binding.lookup.SearchCriteria;
import com.vmware.vim.binding.lookup.Service;
import com.vmware.vim.binding.lookup.ServiceEndpoint;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.security.CertificateUtil;
import com.vmware.vise.vim.commons.vcservice.ServerInfoEx;
import com.vmware.vise.vim.commons.vcservice.VcSource;
import com.vmware.vise.vim.lookup.LookupService;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LookupServiceVcSource
implements VcSource {
    private LookupService _lookupService;
    private static final String VC_TYPE = "urn:vc";
    private static final Log _logger = LogFactory.getLog(LookupServiceVcSource.class);

    public LookupServiceVcSource(LookupService lookupService) {
        this._lookupService = lookupService;
    }

    public List<ServerInfoEx> getVcs() {
        ArrayList<ServerInfoEx> arrayList = new ArrayList<ServerInfoEx>();
        try {
            SearchCriteria searchCriteria = new SearchCriteria();
            searchCriteria.serviceType = new URI(VC_TYPE);
            Service[] serviceArray = this._lookupService.find(searchCriteria);
            if (serviceArray == null) {
                return arrayList;
            }
            for (Service service : serviceArray) {
                if (service.endpoints == null || service.endpoints.length != 1) continue;
                ServerInfoEx serverInfoEx = new ServerInfoEx();
                ServiceEndpoint serviceEndpoint = service.endpoints[0];
                serverInfoEx.serviceUrl = serviceEndpoint.url.toString();
                _logger.info((Object)String.format("Found vCenter Server %1s from Lookup Service", serverInfoEx.serviceUrl));
                if (!StringUtil.isNullOrEmpty((String)serviceEndpoint.sslTrustAnchor)) {
                    String string = serviceEndpoint.sslTrustAnchor;
                    try {
                        String string2;
                        serverInfoEx.thumbprint = string2 = CertificateUtil.getThumbprint((String)string);
                    }
                    catch (Exception exception) {
                        _logger.error((Object)("Error when extracting thumbprint from certificate for vc " + serverInfoEx.serviceUrl));
                    }
                }
                arrayList.add(serverInfoEx);
            }
        }
        catch (Exception exception) {
            _logger.info((Object)("Error when fetching vc's from LookupService - " + exception.getMessage()));
        }
        return arrayList;
    }

    public String getServiceIdOfLocalVc() {
        return "";
    }
}

