/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.spbm.dataprovider;

import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.provider.DataProvider;
import com.vmware.vim.binding.pbm.ServerObjectRef;
import com.vmware.vim.binding.pbm.compliance.ComplianceManager;
import com.vmware.vim.binding.pbm.profile.QueryProfileResult;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.security.LegacyAuthorizationService;
import com.vmware.vsphere.client.spbm.PbmService;
import com.vmware.vsphere.client.spbm.PbmServiceFactory;
import com.vmware.vsphere.client.spbm.util.ManagedUtil;
import com.vmware.vsphere.client.spbm.util.PbmSessionUtil;
import com.vmware.vsphere.client.spbm.util.PbmUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SpbmDataProviderImpl
implements DataProvider {
    private static final Log _logger = LogFactory.getLog(SpbmDataProviderImpl.class);
    private static final String VIRTUAL_MACHINE_MODEL = "VirtualMachine";
    private static final String PROPERTY_VM_COMPLIANCE_STATUS = "VirtualMachine/pbm:storProfComplStatus";
    private static final String PROPERTY_VM_HAS_ROLLUP_COMPLIANCE = "VirtualMachine/pbm:hasRollupComplianceResult";
    private static final String VM_SPBM_OUT_OF_DATE_STATUS = "out-of-date";
    private final PbmServiceFactory _pbmServiceFactory;
    private final LegacyAuthorizationService _authorizationService;
    private final QueryExecutor _queryExecutor;
    private final QuerySpecBuilder _querySpecBuilder;
    private final HttpSession _httpSession;
    private final String _vcGuid;
    private static final ResultSet EMPTY_RESULT = new ResultSet(null, null, Integer.valueOf(0));

    public SpbmDataProviderImpl(PbmServiceFactory pbmServiceFactory, LegacyAuthorizationService authorizationService, QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder, HttpSession httpSession, String vcGuid) {
        this._pbmServiceFactory = pbmServiceFactory;
        this._authorizationService = authorizationService;
        this._queryExecutor = queryExecutor;
        this._querySpecBuilder = querySpecBuilder;
        this._httpSession = httpSession;
        this._vcGuid = vcGuid;
    }

    public ResultSet executeQuery(Query query) {
        if (query.getFilter() == null) {
            return EMPTY_RESULT;
        }
        PbmService pbmService = this.getSpbmService();
        if (pbmService == null) {
            return EMPTY_RESULT;
        }
        ArrayList<Set<ManagedObjectReference>> vmResults = new ArrayList<Set<ManagedObjectReference>>();
        for (PropertyPredicate propPredicate : query.getFilter().getCriteria()) {
            if (PROPERTY_VM_COMPLIANCE_STATUS.equals(propPredicate.getProperty())) {
                if (propPredicate.getOperator() == PropertyPredicate.ComparisonOperator.EQUAL && propPredicate.getComparableValue() instanceof String) {
                    String complianceStatus = (String)propPredicate.getComparableValue();
                    vmResults.add(this.getVmsByCompliance(complianceStatus, pbmService));
                    continue;
                }
                if (propPredicate.getOperator() != PropertyPredicate.ComparisonOperator.IN || !(propPredicate.getComparableValue() instanceof Collection)) continue;
                HashSet<ManagedObjectReference> vmsByCompliance = new HashSet<ManagedObjectReference>();
                for (Object complianceStatusObj : (Collection)propPredicate.getComparableValue()) {
                    if (complianceStatusObj == null || !(complianceStatusObj instanceof String)) continue;
                    String complianceStatus = (String)complianceStatusObj;
                    vmsByCompliance.addAll(this.getVmsByCompliance(complianceStatus, pbmService));
                }
                vmResults.add(vmsByCompliance);
                continue;
            }
            if (PROPERTY_VM_HAS_ROLLUP_COMPLIANCE.equals(propPredicate.getProperty())) {
                if (!(propPredicate.getComparableValue() instanceof Boolean)) continue;
                boolean hasRollupComplianceValue = (Boolean)propPredicate.getComparableValue();
                if (hasRollupComplianceValue) {
                    vmResults.add(this.getAllVmsWithProfiles(pbmService));
                    continue;
                }
                Set<ManagedObjectReference> vmsWithoutProfiles = this.getAllVms();
                vmsWithoutProfiles.removeAll(this.getAllVmsWithProfiles(pbmService));
                vmResults.add(vmsWithoutProfiles);
                continue;
            }
            _logger.error((Object)("Unsupported propPredicate: " + propPredicate.getProperty()));
            throw new IllegalArgumentException("Unsupported propPredicate: " + propPredicate.getProperty());
        }
        Set<ManagedObjectReference> resultVmSet = this.mergeResultSets(query.getFilter().getOperator(), vmResults);
        return this.buildResultSet(query, resultVmSet);
    }

    private Set<ManagedObjectReference> mergeResultSets(LogicalOperator operator, List<Set<ManagedObjectReference>> resultSets) {
        Set<ManagedObjectReference> result;
        block3: {
            block4: {
                if (resultSets == null || resultSets.isEmpty()) {
                    return new HashSet<ManagedObjectReference>();
                }
                result = resultSets.get(0);
                if (resultSets.size() <= 1) break block3;
                if (operator != LogicalOperator.AND) break block4;
                for (int i = 1; i < resultSets.size(); ++i) {
                    result.retainAll((Collection)resultSets.get(i));
                }
                break block3;
            }
            if (operator != LogicalOperator.OR) break block3;
            for (int i = 1; i < resultSets.size(); ++i) {
                result.addAll((Collection<ManagedObjectReference>)resultSets.get(i));
            }
        }
        return result;
    }

    private ResultSet buildResultSet(Query query, Set<ManagedObjectReference> resultVmSet) {
        if (resultVmSet.isEmpty()) {
            return EMPTY_RESULT;
        }
        boolean includeTypeInResults = query.getProperties().contains("@type");
        ArrayList<ResourceItem> resourceItems = new ArrayList<ResourceItem>();
        for (ManagedObjectReference vmRef : resultVmSet) {
            LinkedList<Object> resourceItemValues = new LinkedList<Object>();
            resourceItemValues.add(vmRef);
            if (includeTypeInResults) {
                resourceItemValues.add(vmRef.getType());
            }
            ResourceItem resourceItem = new ResourceItem(resourceItemValues);
            resourceItems.add(resourceItem);
        }
        LinkedList<String> properties = new LinkedList<String>();
        properties.add("@modelKey");
        if (includeTypeInResults) {
            properties.add("@type");
        }
        ResultSet result = new ResultSet(properties, resourceItems, query.getWithTotalCount() ? Integer.valueOf(resultVmSet.size()) : null);
        return result;
    }

    public QuerySchema getSchema() {
        HashMap<String, QuerySchema.PropertyInfo> propertyInfoByQualifiedName = new HashMap<String, QuerySchema.PropertyInfo>();
        propertyInfoByQualifiedName.put(PROPERTY_VM_COMPLIANCE_STATUS, QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.STRING));
        propertyInfoByQualifiedName.put(PROPERTY_VM_HAS_ROLLUP_COMPLIANCE, QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.BOOLEAN));
        return QuerySchema.forProperties(propertyInfoByQualifiedName);
    }

    private Set<ManagedObjectReference> getAllVmsWithProfiles(PbmService pbmService) {
        HashSet<ManagedObjectReference> result = new HashSet<ManagedObjectReference>();
        try {
            QueryProfileResult[] profileResults = pbmService.getProfileManager().queryAssociatedEntities(null);
            if (profileResults != null) {
                for (QueryProfileResult profileResult : profileResults) {
                    ManagedObjectReference vmRef;
                    if (profileResult == null || profileResult.object == null || (vmRef = ManagedUtil.serverObjectRefToVmMor(profileResult.object, profileResult.object.serverUuid)) == null) continue;
                    result.add(vmRef);
                }
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed to retrieve VMs with profiles. ", (Throwable)ex);
        }
        return result;
    }

    private Set<ManagedObjectReference> getAllVms() {
        HashSet<ManagedObjectReference> result = new HashSet<ManagedObjectReference>();
        PropertyConstraint constraint = new PropertyConstraint();
        constraint.targetType = VirtualMachine.class.getSimpleName();
        constraint.propertyName = "serverGuid";
        constraint.comparator = Comparator.EQUALS;
        constraint.comparableValue = this._vcGuid;
        QuerySpec query = this._querySpecBuilder.buildQuerySpec((Constraint)constraint, new String[]{"name"});
        try {
            com.vmware.vise.data.query.ResultSet resultSet = this._queryExecutor.getData(query);
            if (resultSet != null && resultSet.items != null) {
                for (ResultItem resultItem : resultSet.items) {
                    if (!(resultItem.resourceObject instanceof ManagedObjectReference)) continue;
                    result.add((ManagedObjectReference)resultItem.resourceObject);
                }
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed to retrieve all VMs.", (Throwable)ex);
        }
        return result;
    }

    private Set<ManagedObjectReference> getVmsByCompliance(String complianceStatus, PbmService pbmService) {
        HashSet<ManagedObjectReference> result = new HashSet<ManagedObjectReference>();
        try {
            ComplianceManager complianceManager = pbmService.getComplianceManager();
            ServerObjectRef[] vmSor = VM_SPBM_OUT_OF_DATE_STATUS.equals(complianceStatus) ? complianceManager.queryOutOfDateEntities() : complianceManager.queryByRollupComplianceStatus(complianceStatus);
            if (vmSor != null) {
                for (ServerObjectRef sor : vmSor) {
                    result.add(ManagedUtil.serverObjectRefToManagedObjectRef(sor, sor.getServerUuid()));
                }
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed to retrieve VMs by compliance status for PbmService. ", (Throwable)ex);
        }
        return result;
    }

    private PbmService getSpbmService() {
        VcService vcService = this.getVcService();
        if (vcService == null) {
            return null;
        }
        if (vcService.getConnectionInfo().getErrorCode() != "noError") {
            return null;
        }
        try {
            if (!VcServiceUtil.isVc61OrLater((String)this._vcGuid) || !PbmUtil.hasSpbmViewPrivilege(this._authorizationService, this._vcGuid)) {
                return null;
            }
            PbmService pbmService = PbmSessionUtil.getService(this._vcGuid, this._httpSession, this._pbmServiceFactory);
            return pbmService;
        }
        catch (Exception ex) {
            _logger.error((Object)("Failed to load PbmService for VC: " + ex.getMessage()));
            return null;
        }
    }

    private VcService getVcService() {
        LinkedVcGroupRegistry vcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry((HttpSession)this._httpSession);
        if (vcGroupRegistry == null) {
            return null;
        }
        LinkedVcGroup[] linkedVcGroups = vcGroupRegistry.getUtils().getStartupLinkedVcGroups();
        if (linkedVcGroups == null) {
            return null;
        }
        for (LinkedVcGroup linkedVcGroup : linkedVcGroups) {
            VcService vcService = linkedVcGroup.getVcService(this._vcGuid);
            if (vcService == null) continue;
            return vcService;
        }
        return null;
    }
}

