/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.spbm.impl;

import com.vmware.vim.binding.pbm.ServerObjectRef;
import com.vmware.vim.binding.pbm.compliance.ComplianceManager;
import com.vmware.vim.binding.pbm.placement.CapabilityProfileRequirement;
import com.vmware.vim.binding.pbm.placement.CompatibilityResult;
import com.vmware.vim.binding.pbm.placement.MatchingResources;
import com.vmware.vim.binding.pbm.placement.PlacementHub;
import com.vmware.vim.binding.pbm.placement.PlacementSolver;
import com.vmware.vim.binding.pbm.placement.Requirement;
import com.vmware.vim.binding.pbm.profile.ApplyProfileOutcome;
import com.vmware.vim.binding.pbm.profile.CapabilityBasedProfile;
import com.vmware.vim.binding.pbm.profile.ProfileId;
import com.vmware.vim.binding.pbm.profile.ProfileManager;
import com.vmware.vim.binding.pbm.profile.ProfileOperationOutcome;
import com.vmware.vim.binding.pbm.profile.ReconfigOutcome;
import com.vmware.vim.binding.pbm.profile.SubProfileCapabilityConstraints;
import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.vm.ConfigSpec;
import com.vmware.vim.binding.vim.vm.ProfileSpec;
import com.vmware.vim.binding.vim.vm.check.Result;
import com.vmware.vim.binding.vim.vm.device.VirtualDeviceSpec;
import com.vmware.vim.binding.vim.vm.device.VirtualDisk;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.tasks.TaskMonitor;
import com.vmware.vsphere.client.spbm.PbmService;
import com.vmware.vsphere.client.spbm.PbmServiceFactory;
import com.vmware.vsphere.client.spbm.data.VmRollupComplianceSummayData;
import com.vmware.vsphere.client.spbm.spec.AssignDrpSpec;
import com.vmware.vsphere.client.spbm.spec.CheckProfileComplianceSpec;
import com.vmware.vsphere.client.spbm.spec.CheckVmRollupComplianceSpec;
import com.vmware.vsphere.client.spbm.spec.ProfileBatchAssignmentSpec;
import com.vmware.vsphere.client.spbm.spec.ProfileCreateSpec;
import com.vmware.vsphere.client.spbm.spec.ProfileReapplySpec;
import com.vmware.vsphere.client.spbm.spec.ProfileRemovalSpec;
import com.vmware.vsphere.client.spbm.spec.ProfileUpdateSpec;
import com.vmware.vsphere.client.spbm.spec.ResetVsanDefaultProfileSpec;
import com.vmware.vsphere.client.spbm.spec.SpbmEnableSpec;
import com.vmware.vsphere.client.spbm.spec.VmPlacementSpec;
import com.vmware.vsphere.client.spbm.spec.VmProfileAssignmentSpec;
import com.vmware.vsphere.client.spbm.spec.VmProfileReapplySpec;
import com.vmware.vsphere.client.spbm.util.ManagedUtil;
import com.vmware.vsphere.client.spbm.util.MetadataUtil;
import com.vmware.vsphere.client.spbm.util.PbmSessionUtil;
import com.vmware.vsphere.client.spbm.util.PbmUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PbmMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(PbmMutationProvider.class);
    private final PbmServiceFactory _pbmServiceFactory;
    private final DataService _dataService;
    private final TaskMonitor _taskMonitor;
    private final QueryExecutor _queryExecutor;
    private static final String VM_DISKS_PROPERTY = "virtualDisks";

    public PbmMutationProvider(PbmServiceFactory pbmServiceFactory, DataService dataService, TaskMonitor taskMonitor, QueryExecutor queryExecutor) {
        this._pbmServiceFactory = pbmServiceFactory;
        this._dataService = dataService;
        this._taskMonitor = taskMonitor;
        this._queryExecutor = queryExecutor;
    }

    public OperationResult add(ProfileCreateSpec spec) {
        OperationResult result = new OperationResult();
        try {
            String vcGuid = spec.vcRootFolder.getServerGuid();
            PbmService pbmService = PbmSessionUtil.getService(vcGuid, this._pbmServiceFactory);
            if (spec.spec.constraints instanceof SubProfileCapabilityConstraints) {
                SubProfileCapabilityConstraints subProfileConstraints = (SubProfileCapabilityConstraints)spec.spec.constraints;
                MetadataUtil.updateValueTypesInSubProfiles(subProfileConstraints.subProfiles, pbmService, spec.spec.resourceType);
            }
            ProfileManager profileManager = pbmService.getProfileManager();
            BlockingFuture future = new BlockingFuture();
            profileManager.create(spec.spec, (Future)future);
            ProfileId profileId = (ProfileId)future.get();
            if (profileId != null) {
                CapabilityBasedProfile.ProfileCategoryEnum profileCategory = CapabilityBasedProfile.ProfileCategoryEnum.REQUIREMENT;
                if (spec.spec.category != null) {
                    profileCategory = CapabilityBasedProfile.ProfileCategoryEnum.valueOf((String)spec.spec.category);
                }
                URI profileUri = ManagedUtil.buildProfileUri(spec.spec.resourceType, profileCategory, vcGuid, profileId);
                result.entity = profileUri;
                result.result = profileUri;
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed to create profile. ", (Throwable)ex);
            result.error = PbmUtil.getMethodFault(ex);
        }
        return result;
    }

    public OperationResult remove(URI profile, ProfileRemovalSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = profile;
        try {
            String vcServiceGuid = ManagedUtil.getVcGuid(profile);
            ProfileId profileId = ManagedUtil.uriToProfileId(profile);
            PbmService pbmService = PbmSessionUtil.getService(vcServiceGuid, this._pbmServiceFactory);
            ProfileManager profileManager = pbmService.getProfileManager();
            BlockingFuture future = new BlockingFuture();
            profileManager.delete(new ProfileId[]{profileId}, (Future)future);
            ProfileOperationOutcome[] outcome = (ProfileOperationOutcome[])future.get();
            if (outcome != null && outcome.length > 0 && outcome[0].fault != null) {
                _logger.error((Object)"Failed to delete profile. ", (Throwable)outcome[0].fault);
                result.error = PbmUtil.getMethodFault(outcome[0].fault);
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed to delete profile.", (Throwable)ex);
            result.error = PbmUtil.getMethodFault(ex);
        }
        return result;
    }

    public OperationResult apply(URI profile, ProfileUpdateSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = profile;
        try {
            String vcServiceGuid = ManagedUtil.getVcGuid(profile);
            ProfileId profileId = ManagedUtil.uriToProfileId(profile);
            PbmService pbmService = PbmSessionUtil.getService(vcServiceGuid, this._pbmServiceFactory);
            if (spec.updateSpec.constraints instanceof SubProfileCapabilityConstraints) {
                SubProfileCapabilityConstraints subProfileConstaints = (SubProfileCapabilityConstraints)spec.updateSpec.constraints;
                MetadataUtil.updateValueTypesInSubProfiles(subProfileConstaints.subProfiles, pbmService, ManagedUtil.getResourceTypeByUri(profile));
            }
            ProfileManager profileManager = pbmService.getProfileManager();
            BlockingFuture future = new BlockingFuture();
            profileManager.update(profileId, spec.updateSpec, (Future)future);
            future.get();
            if (spec.reapplyProfile) {
                ProfileId[] parentProfileIds;
                String profileType = ManagedUtil.getProfileTypeByUri(profile);
                if ("PbmRequirementStorageProfile".equals(profileType)) {
                    this.reapplyProfileInternal(profileManager, new ProfileId[]{profileId}, vcServiceGuid);
                } else if ("PbmDataServiceStorageProfile".equals(profileType) && (parentProfileIds = PbmUtil.getParentProfileId(profileManager, profileId)) != null && parentProfileIds.length > 0) {
                    this.reapplyProfileInternal(profileManager, parentProfileIds, vcServiceGuid);
                }
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed to update profile.", (Throwable)ex);
            result.error = PbmUtil.getMethodFault(ex);
        }
        return result;
    }

    private void reapplyProfileInternal(ProfileManager profileManager, ProfileId[] profileIds, String vcServiceGuid) throws Exception {
        BlockingFuture applyProfileFuture = new BlockingFuture();
        profileManager.applyProfile(profileIds, (Future)applyProfileFuture);
        ApplyProfileOutcome[] applyProfileOutcomes = (ApplyProfileOutcome[])applyProfileFuture.get();
        if (applyProfileOutcomes == null) {
            return;
        }
        ArrayList<ManagedObjectReference> tasksToWatch = new ArrayList<ManagedObjectReference>();
        for (ApplyProfileOutcome profileOutcome : applyProfileOutcomes) {
            if (profileOutcome.reconfigOutcome == null) continue;
            for (ReconfigOutcome reconfigOutcome : profileOutcome.reconfigOutcome) {
                if (reconfigOutcome == null || reconfigOutcome.taskMoid == null) continue;
                ManagedObjectReference task = PbmMutationProvider.buildTaskMor(reconfigOutcome.taskMoid, vcServiceGuid);
                tasksToWatch.add(task);
            }
        }
        if (tasksToWatch.size() > 0) {
            this._taskMonitor.monitorTasks(tasksToWatch);
        }
    }

    public OperationResult apply(URI profile, ProfileReapplySpec spec) {
        OperationResult result = new OperationResult();
        result.entity = profile;
        try {
            String vcServiceGuid = ManagedUtil.getVcGuid(profile);
            PbmService pbmService = PbmSessionUtil.getService(vcServiceGuid, this._pbmServiceFactory);
            ProfileManager profileManager = pbmService.getProfileManager();
            BlockingFuture future = new BlockingFuture();
            profileManager.applyAssociated(spec.entities, Boolean.valueOf(false), (Future)future);
            ReconfigOutcome[] reconfigureOutcome = (ReconfigOutcome[])future.get();
            if (reconfigureOutcome != null) {
                ArrayList<ManagedObjectReference> tasksToWatch = new ArrayList<ManagedObjectReference>(reconfigureOutcome.length);
                for (ReconfigOutcome outcome : reconfigureOutcome) {
                    if (outcome == null || outcome.taskMoid == null) continue;
                    ManagedObjectReference task = PbmMutationProvider.buildTaskMor(outcome.taskMoid, vcServiceGuid);
                    tasksToWatch.add(task);
                }
                if (tasksToWatch.size() > 0) {
                    this._taskMonitor.monitorTasks(tasksToWatch);
                }
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed to reapply profile.", (Throwable)ex);
            result.error = PbmUtil.getMethodFault(ex);
        }
        return result;
    }

    public OperationResult[] applyOnMultiEntity(Object[] entities, VmProfileReapplySpec spec) {
        Map<String, ArrayList<ManagedObjectReference>> vmsByGuid = ManagedUtil.groupMoRefsByVcGuid(entities);
        ArrayList<OperationResult> result = new ArrayList<OperationResult>();
        for (String vcGuid : vmsByGuid.keySet()) {
            ManagedObjectReference[] vmRefs = vmsByGuid.get(vcGuid).toArray(new ManagedObjectReference[0]);
            ServerObjectRef[] vmSoRefs = ManagedUtil.managedObjectRefToServerObjectRef(vmRefs);
            result.addAll(this.reapplyProfileToVmsInternal(vcGuid, vmSoRefs));
        }
        return result.toArray(new OperationResult[0]);
    }

    private ArrayList<OperationResult> reapplyProfileToVmsInternal(String vcGuid, ServerObjectRef[] entities) {
        ArrayList<OperationResult> result;
        block6: {
            result = new ArrayList<OperationResult>();
            try {
                PbmService service = PbmSessionUtil.getService(vcGuid, this._pbmServiceFactory);
                BlockingFuture future = new BlockingFuture();
                service.getProfileManager().applyAssociated(entities, Boolean.valueOf(true), (Future)future);
                ReconfigOutcome[] reconfigOutcomes = (ReconfigOutcome[])future.get();
                if (reconfigOutcomes == null) break block6;
                ArrayList<ManagedObjectReference> tasksToWatch = new ArrayList<ManagedObjectReference>(reconfigOutcomes.length);
                for (ReconfigOutcome outcome : reconfigOutcomes) {
                    if (!ManagedUtil.isVmHome(outcome.entity)) continue;
                    OperationResult opResult = new OperationResult();
                    opResult.entity = ManagedUtil.serverObjectRefToManagedObjectRef(outcome.entity, vcGuid);
                    if (outcome.fault != null) {
                        opResult.error = outcome.fault;
                    }
                    if (outcome.taskMoid != null) {
                        ManagedObjectReference task = PbmMutationProvider.buildTaskMor(outcome.taskMoid, vcGuid);
                        opResult.task = task;
                        tasksToWatch.add(task);
                    }
                    result.add(opResult);
                }
                if (tasksToWatch.size() <= 0) break block6;
                this._taskMonitor.monitorTasks(tasksToWatch);
            }
            catch (Exception ex) {
                _logger.error((Object)"Failed to reapply profile.", (Throwable)ex);
                for (int i = 0; i < entities.length; ++i) {
                    if (!ManagedUtil.isVmHome(entities[i])) continue;
                    OperationResult opResult = new OperationResult();
                    opResult.entity = ManagedUtil.serverObjectRefToManagedObjectRef(entities[i], vcGuid);
                    opResult.error = PbmUtil.getMethodFault(ex);
                    result.add(opResult);
                }
            }
        }
        return result;
    }

    private static ManagedObjectReference buildTaskMor(String taskId, String vcGuid) {
        ManagedObjectReference task = new ManagedObjectReference("Task", taskId, vcGuid);
        return task;
    }

    public OperationResult apply(ManagedObjectReference vmRef, VmProfileAssignmentSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = vmRef;
        try {
            VirtualMachine vm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vmRef);
            result.result = result.task = vm.reconfigure(spec.vmConfigSpec);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed to edit VM's profiles.", (Throwable)ex);
            result.error = PbmUtil.getMethodFault(ex);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference vcRef, ProfileBatchAssignmentSpec spec) {
        OperationResult result = new OperationResult();
        if (spec.vmRefs == null || spec.vmRefs.length == 0) {
            return result;
        }
        try {
            HashSet<ManagedObjectReference> vmToReconfigure = new HashSet<ManagedObjectReference>();
            for (ManagedObjectReference vmRef : spec.vmRefs) {
                vmToReconfigure.add(vmRef);
            }
            ProfileSpec[] profileSpec = new ProfileSpec[]{spec.profileSpec};
            PropertyValue[] vmProps = this._queryExecutor.getProperty((Object[])spec.vmRefs, VM_DISKS_PROPERTY);
            if (vmProps != null) {
                for (PropertyValue propValue : vmProps) {
                    ManagedObjectReference vmRef = (ManagedObjectReference)propValue.resourceObject;
                    vmToReconfigure.remove(vmRef);
                    try {
                        VirtualDisk[] vmDisks = (VirtualDisk[])propValue.value;
                        VirtualMachine vm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vmRef);
                        vm.reconfigure(PbmMutationProvider.createVmConnfigSpec(vmDisks, profileSpec));
                    }
                    catch (Exception ex) {
                        _logger.error((Object)"Failed to modify VM profiles: ", (Throwable)ex);
                    }
                }
            }
            if (!vmToReconfigure.isEmpty()) {
                for (ManagedObjectReference vmRef : vmToReconfigure) {
                    try {
                        VirtualMachine vm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vmRef);
                        vm.reconfigure(PbmMutationProvider.createVmConnfigSpec(null, profileSpec));
                    }
                    catch (Exception ex) {
                        _logger.error((Object)"Failed to modify VM profiles: ", (Throwable)ex);
                    }
                }
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed to batch modify VM profile.", (Throwable)ex);
            result.error = PbmUtil.getMethodFault(ex);
        }
        return result;
    }

    private static ConfigSpec createVmConnfigSpec(VirtualDisk[] disks, ProfileSpec[] profileSpec) {
        ConfigSpec spec = new ConfigSpec();
        spec.vmProfile = profileSpec;
        if (disks != null && disks.length > 0) {
            spec.deviceChange = new VirtualDeviceSpec[disks.length];
            int deviceChangeIndex = 0;
            for (VirtualDisk disk : disks) {
                VirtualDeviceSpec deviceSpec = new VirtualDeviceSpec();
                deviceSpec.device = disk;
                deviceSpec.operation = VirtualDeviceSpec.Operation.edit;
                deviceSpec.profile = profileSpec;
                spec.deviceChange[deviceChangeIndex] = deviceSpec;
                ++deviceChangeIndex;
            }
        }
        return spec;
    }

    public OperationResult apply(URI storageProfile, CheckProfileComplianceSpec spec) {
        OperationResult result = new OperationResult();
        try {
            result.entity = storageProfile;
            if (spec.includeUpdatedComplianceData) {
                result.result = PbmUtil.getProfileComplianceData(storageProfile, this._pbmServiceFactory, this._dataService, true);
            } else {
                String vcServiceGuid = ManagedUtil.getVcGuid(storageProfile);
                ProfileId profileId = ManagedUtil.uriToProfileId(storageProfile);
                PbmService pbmService = PbmSessionUtil.getService(vcServiceGuid, this._pbmServiceFactory);
                BlockingFuture futureAssociatedEntities = new BlockingFuture();
                pbmService.getProfileManager().queryAssociatedEntity(profileId, null, (Future)futureAssociatedEntities);
                ServerObjectRef[] associatedEntities = (ServerObjectRef[])futureAssociatedEntities.get();
                ArrayList<ServerObjectRef> vmAndDiskRefs = new ArrayList<ServerObjectRef>();
                if (associatedEntities != null) {
                    for (ServerObjectRef soRef : associatedEntities) {
                        if (!ManagedUtil.isVirtualDisk(soRef) && !ManagedUtil.isVmHome(soRef)) continue;
                        vmAndDiskRefs.add(soRef);
                    }
                }
                if (!vmAndDiskRefs.isEmpty()) {
                    ComplianceManager complianceManager = pbmService.getComplianceManager();
                    result.result = PbmUtil.getComplianceResultsForEntities(complianceManager, profileId, vmAndDiskRefs.toArray(new ServerObjectRef[vmAndDiskRefs.size()]), true);
                } else {
                    result.result = null;
                }
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed to check storage profile compliance. ", (Throwable)ex);
            result.error = PbmUtil.getMethodFault(ex);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference vm, CheckVmRollupComplianceSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = vm;
        try {
            VmRollupComplianceSummayData complianceData = PbmUtil.getVmRollupComplianceSummay(vm, true, this._pbmServiceFactory);
            result.result = complianceData;
        }
        catch (Exception ex) {
            _logger.error((Object)("Failed to check rollup compliance for VM: [" + vm.getServerGuid() + "]"), (Throwable)ex);
            result.error = PbmUtil.getMethodFault(ex);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference entity, SpbmEnableSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = entity;
        try {
            ComputeResource.ConfigSpec reconfigSpec = new ComputeResource.ConfigSpec();
            reconfigSpec.spbmEnabled = spec.enable;
            ComputeResource computeResource = (ComputeResource)ManagedObjectUtil.getManagedObject((ManagedObjectReference)entity);
            result.task = computeResource.reconfigureEx(reconfigSpec, true);
        }
        catch (Exception ex) {
            if (spec.enable) {
                _logger.error((Object)"Failed to enable VM Storage Profiles on entity. ", (Throwable)ex);
            } else {
                _logger.error((Object)"Failed to disable VM Storage Profiles on entity. ", (Throwable)ex);
            }
            result.error = PbmUtil.getMethodFault(ex);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference vcRef, AssignDrpSpec spec) {
        OperationResult result = new OperationResult();
        if (spec.datastores == null || spec.datastores.length == 0) {
            _logger.error((Object)"Invalid arguments for assigning new DRP.");
            return result;
        }
        result.entity = spec.datastores[0];
        try {
            PbmService pbmService = PbmSessionUtil.getService(vcRef.getServerGuid(), this._pbmServiceFactory);
            PlacementHub[] hubs = PbmUtil.moRefToPlacementHub(spec.datastores);
            BlockingFuture future = new BlockingFuture();
            pbmService.getProfileManager().assignDefaultRequirementProfile(spec.defaultProfile, hubs, (Future)future);
            future.get();
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed to assign DRP for datastores. ", (Throwable)ex);
            result.error = PbmUtil.getMethodFault(ex);
        }
        return result;
    }

    public OperationResult apply(URI profile, ResetVsanDefaultProfileSpec spec) {
        OperationResult result = new OperationResult();
        try {
            result.entity = profile;
            String vcServiceGuid = ManagedUtil.getVcGuid(profile);
            PbmService pbmService = PbmSessionUtil.getService(vcServiceGuid, this._pbmServiceFactory);
            BlockingFuture future = new BlockingFuture();
            pbmService.getProfileManager().resetVSanDefaultProfile((Future)future);
            future.get();
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed to reset the vsan default profile. ", (Throwable)ex);
            result.error = PbmUtil.getMethodFault(ex);
        }
        return result;
    }

    public ValidationResult[] validateMultiSpec(VmPlacementSpec[] placementSpecs) throws Exception {
        if (ArrayUtil.isNullOrEmpty((Object[])placementSpecs)) {
            return new ValidationResult[0];
        }
        ValidationResult[] results = new ValidationResult[placementSpecs.length];
        for (int i = 0; i < placementSpecs.length; ++i) {
            ValidationResult vResult = new ValidationResult();
            vResult.entity = placementSpecs[i].vm;
            Result result = new Result();
            result.vm = placementSpecs[i].vm;
            vResult.result = new Result[]{result};
            results[i] = vResult;
            if (placementSpecs[i].datastore == null) continue;
            try {
                PbmService pbmService = PbmSessionUtil.getService(placementSpecs[i].datastore.getServerGuid(), this._pbmServiceFactory);
                ProfileId profileId = placementSpecs[i].profileId;
                if (profileId == null) {
                    profileId = PbmUtil.getDefaultRequirementProfile(pbmService, placementSpecs[i].datastore);
                }
                if (profileId == null) continue;
                PlacementHub hubToSearch = PbmUtil.moRefToPlacementHub(placementSpecs[i].datastore);
                PlacementSolver solver = (PlacementSolver)pbmService.getManagedObject(pbmService.getServiceInstanceContent().getPlacementSolver());
                BlockingFuture future = new BlockingFuture();
                if (pbmService.isFeatureSupported("dataService")) {
                    CapabilityProfileRequirement requirement = new CapabilityProfileRequirement();
                    requirement.profileId = profileId;
                    solver.checkRequirements(new PlacementHub[]{hubToSearch}, null, new Requirement[]{requirement}, (Future)future);
                } else {
                    solver.checkCompatibility(new PlacementHub[]{hubToSearch}, profileId, (Future)future);
                }
                Object[] compatibilityResult = (CompatibilityResult[])future.get();
                if (ArrayUtil.isNullOrEmpty((Object[])compatibilityResult)) continue;
                ArrayList<Exception> warnings = new ArrayList<Exception>();
                if (((CompatibilityResult)compatibilityResult[0]).error != null) {
                    ArrayUtil.append(warnings, (Object[])((CompatibilityResult)compatibilityResult[0]).error);
                }
                if (((CompatibilityResult)compatibilityResult[0]).warning != null) {
                    ArrayUtil.append(warnings, (Object[])((CompatibilityResult)compatibilityResult[0]).warning);
                }
                if (placementSpecs[i].host != null && placementSpecs[i].profileId != null && !this.isHostCompatibe(placementSpecs[i].host, (CompatibilityResult)compatibilityResult[0])) {
                    warnings.add(PbmUtil.getLocalizedException("incompatibleHost"));
                }
                if (warnings.isEmpty()) continue;
                result.warning = warnings.toArray(new Exception[warnings.size()]);
                continue;
            }
            catch (Exception ex) {
                _logger.error((Object)"Failed to check profile-datastore compatibility. ", (Throwable)ex);
                vResult.error = PbmUtil.getMethodFault(ex);
            }
        }
        return results;
    }

    private boolean isHostCompatibe(ManagedObjectReference host, CompatibilityResult compatibilityResult) {
        if (host == null || compatibilityResult == null || compatibilityResult.matchingResources == null) {
            return true;
        }
        for (MatchingResources matchingResources : compatibilityResult.matchingResources) {
            if (matchingResources.compatibleHost == null) {
                return true;
            }
            for (ServerObjectRef sor : matchingResources.compatibleHost) {
                if (sor == null || sor.key == null || !sor.key.equals(host.getValue())) continue;
                return true;
            }
        }
        return false;
    }
}

