/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.spbm.impl;

import com.vmware.vim.binding.pbm.ServerObjectRef;
import com.vmware.vim.binding.pbm.capability.CapabilityInstance;
import com.vmware.vim.binding.pbm.compliance.ComplianceManager;
import com.vmware.vim.binding.pbm.compliance.ComplianceResult;
import com.vmware.vim.binding.pbm.compliance.RollupComplianceResult;
import com.vmware.vim.binding.pbm.placement.CapabilityConstraintsRequirement;
import com.vmware.vim.binding.pbm.placement.CapabilityProfileRequirement;
import com.vmware.vim.binding.pbm.placement.CompatibilityResult;
import com.vmware.vim.binding.pbm.placement.PlacementHub;
import com.vmware.vim.binding.pbm.placement.PlacementSolver;
import com.vmware.vim.binding.pbm.placement.Requirement;
import com.vmware.vim.binding.pbm.profile.CapabilityBasedProfile;
import com.vmware.vim.binding.pbm.profile.CapabilityBasedProfileCreateSpec;
import com.vmware.vim.binding.pbm.profile.PmemPolicyInfo;
import com.vmware.vim.binding.pbm.profile.Profile;
import com.vmware.vim.binding.pbm.profile.ProfileId;
import com.vmware.vim.binding.pbm.profile.ProfileManager;
import com.vmware.vim.binding.pbm.profile.ProfileToIofilterMap;
import com.vmware.vim.binding.pbm.profile.QueryProfileResult;
import com.vmware.vim.binding.pbm.profile.ResourceType;
import com.vmware.vim.binding.pbm.profile.ResourceTypeEnum;
import com.vmware.vim.binding.pbm.profile.SubProfileCapabilityConstraints;
import com.vmware.vim.binding.pbm.profile.provider.DatastoreSpaceStatistics;
import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.vm.replication.ReplicationGroupId;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.common.UnexpectedStatusCodeException;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vsphere.client.common.spbm.data.CompatibleStorageData;
import com.vmware.vsphere.client.common.spbm.spec.CompatibleStorageQuerySpec;
import com.vmware.vsphere.client.spbm.PbmService;
import com.vmware.vsphere.client.spbm.PbmServiceFactory;
import com.vmware.vsphere.client.spbm.data.CapacityPerCapabilityProfileData;
import com.vmware.vsphere.client.spbm.data.DataServiceProfileUsageData;
import com.vmware.vsphere.client.spbm.data.NamespaceCapabilityMetadata;
import com.vmware.vsphere.client.spbm.data.ProfileComplianceSummaryData;
import com.vmware.vsphere.client.spbm.data.ProfileVmComplianceData;
import com.vmware.vsphere.client.spbm.data.SpbmCompatibilityResult;
import com.vmware.vsphere.client.spbm.data.SpbmLicenseBaseData;
import com.vmware.vsphere.client.spbm.data.VmCompatibilityResult;
import com.vmware.vsphere.client.spbm.data.VmObjectCompatibilityResult;
import com.vmware.vsphere.client.spbm.data.VmRollupComplianceSummayData;
import com.vmware.vsphere.client.spbm.impl.PbmServiceUnableToConnectException;
import com.vmware.vsphere.client.spbm.spec.QueryDrpSpec;
import com.vmware.vsphere.client.spbm.spec.QueryVmCompatibilityResultsSpec;
import com.vmware.vsphere.client.spbm.spec.VmObjectPlacementSpec;
import com.vmware.vsphere.client.spbm.util.ManagedUtil;
import com.vmware.vsphere.client.spbm.util.MetadataUtil;
import com.vmware.vsphere.client.spbm.util.PbmLocalizationUtil;
import com.vmware.vsphere.client.spbm.util.PbmSessionUtil;
import com.vmware.vsphere.client.spbm.util.PbmUtil;
import com.vmware.vsphere.client.spbm.util.SpbmLicenseUtil;
import com.vmware.vsphere.client.spbm.util.VirtualMachineDisk;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PbmPropertyProvider
implements PropertyProviderBean {
    private final PbmServiceFactory _pbmServiceFactory;
    private final DataService _dataService;
    private static final String VM_TYPE = ServerObjectRef.ObjectType.virtualMachine.toString();
    private static final String VIRTUAL_DISK_ID_TYPE = ServerObjectRef.ObjectType.virtualDiskId.toString();
    private static final String NAME_PROP = "name";
    private static final String CHILDREN_DCS_RELATION = "childrenDCs";
    private static final String COMPUTE_RESOURCE_PROP = "computeResource";
    private static final String HOST_PROP = "host";
    private static final String SPBM_ENABLED_PROP = "configurationEx.spbmEnabled";
    private static final String DATASTORE_TYPE_PROPERTY = "summary.type";
    private static final String VSAN_TYPE_LOWER = "vsan";
    private static final String VVOL_TYPE_LOWER = "vvol";
    private static final long MB_TO_BYTES = 0x100000L;
    private static final Log _logger = LogFactory.getLog(PbmPropertyProvider.class);
    private final QueryExecutor _queryExecutor;
    private final QuerySpecBuilder _querySpecBuilder;

    public PbmPropertyProvider(PbmServiceFactory pbmServiceFactory, DataService dataService, QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder) {
        this._pbmServiceFactory = pbmServiceFactory;
        this._dataService = dataService;
        this._queryExecutor = queryExecutor;
        this._querySpecBuilder = querySpecBuilder;
    }

    @type(value="PbmRequirementStorageProfile,PbmDataServiceStorageProfile")
    public boolean getProfileInUse(URI profileUri) throws Exception {
        String vcServiceGuid = ManagedUtil.getVcGuid(profileUri);
        PbmService pbmService = PbmSessionUtil.getService(vcServiceGuid, this._pbmServiceFactory);
        ProfileId profileId = ManagedUtil.uriToProfileId(profileUri);
        String profileType = ManagedUtil.getProfileTypeByUri(profileUri);
        if ("PbmRequirementStorageProfile".equals(profileType)) {
            BlockingFuture futureVms = new BlockingFuture();
            pbmService.getProfileManager().queryAssociatedEntity(profileId, VM_TYPE, (Future)futureVms);
            Object[] associatedVmSoRefs = (ServerObjectRef[])futureVms.get();
            if (!ArrayUtil.isNullOrEmpty((Object[])associatedVmSoRefs)) {
                return true;
            }
            BlockingFuture futureDisks = new BlockingFuture();
            pbmService.getProfileManager().queryAssociatedEntity(profileId, VIRTUAL_DISK_ID_TYPE, (Future)futureDisks);
            Object[] associatedVirtualDiskSoRefs = (ServerObjectRef[])futureDisks.get();
            return !ArrayUtil.isNullOrEmpty((Object[])associatedVirtualDiskSoRefs);
        }
        if ("PbmDataServiceStorageProfile".equals(profileType)) {
            Object[] parentProfileIds = PbmUtil.getParentProfileId(pbmService.getProfileManager(), profileId);
            return !ArrayUtil.isNullOrEmpty((Object[])parentProfileIds);
        }
        return false;
    }

    @type(value="PbmDataServiceStorageProfile")
    public DataServiceProfileUsageData getDataServiceProfileUsage(URI profileUri) throws Exception {
        ProfileId profileId;
        DataServiceProfileUsageData result = new DataServiceProfileUsageData();
        result.numberOfAssociatedVms = 0;
        result.numberOfParentProfiles = 0;
        String vcServiceGuid = ManagedUtil.getVcGuid(profileUri);
        PbmService pbmService = PbmSessionUtil.getService(vcServiceGuid, this._pbmServiceFactory);
        ProfileManager profileManager = pbmService.getProfileManager();
        ProfileId[] parentProfileIds = PbmUtil.getParentProfileId(profileManager, profileId = ManagedUtil.uriToProfileId(profileUri));
        if (parentProfileIds == null || parentProfileIds.length == 0) {
            return result;
        }
        result.numberOfParentProfiles = parentProfileIds.length;
        QueryProfileResult[] profileResults = profileManager.queryAssociatedEntities(parentProfileIds);
        if (profileResults == null) {
            return result;
        }
        HashSet<ManagedObjectReference> vmRefs = new HashSet<ManagedObjectReference>();
        for (QueryProfileResult profileResult : profileResults) {
            ManagedObjectReference vmRef;
            if (profileResult == null || profileResult.object == null || (vmRef = ManagedUtil.serverObjectRefToVmMor(profileResult.object, vcServiceGuid)) == null) continue;
            vmRefs.add(vmRef);
        }
        result.numberOfAssociatedVms = vmRefs.size();
        return result;
    }

    @type(value="PbmRequirementStorageProfile")
    public Profile[] getNestedProfiles(URI profileUri) throws Exception {
        String vcServiceGuid = ManagedUtil.getVcGuid(profileUri);
        PbmService pbmService = PbmSessionUtil.getService(vcServiceGuid, this._pbmServiceFactory);
        ProfileId profileId = ManagedUtil.uriToProfileId(profileUri);
        if (profileId == null) {
            return null;
        }
        ProfileManager profileManager = pbmService.getProfileManager();
        Object[] profiles = profileManager.retrieveContent(new ProfileId[]{profileId});
        if (ArrayUtil.isNullOrEmpty((Object[])profiles) || !(profiles[0] instanceof CapabilityBasedProfile)) {
            return null;
        }
        CapabilityBasedProfile capabilityProfile = (CapabilityBasedProfile)profiles[0];
        if (capabilityProfile.constraints == null || !(capabilityProfile.constraints instanceof SubProfileCapabilityConstraints)) {
            return null;
        }
        SubProfileCapabilityConstraints constraints = (SubProfileCapabilityConstraints)capabilityProfile.constraints;
        if (constraints.subProfiles == null) {
            return null;
        }
        ArrayList<ProfileId> nestedProfileIds = new ArrayList<ProfileId>();
        for (SubProfileCapabilityConstraints.SubProfile subProfile : constraints.subProfiles) {
            if (subProfile.capability == null) continue;
            for (CapabilityInstance capabilityInstance : subProfile.capability) {
                if (!MetadataUtil.isDataServiceReferenceCapability(capabilityInstance)) continue;
                nestedProfileIds.add(MetadataUtil.getProfileIdFromCapabilityInstance(capabilityInstance));
            }
        }
        if (!nestedProfileIds.isEmpty()) {
            return profileManager.retrieveContent(nestedProfileIds.toArray(new ProfileId[nestedProfileIds.size()]));
        }
        return null;
    }

    @type(value="PbmRequirementStorageProfile")
    public ProfileComplianceSummaryData getProfileComplianceSummary(URI profileUri) throws Exception {
        boolean hasAssociatedVirtualDisks;
        ProfileComplianceSummaryData result = new ProfileComplianceSummaryData();
        String vcServiceGuid = ManagedUtil.getVcGuid(profileUri);
        PbmService pbmService = PbmSessionUtil.getService(vcServiceGuid, this._pbmServiceFactory);
        ProfileId profileId = ManagedUtil.uriToProfileId(profileUri);
        BlockingFuture futureVms = new BlockingFuture();
        pbmService.getProfileManager().queryAssociatedEntity(profileId, VM_TYPE, (Future)futureVms);
        Object[] associatedVmSoRefs = (ServerObjectRef[])futureVms.get();
        BlockingFuture futureDisks = new BlockingFuture();
        pbmService.getProfileManager().queryAssociatedEntity(profileId, VIRTUAL_DISK_ID_TYPE, (Future)futureDisks);
        Object[] associatedVirtualDiskSoRefs = (ServerObjectRef[])futureDisks.get();
        boolean hasAssociatedVms = !ArrayUtil.isNullOrEmpty((Object[])associatedVmSoRefs);
        boolean bl = hasAssociatedVirtualDisks = !ArrayUtil.isNullOrEmpty((Object[])associatedVirtualDiskSoRefs);
        if (!hasAssociatedVms && !hasAssociatedVirtualDisks) {
            return result;
        }
        ManagedObjectReference[] associatedVirtualMachines = null;
        HashSet<ManagedObjectReference> associatedVirtualMachinesSet = new HashSet<ManagedObjectReference>();
        if (hasAssociatedVms) {
            associatedVirtualMachines = new ManagedObjectReference[associatedVmSoRefs.length];
            for (int i = 0; i < associatedVirtualMachines.length; ++i) {
                ManagedObjectReference vm;
                associatedVirtualMachines[i] = vm = ManagedUtil.serverObjectRefToManagedObjectRef((ServerObjectRef)associatedVmSoRefs[i], vcServiceGuid);
                associatedVirtualMachinesSet.add(vm);
            }
        }
        VirtualMachineDisk[] associatedVirtualDisks = null;
        HashSet<VirtualMachineDisk> associatedVirtualDisksSet = new HashSet<VirtualMachineDisk>();
        if (hasAssociatedVirtualDisks) {
            associatedVirtualDisks = new VirtualMachineDisk[associatedVirtualDiskSoRefs.length];
            for (int i = 0; i < associatedVirtualDiskSoRefs.length; ++i) {
                VirtualMachineDisk disk;
                associatedVirtualDisks[i] = disk = PbmUtil.serverObjectReferenceToVirtualMachineDisk((ServerObjectRef)associatedVirtualDiskSoRefs[i], vcServiceGuid);
                associatedVirtualDisksSet.add(disk);
            }
        }
        ComplianceManager complianceManager = pbmService.getComplianceManager();
        Object[] vmComplianceStatuses = null;
        if (hasAssociatedVms) {
            vmComplianceStatuses = PbmUtil.getComplianceResultsForEntities(complianceManager, profileId, (ServerObjectRef[])associatedVmSoRefs, false);
        }
        Object[] diskComplianceStatuses = null;
        if (hasAssociatedVirtualDisks) {
            diskComplianceStatuses = PbmUtil.getComplianceResultsForEntities(complianceManager, profileId, (ServerObjectRef[])associatedVirtualDiskSoRefs, false);
        }
        HashMap<ManagedObjectReference, Boolean> vmsComplianceMap = new HashMap<ManagedObjectReference, Boolean>();
        if (!ArrayUtil.isNullOrEmpty((Object[])vmComplianceStatuses)) {
            for (Object complianceResult : vmComplianceStatuses) {
                ManagedObjectReference vmMoRef = ManagedUtil.serverObjectRefToManagedObjectRef(((ComplianceResult)complianceResult).entity, vcServiceGuid);
                associatedVirtualMachinesSet.remove(vmMoRef);
                PbmUtil.parseComplianceData(((ComplianceResult)complianceResult).complianceStatus, ((ComplianceResult)complianceResult).mismatch, vmMoRef, vmsComplianceMap);
            }
        }
        if (!ArrayUtil.isNullOrEmpty((Object[])diskComplianceStatuses)) {
            for (Object complianceResult : diskComplianceStatuses) {
                VirtualMachineDisk vmDisk = PbmUtil.serverObjectReferenceToVirtualMachineDisk(((ComplianceResult)complianceResult).entity, vcServiceGuid);
                VirtualMachineDisk vmDiskFromAssignmentsSet = PbmPropertyProvider.getVirtualMachineDisk(vmDisk, associatedVirtualDisksSet);
                if (vmDiskFromAssignmentsSet != null) {
                    associatedVirtualDisksSet.remove(vmDiskFromAssignmentsSet);
                }
                PbmUtil.parseComplianceData(((ComplianceResult)complianceResult).complianceStatus, ((ComplianceResult)complianceResult).mismatch, vmDisk.virtualMachine, vmsComplianceMap);
            }
        }
        for (ManagedObjectReference vm : associatedVirtualMachinesSet) {
            PbmUtil.parseComplianceData(ComplianceResult.ComplianceStatus.unknown.toString(), Boolean.FALSE, vm, vmsComplianceMap);
        }
        for (VirtualMachineDisk disk : associatedVirtualDisksSet) {
            PbmUtil.parseComplianceData(ComplianceResult.ComplianceStatus.unknown.toString(), Boolean.FALSE, disk.virtualMachine, vmsComplianceMap);
        }
        for (Boolean isCompliant : vmsComplianceMap.values()) {
            if (isCompliant == null) {
                ++result.unknownComplianceEntitiesCount;
                continue;
            }
            if (isCompliant.booleanValue()) {
                ++result.compliantEntitiesCount;
                continue;
            }
            ++result.nonCompliantEntitiesCount;
        }
        return result;
    }

    @type(value="PbmRequirementStorageProfile")
    public ProfileVmComplianceData[] getProfileComplianceData(URI profileUri) throws Exception {
        try {
            return PbmUtil.getProfileComplianceData(profileUri, this._pbmServiceFactory, this._dataService, false);
        }
        catch (ExecutionException ex) {
            _logger.error((Object)"Failed to retrieve ProfileComplianceData:", (Throwable)ex);
            if (ex.getCause() instanceof UnexpectedStatusCodeException) {
                throw PbmUtil.getMethodFault(ex);
            }
            throw ex;
        }
    }

    @type(value="Folder")
    public SpbmLicenseBaseData[] getEnableSpbmData(ManagedObjectReference vcRef) throws Exception {
        if (vcRef == null) {
            return new SpbmLicenseBaseData[0];
        }
        PropertyValue[] dcProps = this._queryExecutor.getPropertiesForRelatedObjects((Object)vcRef, CHILDREN_DCS_RELATION, Datacenter.class.getSimpleName(), new String[]{NAME_PROP, COMPUTE_RESOURCE_PROP});
        if (dcProps == null) {
            return new SpbmLicenseBaseData[0];
        }
        HashMap<String, Object[]> propertiesPerDcMap = new HashMap<String, Object[]>();
        HashMap<String, SpbmLicenseBaseData> crIdToSpbmDataMap = new HashMap<String, SpbmLicenseBaseData>();
        ArrayList<Object> computeResourcesList = new ArrayList<Object>();
        for (PropertyValue dcProperty : dcProps) {
            String providerId = ((ManagedObjectReference)dcProperty.resourceObject).getValue();
            Object[] propertyArray = (Object[])propertiesPerDcMap.get(providerId);
            if (propertyArray == null) {
                propertyArray = new Object[2];
                propertiesPerDcMap.put(providerId, propertyArray);
            }
            if (dcProperty.propertyName.equals(NAME_PROP)) {
                propertyArray[0] = dcProperty.value;
            } else {
                propertyArray[1] = dcProperty.value;
            }
            if (propertyArray[0] == null || propertyArray[1] == null) continue;
            String dcName = (String)propertyArray[0];
            Object[] valueArray = (Object[])propertyArray[1];
            computeResourcesList.addAll(Arrays.asList(valueArray));
            crIdToSpbmDataMap = SpbmLicenseUtil.fillMapWithDataPerDc(dcName, valueArray, crIdToSpbmDataMap);
        }
        if (computeResourcesList.size() == 0) {
            return new SpbmLicenseBaseData[0];
        }
        PropertyValue[] crProperties = this._queryExecutor.getProperties(computeResourcesList.toArray(new Object[computeResourcesList.size()]), new String[]{NAME_PROP, HOST_PROP, SPBM_ENABLED_PROP});
        ArrayList<ManagedObjectReference> hosts = new ArrayList<ManagedObjectReference>();
        if (crProperties == null) {
            return new SpbmLicenseBaseData[0];
        }
        HashMap<String, Object[]> crIdToPropsMap = new HashMap<String, Object[]>();
        for (PropertyValue property : crProperties) {
            String propId = ((ManagedObjectReference)property.resourceObject).getValue();
            Object[] props = crIdToPropsMap.get(propId);
            if (props == null) {
                props = new Object[3];
                crIdToPropsMap.put(propId, props);
            }
            if (property.propertyName.equals(NAME_PROP)) {
                props[0] = (String)property.value;
                continue;
            }
            if (property.propertyName.equals(HOST_PROP)) {
                ManagedObjectReference[] value;
                props[1] = value = (ManagedObjectReference[])property.value;
                hosts.addAll(Arrays.asList(value));
                continue;
            }
            if (!property.propertyName.equals(SPBM_ENABLED_PROP)) continue;
            props[2] = (Boolean)property.value;
        }
        HashMap<String, Object[]> hostIdToPropsMap = new HashMap<String, Object[]>();
        if (hosts.size() > 0) {
            hostIdToPropsMap = SpbmLicenseUtil.getConnectionStateAndSpbmLicenseInfoForHosts(this._dataService, hosts);
        }
        return SpbmLicenseUtil.buildSpbmLicenseData(crIdToSpbmDataMap, crIdToPropsMap, hostIdToPropsMap);
    }

    @type(value="PbmRequirementStorageProfile")
    public SpbmCompatibilityResult[] getSpbmCompatibleResultsForProfile(URI storageProfile) throws Exception {
        SpbmCompatibilityResult[] result = null;
        try {
            String vcServiceGuid = ManagedUtil.getVcGuid(storageProfile);
            ManagedObjectReference vcRef = ManagedUtil.buildVcMoRef(vcServiceGuid);
            ProfileId profileId = ManagedUtil.uriToProfileId(storageProfile);
            PbmService pbmService = PbmSessionUtil.getService(vcRef.getServerGuid(), this._pbmServiceFactory);
            PlacementSolver solver = (PlacementSolver)pbmService.getManagedObject(pbmService.getServiceInstanceContent().getPlacementSolver());
            BlockingFuture future = new BlockingFuture();
            if (pbmService.isFeatureSupported("dataService")) {
                CapabilityProfileRequirement requirement = new CapabilityProfileRequirement();
                requirement.profileId = profileId;
                solver.checkRequirements(null, null, new Requirement[]{requirement}, (Future)future);
            } else {
                solver.checkCompatibility(null, profileId, (Future)future);
            }
            CompatibilityResult[] compResults = (CompatibilityResult[])future.get();
            result = PbmPropertyProvider.compResultsToSpbmCompResult(compResults, vcServiceGuid);
        }
        catch (PbmServiceUnableToConnectException ex) {
            _logger.error((Object)"Failed to retrieve compatible storage: ", (Throwable)ex);
            throw PbmUtil.getMethodFault(ex);
        }
        catch (ExecutionException ex) {
            _logger.error((Object)"Failed to retrieve compatible storage: ", (Throwable)ex);
            throw PbmUtil.getMethodFault(ex);
        }
        return result;
    }

    private static SpbmCompatibilityResult[] compResultsToSpbmCompResult(CompatibilityResult[] compResults, String vcServiceGuid) {
        if (compResults == null) {
            return null;
        }
        SpbmCompatibilityResult[] result = new SpbmCompatibilityResult[compResults.length];
        for (int i = 0; i < compResults.length; ++i) {
            result[i] = new SpbmCompatibilityResult();
            result[i].storageContainer = PbmUtil.placementHubToMoRef(compResults[i].hub, vcServiceGuid);
            result[i].compatibilityErrors = compResults[i].error;
            result[i].compatibilityWarnings = compResults[i].warning;
        }
        return result;
    }

    @type(value="Folder")
    public SpbmCompatibilityResult[] getSpbmCompatibilityResultsForCreateSpec(ManagedObjectReference vcRef, CapabilityBasedProfileCreateSpec spec) throws Exception {
        SpbmCompatibilityResult[] result = null;
        try {
            PbmService pbmService = PbmSessionUtil.getService(vcRef.getServerGuid(), this._pbmServiceFactory);
            if (spec.constraints instanceof SubProfileCapabilityConstraints) {
                SubProfileCapabilityConstraints subProfileConstraints = (SubProfileCapabilityConstraints)spec.constraints;
                MetadataUtil.updateValueTypesInSubProfiles(subProfileConstraints.subProfiles, pbmService, spec.resourceType);
            }
            PlacementSolver solver = (PlacementSolver)pbmService.getManagedObject(pbmService.getServiceInstanceContent().getPlacementSolver());
            BlockingFuture future = new BlockingFuture();
            if (pbmService.isFeatureSupported("dataService")) {
                CapabilityConstraintsRequirement requirement = new CapabilityConstraintsRequirement();
                requirement.constraints = spec.constraints;
                solver.checkRequirements(null, null, new Requirement[]{requirement}, (Future)future);
            } else {
                solver.checkCompatibilityWithSpec(null, spec, (Future)future);
            }
            CompatibilityResult[] compResults = (CompatibilityResult[])future.get();
            result = PbmPropertyProvider.compResultsToSpbmCompResult(compResults, vcRef.getServerGuid());
        }
        catch (PbmServiceUnableToConnectException ex) {
            _logger.error((Object)"Failed to retrieve compatibility results: ", (Throwable)ex);
            throw PbmUtil.getMethodFault(ex);
        }
        catch (ExecutionException ex) {
            _logger.error((Object)"Failed to retrieve compatibility results: ", (Throwable)ex);
            throw PbmUtil.getMethodFault(ex);
        }
        return result;
    }

    @type(value="Folder")
    public VmCompatibilityResult getVmCompatibilityResults(ManagedObjectReference moRef, QueryVmCompatibilityResultsSpec spec) throws Exception {
        VmCompatibilityResult result = new VmCompatibilityResult();
        try {
            String vcGuid = moRef.getServerGuid();
            PbmService pbmService = PbmSessionUtil.getService(vcGuid, this._pbmServiceFactory);
            if (!pbmService.isFeatureSupported("dataService") || spec == null || spec.vmPlacements == null) {
                return result;
            }
            PlacementSolver solver = (PlacementSolver)pbmService.getManagedObject(pbmService.getServiceInstanceContent().getPlacementSolver());
            ArrayList<VmObjectCompatibilityResult> vmObjectCompatibilityResults = new ArrayList<VmObjectCompatibilityResult>();
            HashMap<String, ReplicationGroupId> rgIds = new HashMap<String, ReplicationGroupId>();
            for (VmObjectPlacementSpec placementSpec : spec.vmPlacements) {
                ServerObjectRef vmObjectRef;
                if (placementSpec.profileId == null || placementSpec.storage == null) {
                    _logger.warn((Object)"getVmCompatibilityResults: invalid placementSpec.");
                    continue;
                }
                CapabilityProfileRequirement requirement = new CapabilityProfileRequirement();
                requirement.profileId = placementSpec.profileId;
                PlacementHub[] placementHubs = new PlacementHub[]{PbmUtil.moRefToPlacementHub(placementSpec.storage)};
                Object[] compatibilityResults = solver.checkRequirements(placementHubs, vmObjectRef = ManagedUtil.vmObjectIdToServerObjectRef(placementSpec.vmObjectId, vcGuid), new Requirement[]{requirement});
                if (ArrayUtil.isNullOrEmpty((Object[])compatibilityResults)) continue;
                VmObjectCompatibilityResult vmObjectResult = new VmObjectCompatibilityResult();
                vmObjectResult.vmObjectId = placementSpec.vmObjectId;
                vmObjectResult.compatibilityResult = compatibilityResults[0];
                vmObjectCompatibilityResults.add(vmObjectResult);
                PbmUtil.extractReplicationGroupIds((CompatibilityResult)compatibilityResults[0], rgIds);
            }
            result.compatibilityResults = vmObjectCompatibilityResults.toArray(new VmObjectCompatibilityResult[vmObjectCompatibilityResults.size()]);
            result.replicationGroupInfo = PbmUtil.getReplicationGroupInfos(rgIds.values(), moRef, this._queryExecutor, this._querySpecBuilder);
        }
        catch (PbmServiceUnableToConnectException ex) {
            _logger.error((Object)"Failed to retrieve compatibility results: ", (Throwable)ex);
            throw PbmUtil.getMethodFault(ex);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed to retrieve compatibility results: ", (Throwable)ex);
            throw PbmUtil.getMethodFault(ex);
        }
        return result;
    }

    @type(value="Folder")
    public CompatibleStorageData getPbmCompatibleStorage(ManagedObjectReference moRef, CompatibleStorageQuerySpec spec) throws Exception {
        CompatibleStorageData result = new CompatibleStorageData();
        try {
            if (!(spec.datastoreRefs != null && spec.datastoreRefs.length != 0 || spec.storagePodsRefs != null && spec.storagePodsRefs.length != 0)) {
                return result;
            }
            String vcServiceGuid = moRef.getServerGuid();
            PbmService pbmService = PbmSessionUtil.getService(vcServiceGuid, this._pbmServiceFactory);
            Object[] profiles = null;
            profiles = spec.profile != null ? new ProfileId[]{spec.profile.profileId} : this.getProfileIdsForVMs(spec.vmRefs, pbmService);
            if (ArrayUtil.isNullOrEmpty((Object[])profiles)) {
                result.datastoreRefs = spec.datastoreRefs;
                result.storagePodsRefs = spec.storagePodsRefs;
                return result;
            }
            ManagedObjectReference[] hubsToFilter = null;
            if (spec.datastoreRefs == null || spec.datastoreRefs.length == 0) {
                hubsToFilter = spec.storagePodsRefs;
            } else if (spec.storagePodsRefs == null || spec.storagePodsRefs.length == 0) {
                hubsToFilter = spec.datastoreRefs;
            } else {
                hubsToFilter = new ManagedObjectReference[spec.datastoreRefs.length + spec.storagePodsRefs.length];
                System.arraycopy(spec.datastoreRefs, 0, hubsToFilter, 0, spec.datastoreRefs.length);
                System.arraycopy(spec.storagePodsRefs, 0, hubsToFilter, spec.datastoreRefs.length, spec.storagePodsRefs.length);
            }
            this.filterPlacements(hubsToFilter, pbmService, (ProfileId[])profiles, vcServiceGuid, result);
        }
        catch (PbmServiceUnableToConnectException ex) {
            _logger.error((Object)"Failed to retrieve compatible storage: ", (Throwable)ex);
            throw PbmUtil.getMethodFault(ex);
        }
        catch (ExecutionException ex) {
            _logger.error((Object)"Failed to retrieve compatible storage: ", (Throwable)ex);
            throw PbmUtil.getMethodFault(ex);
        }
        return result;
    }

    @type(value="VirtualMachine,ComputeResource,ClusterComputeResource,Folder")
    public ProfileToIofilterMap[] getProfileToIofilterMap(ManagedObjectReference mo) throws Exception {
        ResourceType type2;
        String vc = mo.getServerGuid();
        PbmService pbm = PbmSessionUtil.getService(vc, this._pbmServiceFactory);
        ProfileManager mgr = pbm.getProfileManager();
        ProfileId[] array = mgr.queryProfile(type2 = new ResourceType(ResourceTypeEnum.STORAGE.toString()), null);
        if (array == null) {
            return new ProfileToIofilterMap[0];
        }
        ProfileToIofilterMap[] maps = mgr.queryIOFiltersFromProfileId(array);
        return maps;
    }

    @type(value="VirtualMachine,ComputeResource,ClusterComputeResource,Folder")
    public PmemPolicyInfo[] getPmemPolicyInfo(ManagedObjectReference mo) throws Exception {
        ResourceType type2;
        String vc = mo.getServerGuid();
        PbmService pbm = PbmSessionUtil.getService(vc, this._pbmServiceFactory);
        ProfileManager mgr = pbm.getProfileManager();
        ProfileId[] array = mgr.queryProfile(type2 = new ResourceType(ResourceTypeEnum.STORAGE.toString()), null);
        if (array == null) {
            return new PmemPolicyInfo[0];
        }
        PmemPolicyInfo[] retVal = mgr.queryPmemPolicyInfo(array);
        return retVal;
    }

    @type(value="Datastore")
    public Profile[] getDefaultProfiles(ManagedObjectReference datastoreRef) throws Exception {
        return this.getDatastoreProfiles(datastoreRef, true);
    }

    @type(value="Datastore")
    public Profile[] getCapabilityProfiles(ManagedObjectReference datastoreRef) throws Exception {
        return this.getDatastoreProfiles(datastoreRef, false);
    }

    @type(value="Datastore")
    public Profile getDefaultRequirementProfile(ManagedObjectReference datastoreRef) throws Exception {
        try {
            String vcServiceGuid = datastoreRef.getServerGuid();
            PbmService pbmService = PbmSessionUtil.getService(vcServiceGuid, this._pbmServiceFactory);
            ProfileId defaultProfileId = PbmUtil.getDefaultRequirementProfile(pbmService, datastoreRef);
            if (defaultProfileId != null) {
                BlockingFuture profileFuture = new BlockingFuture();
                pbmService.getProfileManager().retrieveContent(new ProfileId[]{defaultProfileId}, (Future)profileFuture);
                Profile[] profiles = (Profile[])profileFuture.get();
                if (profiles != null && profiles.length > 0) {
                    return profiles[0];
                }
            }
        }
        catch (PbmServiceUnableToConnectException ex) {
            _logger.error((Object)"Failed to retrieve default profile for the datastore: ", (Throwable)ex);
            throw PbmUtil.getMethodFault(ex);
        }
        catch (ExecutionException ex) {
            _logger.error((Object)"Failed to retrieve default profile for the datastore: ", (Throwable)ex);
            throw PbmUtil.getMethodFault(ex);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed to retrieve applicable profiles for datastores: ", (Throwable)ex);
            throw ex;
        }
        return null;
    }

    @type(value="Folder")
    public Profile[] getAvailableDefaultResourceProfiles(ManagedObjectReference vcRef, QueryDrpSpec spec) throws Exception {
        try {
            String vcServiceGuid = vcRef.getServerGuid();
            PbmService pbmService = PbmSessionUtil.getService(vcServiceGuid, this._pbmServiceFactory);
            PlacementHub[] hubs = PbmUtil.moRefToPlacementHub(spec.datastores);
            BlockingFuture profileFuture = new BlockingFuture();
            pbmService.getProfileManager().findApplicableDefaultProfile(hubs, (Future)profileFuture);
            return (Profile[])profileFuture.get();
        }
        catch (PbmServiceUnableToConnectException ex) {
            _logger.error((Object)"Failed to retrieve applicable profiles for datastores: ", (Throwable)ex);
            throw PbmUtil.getMethodFault(ex);
        }
        catch (ExecutionException ex) {
            _logger.error((Object)"Failed to retrieve applicable profiles for datastores: ", (Throwable)ex);
            throw PbmUtil.getMethodFault(ex);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed to retrieve applicable profiles for datastores: ", (Throwable)ex);
            throw ex;
        }
    }

    private Profile[] getDatastoreProfiles(ManagedObjectReference datastoreRef, boolean defaultProfiles) throws Exception {
        try {
            String vcServiceGuid = datastoreRef.getServerGuid();
            PbmService pbmService = PbmSessionUtil.getService(vcServiceGuid, this._pbmServiceFactory);
            ServerObjectRef datastoreSoRef = ManagedUtil.managedObjectRefToServerObjectRef(datastoreRef);
            BlockingFuture futureAssociatedProfileIds = new BlockingFuture();
            if (defaultProfiles) {
                pbmService.getProfileManager().queryDefaultCapabilityValues(datastoreSoRef, null, (Future)futureAssociatedProfileIds);
            } else {
                pbmService.getProfileManager().queryAssociatedProfile(datastoreSoRef, (Future)futureAssociatedProfileIds);
            }
            Object[] associatedProfileIds = (ProfileId[])futureAssociatedProfileIds.get();
            if (ArrayUtil.isNullOrEmpty((Object[])associatedProfileIds)) {
                return null;
            }
            BlockingFuture futureProfilesContent = new BlockingFuture();
            pbmService.getProfileManager().retrieveContent((ProfileId[])associatedProfileIds, (Future)futureProfilesContent);
            return (Profile[])futureProfilesContent.get();
        }
        catch (PbmServiceUnableToConnectException ex) {
            _logger.error((Object)"Failed to retrieve profiles for the datastore: ", (Throwable)ex);
            throw PbmUtil.getMethodFault(ex);
        }
        catch (ExecutionException ex) {
            _logger.error((Object)"Failed to retrieve profiles for the datastore: ", (Throwable)ex);
            throw PbmUtil.getMethodFault(ex);
        }
    }

    private ProfileId[] getProfileIdsForVMs(ManagedObjectReference[] vmRefs, PbmService pbmService) throws Exception {
        RollupComplianceResult[] vmComplResults = PbmUtil.getRollupComplianceResult(pbmService, vmRefs);
        return PbmUtil.getProfileIdsFromRollupCompliance(vmComplResults);
    }

    private void filterPlacements(ManagedObjectReference[] placementsToFilter, PbmService pbmService, ProfileId[] profiles, String vcServiceGuid, CompatibleStorageData result) throws Exception {
        PlacementSolver solver = (PlacementSolver)pbmService.getManagedObject(pbmService.getServiceInstanceContent().getPlacementSolver());
        PlacementHub[] hubsToFilter = null;
        if (placementsToFilter != null) {
            hubsToFilter = PbmUtil.moRefToPlacementHub(placementsToFilter);
        }
        HashMap<String, CompatibilityResult> hubCompatibilityResults = new HashMap<String, CompatibilityResult>();
        for (int profileIndex = 0; profileIndex < profiles.length; ++profileIndex) {
            if (pbmService.isFeatureSupported("dataService")) {
                CapabilityProfileRequirement requirement = new CapabilityProfileRequirement();
                requirement.profileId = profiles[profileIndex];
                CompatibilityResult[] compatibilityResults = solver.checkRequirements(hubsToFilter, null, new Requirement[]{requirement});
                if (compatibilityResults == null) {
                    _logger.error((Object)"PlacementSolver.checkRequirements() returned null result!");
                    hubsToFilter = null;
                    break;
                }
                ArrayList<PlacementHub> compatibleHubs = new ArrayList<PlacementHub>();
                for (CompatibilityResult compResult : compatibilityResults) {
                    String hubId = compResult.hub.hubId;
                    if (!PbmUtil.isResultCompatible(compResult)) {
                        hubCompatibilityResults.put(hubId, compResult);
                        continue;
                    }
                    CompatibilityResult hubResult = PbmUtil.mergeCompatibilityResults(compResult, (CompatibilityResult)hubCompatibilityResults.get(hubId));
                    if (hubResult != null) {
                        compatibleHubs.add(compResult.hub);
                        hubCompatibilityResults.put(hubId, hubResult);
                        continue;
                    }
                    hubCompatibilityResults.remove(hubId);
                }
                hubsToFilter = compatibleHubs.toArray(new PlacementHub[compatibleHubs.size()]);
            } else {
                hubsToFilter = solver.queryMatchingHub(hubsToFilter, profiles[profileIndex]);
            }
            if (hubsToFilter == null || hubsToFilter.length == 0) break;
        }
        ManagedObjectReference[] matchingStorage = PbmUtil.placementHubToMoRef(hubsToFilter, vcServiceGuid);
        result.datastoreRefs = ManagedUtil.filterMoRefByType(matchingStorage, "Datastore");
        result.storagePodsRefs = ManagedUtil.filterMoRefByType(matchingStorage, "StoragePod");
        if (!hubCompatibilityResults.isEmpty()) {
            result.compatibilityResults = hubCompatibilityResults.values().toArray(new CompatibilityResult[hubCompatibilityResults.size()]);
            HashMap<String, ReplicationGroupId> rgIds = new HashMap<String, ReplicationGroupId>();
            for (CompatibilityResult compResult : hubCompatibilityResults.values()) {
                PbmUtil.extractReplicationGroupIds(compResult, rgIds);
            }
            result.replicationGroupInfo = PbmUtil.getReplicationGroupInfos(rgIds.values(), ManagedUtil.buildVcMoRef(vcServiceGuid), this._queryExecutor, this._querySpecBuilder);
        }
    }

    @type(value="VirtualMachine")
    public RollupComplianceResult getVmStorageRollupComplianceResult(ManagedObjectReference vm) throws Exception {
        try {
            PbmService service = PbmSessionUtil.getService(vm.getServerGuid(), this._pbmServiceFactory);
            return this.getRollupComplianceResultInternal(service, vm);
        }
        catch (PbmServiceUnableToConnectException ex) {
            _logger.error((Object)"Failed to retrieve VmStorageRollupComplianceResult: ", (Throwable)ex);
            throw PbmUtil.getMethodFault(ex);
        }
        catch (ExecutionException ex) {
            _logger.error((Object)"Failed to retrieve VmStorageRollupComplianceResult: ", (Throwable)ex);
            throw PbmUtil.getMethodFault(ex);
        }
    }

    @type(value="VirtualMachine")
    public VmRollupComplianceSummayData getVmRollupComplianceSummay(ManagedObjectReference vm) throws Exception {
        return PbmUtil.getVmRollupComplianceSummay(vm, false, this._pbmServiceFactory);
    }

    @type(value="VirtualMachine")
    public boolean getIsSpbmSupportedForVc(ManagedObjectReference moRef) throws Exception {
        return VcServiceUtil.isOPVcOrLater((String)moRef.getServerGuid());
    }

    @type(value="Folder,VirtualMachine")
    public String[] getSpbmSupportedFeatures(ManagedObjectReference moRef) throws Exception {
        if (!VcServiceUtil.isVc61OrLater((String)moRef.getServerGuid())) {
            return null;
        }
        try {
            PbmService service = PbmSessionUtil.getService(moRef.getServerGuid(), this._pbmServiceFactory);
            return service.getSupportedFeatures();
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed to retrieve list of supported SPBM features.", (Throwable)ex);
            return null;
        }
    }

    @type(value="Datastore")
    public boolean getIsDrpSupported(ManagedObjectReference dsRef) {
        if (PbmUtil.isDrpSupportedByVC(dsRef)) {
            try {
                String datastoreType = (String)this._queryExecutor.getProperty((Object)dsRef, DATASTORE_TYPE_PROPERTY);
                if (datastoreType != null) {
                    datastoreType = datastoreType.toLowerCase();
                }
                if (VVOL_TYPE_LOWER.equals(datastoreType) || VSAN_TYPE_LOWER.equals(datastoreType)) {
                    return true;
                }
            }
            catch (Exception ex) {
                _logger.error((Object)"Error in getIsDrpSupported. ", (Throwable)ex);
            }
        }
        return false;
    }

    @type(value="Folder,Datastore,ClusterComputeResource,VirtualMachine,PbmRequirementStorageProfile,PbmDataServiceStorageProfile")
    public NamespaceCapabilityMetadata[] getNamespaceCapabilityMetadata(Object objectRef, ResourceType resourceType) throws Exception {
        String vcServiceGuid;
        if (objectRef instanceof ManagedObjectReference) {
            vcServiceGuid = ((ManagedObjectReference)objectRef).getServerGuid();
        } else if (objectRef instanceof URI) {
            vcServiceGuid = ManagedUtil.getVcGuid((URI)objectRef);
        } else {
            return null;
        }
        PbmService service = PbmSessionUtil.getService(vcServiceGuid, this._pbmServiceFactory);
        NamespaceCapabilityMetadata[] result = MetadataUtil.getNamespaceCapabilityMetadata(service, resourceType);
        PbmLocalizationUtil.localizeNamespaceCapabilityMetadata(result, VimSessionUtil.getService((String)vcServiceGuid));
        return result;
    }

    @type(value="Datastore")
    public CapacityPerCapabilityProfileData[] getCapacityPerCapabilityProfileStats(ManagedObjectReference datastoreRef) throws Exception {
        Profile[] capabilityProfiles = this.getCapabilityProfiles(datastoreRef);
        if (capabilityProfiles == null || capabilityProfiles.length == 0) {
            return null;
        }
        try {
            String vcServiceGuid = datastoreRef.getServerGuid();
            PbmService pbmService = PbmSessionUtil.getService(vcServiceGuid, this._pbmServiceFactory);
            HashMap<String, Profile> profileMap = new HashMap<String, Profile>();
            ProfileId[] capabilityProfileIds = new ProfileId[capabilityProfiles.length];
            for (int i = 0; i < capabilityProfileIds.length; ++i) {
                capabilityProfileIds[i] = capabilityProfiles[i].profileId;
                profileMap.put(capabilityProfiles[i].profileId.uniqueId, capabilityProfiles[i]);
            }
            ProfileManager profileManager = pbmService.getProfileManager();
            BlockingFuture future = new BlockingFuture();
            profileManager.querySpaceStatsForStorageContainer(ManagedUtil.managedObjectRefToServerObjectRef(datastoreRef), capabilityProfileIds, (Future)future);
            DatastoreSpaceStatistics[] datastoreStats = (DatastoreSpaceStatistics[])future.get();
            if (datastoreStats == null) {
                return null;
            }
            ArrayList<CapacityPerCapabilityProfileData> result = new ArrayList<CapacityPerCapabilityProfileData>();
            for (DatastoreSpaceStatistics stats : datastoreStats) {
                CapacityPerCapabilityProfileData resultItem = this.createCapacityPerCapabilityProfileData(stats, profileMap);
                if (resultItem == null) continue;
                result.add(resultItem);
            }
            return result.toArray(new CapacityPerCapabilityProfileData[result.size()]);
        }
        catch (PbmServiceUnableToConnectException ex) {
            _logger.error((Object)"Failed to retrieve capacity stats for the datastore: ", (Throwable)ex);
            throw PbmUtil.getMethodFault(ex);
        }
        catch (ExecutionException ex) {
            _logger.error((Object)"Failed to retrieve capacity stats for the datastore: ", (Throwable)ex);
            throw PbmUtil.getMethodFault(ex);
        }
    }

    private CapacityPerCapabilityProfileData createCapacityPerCapabilityProfileData(DatastoreSpaceStatistics stats, Map<String, Profile> profileMap) {
        if (stats == null || profileMap == null) {
            return null;
        }
        Profile profile = profileMap.get(stats.profileId);
        if (profile == null) {
            return null;
        }
        CapacityPerCapabilityProfileData result = new CapacityPerCapabilityProfileData();
        result.profileName = profile.name;
        result.freeSpace = stats.physicalFreeInMB * 0x100000L;
        result.usedSpace = stats.physicalUsedInMB * 0x100000L;
        return result;
    }

    private RollupComplianceResult getRollupComplianceResultInternal(PbmService service, ManagedObjectReference vm) throws Exception {
        RollupComplianceResult[] complianceResults = PbmUtil.getRollupComplianceResult(service, new ManagedObjectReference[]{vm});
        if (complianceResults == null || complianceResults.length == 0) {
            return null;
        }
        return complianceResults[0];
    }

    private static VirtualMachineDisk getVirtualMachineDisk(VirtualMachineDisk vmDisk, HashSet<VirtualMachineDisk> associatedDisksSet) {
        for (VirtualMachineDisk disk : associatedDisksSet) {
            if (!disk.virtualMachine.equals((Object)vmDisk.virtualMachine) || disk.diskKey != vmDisk.diskKey) continue;
            return disk;
        }
        return null;
    }
}

