/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.spbm.impl;

import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.spbm.LocationLookupException;
import com.vmware.vsphere.client.spbm.PbmServiceLocationLookup;
import com.vmware.vsphere.client.spbm.util.PbmUtil;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PbmServiceLocationLookupImpl
implements PbmServiceLocationLookup {
    private static final Log _logger = LogFactory.getLog(PbmServiceLocationLookupImpl.class);
    private static final String PBM_SERVICE_SUBDIR = "/pbm/sdk";

    @Override
    public URI getPbmServiceLocation(VcService vcService) throws LocationLookupException {
        String vcServiceUrl = vcService.getServiceUrl();
        if (StringUtil.isNullOrEmpty((String)vcServiceUrl)) {
            _logger.error((Object)"getPbmServiceLocation: Failed to retrieve the VC URL.");
            throw new LocationLookupException(PbmUtil.getLocalizedString("error.FailedToRetrieveVcServiceUrl", new String[0]));
        }
        try {
            URL vcUrl = new URL(vcServiceUrl);
            URL pbmUrl = new URL(vcUrl.getProtocol(), vcUrl.getHost(), vcUrl.getPort(), PBM_SERVICE_SUBDIR);
            return pbmUrl.toURI();
        }
        catch (URISyntaxException e) {
            _logger.error((Object)e);
            throw new LocationLookupException(e);
        }
        catch (MalformedURLException e) {
            _logger.error((Object)e);
            throw new LocationLookupException(e);
        }
    }
}

