/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.spbm.impl;

import com.vmware.vim.binding.pbm.ServerObjectRef;
import com.vmware.vim.binding.pbm.placement.PlacementHub;
import com.vmware.vim.binding.pbm.profile.CapabilityBasedProfileCreateSpec;
import com.vmware.vim.binding.pbm.profile.ProfileId;
import com.vmware.vim.binding.pbm.profile.SubProfileCapabilityConstraints;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.host.VsanInternalSystem;
import com.vmware.vim.binding.vim.vm.device.VirtualDisk;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.Version;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.common.spbm.data.VmStorageProfileAssignmentsData;
import com.vmware.vsphere.client.spbm.PbmService;
import com.vmware.vsphere.client.spbm.PbmServiceFactory;
import com.vmware.vsphere.client.spbm.data.ReapplyCostDatastoreData;
import com.vmware.vsphere.client.spbm.data.VsanDatastoreHostData;
import com.vmware.vsphere.client.spbm.impl.PbmServiceUnableToConnectException;
import com.vmware.vsphere.client.spbm.spec.CalculateConsumptionModelSpec;
import com.vmware.vsphere.client.spbm.spec.CalculateCostSpecBase;
import com.vmware.vsphere.client.spbm.spec.CalculateDiskReconfigureCostSpec;
import com.vmware.vsphere.client.spbm.spec.CalculateProvisioningCostSpec;
import com.vmware.vsphere.client.spbm.spec.CalculateReconfigureCostSpec;
import com.vmware.vsphere.client.spbm.util.ManagedUtil;
import com.vmware.vsphere.client.spbm.util.MetadataUtil;
import com.vmware.vsphere.client.spbm.util.PbmSessionUtil;
import com.vmware.vsphere.client.spbm.util.PbmUtil;
import com.vmware.vsphere.client.vsancommon.data.VsanCreateCostData;
import com.vmware.vsphere.client.vsancommon.data.VsanReconfigureCostData;
import com.vmware.vsphere.client.vsancommon.spec.VsanCalculateCreateCostBatchSpec;
import com.vmware.vsphere.client.vsancommon.spec.VsanCalculateCreateCostSpec;
import com.vmware.vsphere.client.vsancommon.spec.VsanCalculateReconfigureCostBatchSpec;
import com.vmware.vsphere.client.vsancommon.spec.VsanCalculateReconfigureCostSpec;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SpbmWhatIfPropertyProvider
implements PropertyProviderBean {
    private final PbmServiceFactory _pbmServiceFactory;
    private final DataService _dataService;
    private static final String DATASTORE_TYPE_PROP = "summary.type";
    private static final String DATASTORE_FREE_SPACE_PROP = "info.freeSpace";
    private static final String DATASTORE_NAME_PROP = "name";
    private static final String HOST_VERSION_PROPERTY = "config.product.version";
    private static final String HOST_CONNECTION_STATE_PROPERTY = "connectionState";
    private static final Version HOST_VERSION_2015 = new Version("6.0.0");
    private static final String VM_PATH_PROPERTY = "vmPathName";
    private static final String VM_DISKS_PROPERTY = "virtualDisks";
    private static final String VM_SPBM_PROFILE_MISMATCH = "vmSpbmProfileMismatch";
    private static final String VM_DATASTORE_PROPERTY = "datastore";
    private static final String VM_STORAGE_PROFILE_ASSIGNMENTS = "vmStorageProfileAssignments";
    private static final String VSAN_DS_TYPE = "vsan";
    private static final String VSAN_DS_TYPE_LOWER = "vsan".toLowerCase();
    private static final String HOST_VSAN_INTERNAL_SYSTEM = "configManager.vsanInternalSystem";
    private static final Log _logger = LogFactory.getLog(SpbmWhatIfPropertyProvider.class);

    public SpbmWhatIfPropertyProvider(PbmServiceFactory pbmServiceFactory, DataService dataService) {
        this._pbmServiceFactory = pbmServiceFactory;
        this._dataService = dataService;
    }

    @type(value="Folder")
    public boolean getIsWhatIfApiSupported(ManagedObjectReference vcRef) throws Exception {
        return this.getWhatIfVsanDatastoreAndHost(vcRef) != null;
    }

    @type(value="Folder")
    public VsanDatastoreHostData getWhatIfVsanDatastoreAndHost(ManagedObjectReference vcRef) throws Exception {
        try {
            Iterator<ManagedObjectReference> i$;
            Map<ManagedObjectReference, ManagedObjectReference> connectedHosts;
            Map<ManagedObjectReference, ReapplyCostDatastoreData> vsanDatastores = this.getVsanDatastoresForVc(vcRef);
            if (vsanDatastores != null && (connectedHosts = this.getConnectedHosts(vsanDatastores.keySet())) != null && (i$ = connectedHosts.keySet().iterator()).hasNext()) {
                ManagedObjectReference datastoreRef = i$.next();
                VsanDatastoreHostData result = new VsanDatastoreHostData();
                result.datastoreRef = datastoreRef;
                result.hostRef = connectedHosts.get(datastoreRef);
                return result;
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed to find host and datastore for WhatIf API: ", (Throwable)ex);
            throw PbmUtil.getMethodFault(ex);
        }
        return null;
    }

    @type(value="Folder")
    public VsanCreateCostData getSpbmStorageConsumptionModel(ManagedObjectReference vcRef, CalculateConsumptionModelSpec spec) throws Exception {
        try {
            PbmService pbmService = PbmSessionUtil.getService(vcRef.getServerGuid(), this._pbmServiceFactory);
            if (spec.createProfileSpec.constraints instanceof SubProfileCapabilityConstraints) {
                SubProfileCapabilityConstraints subProfileConstraints = (SubProfileCapabilityConstraints)spec.createProfileSpec.constraints;
                MetadataUtil.updateValueTypesInSubProfiles(subProfileConstraints.subProfiles, pbmService, spec.createProfileSpec.resourceType);
            }
            String profileContent = this.getProfileContentAsStringBySpec(pbmService, spec.datastore, spec.createProfileSpec);
            VsanCalculateCreateCostSpec createCostSpec = new VsanCalculateCreateCostSpec();
            createCostSpec.policy = profileContent;
            createCostSpec.profileId = "";
            createCostSpec.size = new long[]{spec.capacityInBytes};
            VsanCalculateCreateCostBatchSpec batchSpec = new VsanCalculateCreateCostBatchSpec();
            batchSpec.specs = new VsanCalculateCreateCostSpec[]{createCostSpec};
            batchSpec.ignoreSatisfiability = true;
            VsanCreateCostData[] result = this.getVsanCalculatedCreateCost(spec.host, batchSpec);
            if (result != null && result.length > 0) {
                return result[0];
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed to find host and datastore for WhatIf API: ", (Throwable)ex);
            throw PbmUtil.getMethodFault(ex);
        }
        return null;
    }

    @type(value="PbmRequirementStorageProfile")
    public ReapplyCostDatastoreData[] getSpbmReapplyProfileCostData(URI profileUri) throws Exception {
        try {
            ProfileId profileId = ManagedUtil.uriToProfileId(profileUri);
            String vcGuid = ManagedUtil.getVcGuid(profileUri);
            ManagedObjectReference vcRef = ManagedUtil.buildVcMoRef(vcGuid);
            Map<ManagedObjectReference, ReapplyCostDatastoreData> vsanDatastores = this.getVsanDatastoresForVc(vcRef);
            List<CalculateReconfigureCostSpec> specs = this.getReconfigureCostSpecsForProfile(vcGuid, profileId, vsanDatastores);
            if (specs == null || specs.isEmpty()) {
                return new ReapplyCostDatastoreData[0];
            }
            VsanReconfigureCostData[] reconfigureCosts = this.getSpbmReconfigureCostDataInternal(vcRef, specs.toArray(new CalculateReconfigureCostSpec[specs.size()]), false);
            this.populateReconfigureCostsForDatastore(specs, reconfigureCosts, vsanDatastores);
            ArrayList<ReapplyCostDatastoreData> result = new ArrayList<ReapplyCostDatastoreData>();
            for (ReapplyCostDatastoreData datastoreData : vsanDatastores.values()) {
                if (datastoreData.reconfigureCosts == null || datastoreData.reconfigureCosts.isEmpty()) continue;
                result.add(datastoreData);
            }
            return result.toArray(new ReapplyCostDatastoreData[result.size()]);
        }
        catch (PbmServiceUnableToConnectException ex) {
            _logger.error((Object)"Failed to calculate reapply profile cost data: ", (Throwable)ex);
            throw PbmUtil.getMethodFault(ex);
        }
        catch (ExecutionException ex) {
            _logger.error((Object)"Failed to calculate reapply profile cost data: ", (Throwable)ex);
            throw PbmUtil.getMethodFault(ex);
        }
    }

    @type(value="Folder")
    public ReapplyCostDatastoreData[] getSpbmReapplyProfilesCostData(ManagedObjectReference _vcRef, Object[] vms) throws Exception {
        try {
            Map<String, ArrayList<ManagedObjectReference>> vmGroups = ManagedUtil.groupMoRefsByVcGuid(vms);
            if (vmGroups.isEmpty()) {
                return new ReapplyCostDatastoreData[0];
            }
            ArrayList<ReapplyCostDatastoreData> result = new ArrayList<ReapplyCostDatastoreData>();
            for (String vcGuid : vmGroups.keySet()) {
                ManagedObjectReference vcRef = ManagedUtil.buildVcMoRef(vcGuid);
                Map<ManagedObjectReference, ReapplyCostDatastoreData> vsanDatastores = this.getVsanDatastoresForVc(vcRef);
                if (vsanDatastores.isEmpty()) continue;
                Map<ManagedObjectReference, VmData> vmData = this.getVmData(vmGroups.get(vcGuid).toArray(), true);
                this.populateVsanReconfigureCostDataForVms(vcRef, vsanDatastores, vmData);
                for (ReapplyCostDatastoreData datastoreData : vsanDatastores.values()) {
                    if (datastoreData.reconfigureCosts == null || datastoreData.reconfigureCosts.isEmpty()) continue;
                    result.add(datastoreData);
                }
            }
            return result.toArray(new ReapplyCostDatastoreData[result.size()]);
        }
        catch (PbmServiceUnableToConnectException ex) {
            _logger.error((Object)"Failed to calculate reapply profile cost data: ", (Throwable)ex);
            throw PbmUtil.getMethodFault(ex);
        }
        catch (ExecutionException ex) {
            _logger.error((Object)"Failed to calculate reapply profile cost data: ", (Throwable)ex);
            throw PbmUtil.getMethodFault(ex);
        }
    }

    @type(value="Folder")
    public VsanCreateCostData[] getSpbmCreateCostData(ManagedObjectReference vcRef, Object[] specs) throws Exception {
        if (specs == null || specs.length == 0) {
            return new VsanCreateCostData[0];
        }
        try {
            CalculateCostSpecBase[] newItemSpecs = new CalculateProvisioningCostSpec[specs.length];
            for (int i = 0; i < specs.length; ++i) {
                if (!(specs[i] instanceof CalculateProvisioningCostSpec)) {
                    _logger.error((Object)"getSpbmCreateCostData: invalid argument!");
                    return new VsanCreateCostData[0];
                }
                newItemSpecs[i] = (CalculateProvisioningCostSpec)((Object)specs[i]);
            }
            Map<ManagedObjectReference, List<CalculateCostSpecBase>> datastoreGroups = this.groupSpecsByDatastore(newItemSpecs);
            List<ManagedObjectReference> vsanDatastores = this.getVsanDatastores(datastoreGroups.keySet().toArray());
            Map<ManagedObjectReference, ManagedObjectReference> connectedVsanHosts = this.getConnectedHosts(vsanDatastores);
            Map<String, VsanCreateCostData> createCostData = this.getVsanCreateCostData(vcRef.getServerGuid(), connectedVsanHosts, datastoreGroups);
            VsanCreateCostData[] result = new VsanCreateCostData[newItemSpecs.length];
            for (int i = 0; i < result.length; ++i) {
                ManagedObjectReference containerRef = ((CalculateProvisioningCostSpec)newItemSpecs[i]).storageContainer;
                String profileId = SpbmWhatIfPropertyProvider.getUniqueId(((CalculateProvisioningCostSpec)newItemSpecs[i]).profileId);
                String resultKey = SpbmWhatIfPropertyProvider.generateCreateResultKey(containerRef.getValue(), profileId, ((CalculateProvisioningCostSpec)newItemSpecs[i]).sizeInBytes);
                if (createCostData.containsKey(resultKey)) {
                    result[i] = createCostData.get(resultKey);
                    continue;
                }
                result[i] = new VsanCreateCostData();
                if (((CalculateProvisioningCostSpec)newItemSpecs[i]).profileId != null) {
                    result[i].profileId = profileId;
                }
                result[i].size = ((CalculateProvisioningCostSpec)newItemSpecs[i]).sizeInBytes;
            }
            return result;
        }
        catch (PbmServiceUnableToConnectException ex) {
            _logger.error((Object)"Failed to calculate create cost data: ", (Throwable)ex);
            throw PbmUtil.getMethodFault(ex);
        }
        catch (ExecutionException ex) {
            _logger.error((Object)"Failed to calculate create cost data: ", (Throwable)ex);
            throw PbmUtil.getMethodFault(ex);
        }
    }

    @type(value="Folder")
    public VsanReconfigureCostData[] getSpbmReconfigureCostData(ManagedObjectReference vcRef, Object[] specs) throws Exception {
        if (specs == null || specs.length == 0) {
            return null;
        }
        try {
            CalculateReconfigureCostSpec[] reconfigSpecs = new CalculateReconfigureCostSpec[specs.length];
            for (int i = 0; i < specs.length; ++i) {
                if (!(specs[i] instanceof CalculateReconfigureCostSpec)) {
                    _logger.error((Object)"getSpbmReconfigureCostData: invalid argument!");
                    return null;
                }
                reconfigSpecs[i] = (CalculateReconfigureCostSpec)((Object)specs[i]);
            }
            return this.getSpbmReconfigureCostDataInternal(vcRef, reconfigSpecs, true);
        }
        catch (PbmServiceUnableToConnectException ex) {
            _logger.error((Object)"Failed to calculate reconifgure cost data: ", (Throwable)ex);
            throw PbmUtil.getMethodFault(ex);
        }
        catch (ExecutionException ex) {
            _logger.error((Object)"Failed to calculate reconfigure cost data: ", (Throwable)ex);
            throw PbmUtil.getMethodFault(ex);
        }
    }

    @type(value="Folder")
    public VsanReconfigureCostData getSpbmDiskReconfigureCostData(ManagedObjectReference vcRef, CalculateDiskReconfigureCostSpec spec) throws Exception {
        if (spec == null) {
            return null;
        }
        try {
            PbmService pbmService = PbmSessionUtil.getService(vcRef.getServerGuid(), this._pbmServiceFactory);
            VsanReconfigureCostData result = new VsanReconfigureCostData();
            result.diskVsanUuid = spec.diskVsanUuid;
            List<ManagedObjectReference> vsanDatastores = this.getVsanDatastores(new Object[]{spec.storageContainer});
            Map<ManagedObjectReference, ManagedObjectReference> connectedVsanHosts = this.getConnectedHosts(vsanDatastores);
            if (connectedVsanHosts == null || connectedVsanHosts.isEmpty()) {
                return result;
            }
            ManagedObjectReference vsanHost = connectedVsanHosts.get(spec.storageContainer);
            if (vsanHost == null) {
                return result;
            }
            String profileContent = this.getProfileContentAsString(pbmService, spec.storageContainer, spec.profileId);
            VsanInternalSystem.PolicySatisfiability reconfigureSatisfiability = this.getReconfigureDiskPolicySatisfiability(profileContent, spec.diskVsanUuid, vsanHost, spec.storageContainer);
            result.cost = reconfigureSatisfiability;
            if (SpbmWhatIfPropertyProvider.isNullOrHasError(reconfigureSatisfiability) || spec.newDiskSize == null || spec.newDiskSize <= 0L) {
                return result;
            }
            VsanInternalSystem.PolicySatisfiability createSatisfiability = this.getCreateDiskPolicySatisfiability(profileContent, spec.newDiskSize, vsanHost, spec.storageContainer);
            SpbmWhatIfPropertyProvider.updateDiskConsumptionForNewSize(reconfigureSatisfiability, createSatisfiability);
            return result;
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed to calculate the reconfigure cost for disk!", (Throwable)ex);
            throw ex;
        }
    }

    private static void updateDiskConsumptionForNewSize(VsanInternalSystem.PolicySatisfiability reconfigCost, VsanInternalSystem.PolicySatisfiability createCost) {
        if (SpbmWhatIfPropertyProvider.isNullOrHasError(createCost)) {
            return;
        }
        reconfigCost.cost.changeDataSize = Math.max(reconfigCost.cost.changeDataSize, createCost.cost.changeDataSize - reconfigCost.cost.currentDataSize);
        reconfigCost.cost.changeFlashReadCacheSize = createCost.cost.changeFlashReadCacheSize - reconfigCost.cost.currentFlashReadCacheSize;
    }

    private VsanInternalSystem.PolicySatisfiability getReconfigureDiskPolicySatisfiability(String profileContent, String diskUuid, ManagedObjectReference vsanHost, ManagedObjectReference dsRef) throws Exception {
        VsanCalculateReconfigureCostBatchSpec batchSpec = new VsanCalculateReconfigureCostBatchSpec();
        batchSpec.ignoreSatisfiability = false;
        VsanCalculateReconfigureCostSpec spec = new VsanCalculateReconfigureCostSpec();
        spec.policy = profileContent;
        spec.diskVsanUuids = new String[]{diskUuid};
        batchSpec.specs = new VsanCalculateReconfigureCostSpec[]{spec};
        VsanReconfigureCostData[] data2 = this.getVsanCalculatedReconfigureCost(vsanHost, batchSpec);
        if (data2 != null && data2.length > 0) {
            VsanReconfigureCostData vsanReconfigureCostData = data2[0];
            if (vsanReconfigureCostData.cost != null && vsanReconfigureCostData.cost instanceof VsanInternalSystem.PolicySatisfiability) {
                return (VsanInternalSystem.PolicySatisfiability)vsanReconfigureCostData.cost;
            }
        }
        return null;
    }

    private VsanInternalSystem.PolicySatisfiability getCreateDiskPolicySatisfiability(String profileContent, long diskSize, ManagedObjectReference vsanHost, ManagedObjectReference dsRef) throws Exception {
        VsanCalculateCreateCostBatchSpec batchSpec = new VsanCalculateCreateCostBatchSpec();
        batchSpec.ignoreSatisfiability = false;
        VsanCalculateCreateCostSpec spec = new VsanCalculateCreateCostSpec();
        spec.policy = profileContent;
        spec.size = new long[]{diskSize};
        batchSpec.specs = new VsanCalculateCreateCostSpec[]{spec};
        VsanCreateCostData[] data2 = this.getVsanCalculatedCreateCost(vsanHost, batchSpec);
        if (data2 != null && data2.length > 0) {
            VsanCreateCostData vsanCreateCostData = data2[0];
            if (vsanCreateCostData.cost != null && vsanCreateCostData.cost instanceof VsanInternalSystem.PolicySatisfiability) {
                return (VsanInternalSystem.PolicySatisfiability)vsanCreateCostData.cost;
            }
        }
        return null;
    }

    private static boolean isNullOrHasError(VsanInternalSystem.PolicySatisfiability policySatisfiability) {
        return policySatisfiability == null || !policySatisfiability.isSatisfiable || policySatisfiability.cost == null;
    }

    private void populateVsanReconfigureCostDataForVms(ManagedObjectReference vcRef, Map<ManagedObjectReference, ReapplyCostDatastoreData> vsanDatastores, Map<ManagedObjectReference, VmData> vmsData) throws Exception {
        ArrayList<CalculateReconfigureCostSpec> specs = new ArrayList<CalculateReconfigureCostSpec>();
        for (VmData vmData : vmsData.values()) {
            ManagedObjectReference vmHomeDatastore;
            if (vmData.profileAssignments == null) continue;
            if (vmData.profileAssignments.homeStorageProfile != null && (vmHomeDatastore = this.getVmHomeDatastore(vmData, vsanDatastores)) != null) {
                CalculateReconfigureCostSpec vmHomeSpec = new CalculateReconfigureCostSpec();
                vmHomeSpec.vmPath = vmData.vmPath;
                vmHomeSpec.profileId = vmData.profileAssignments.homeStorageProfile.profileId;
                vmHomeSpec.storageContainer = vmHomeDatastore;
                specs.add(vmHomeSpec);
            }
            if (vmData.virtualDisks == null) continue;
            for (VirtualDisk virtualDisk : vmData.virtualDisks) {
                ProfileId diskProfileId;
                if (!(virtualDisk.backing instanceof VirtualDisk.FlatVer2BackingInfo)) continue;
                VirtualDisk.FlatVer2BackingInfo diskBackingInfo = (VirtualDisk.FlatVer2BackingInfo)virtualDisk.backing;
                if (!vsanDatastores.containsKey(diskBackingInfo.datastore) || (diskProfileId = PbmUtil.getDiskProfileId(vmData.profileAssignments, virtualDisk.key)) == null) continue;
                CalculateReconfigureCostSpec diskSpec = this.createReconfigureCostSpecForDisk(diskBackingInfo, diskProfileId);
                specs.add(diskSpec);
            }
        }
        if (specs.isEmpty()) {
            return;
        }
        VsanReconfigureCostData[] reconfigureCosts = this.getSpbmReconfigureCostDataInternal(vcRef, specs.toArray(new CalculateReconfigureCostSpec[specs.size()]), false);
        this.populateReconfigureCostsForDatastore(specs, reconfigureCosts, vsanDatastores);
    }

    private List<CalculateReconfigureCostSpec> getReconfigureCostSpecsForProfile(String vcServiceGuid, ProfileId profileId, Map<ManagedObjectReference, ReapplyCostDatastoreData> vsanDatastores) throws Exception {
        HashSet<ManagedObjectReference> associatedVmHomes = new HashSet<ManagedObjectReference>();
        HashMap<ManagedObjectReference, Set<String>> associatedVmDisks = new HashMap<ManagedObjectReference, Set<String>>();
        this.getAssociatedEntites(vcServiceGuid, profileId, associatedVmHomes, associatedVmDisks);
        HashSet<Object> allVms = new HashSet<Object>();
        allVms.addAll(associatedVmHomes);
        allVms.addAll(associatedVmDisks.keySet());
        ArrayList<CalculateReconfigureCostSpec> result = new ArrayList<CalculateReconfigureCostSpec>();
        if (allVms.isEmpty()) {
            return result;
        }
        Map<ManagedObjectReference, VmData> vmsData = this.getVmData(allVms.toArray(), false);
        for (ManagedObjectReference vmRef : associatedVmHomes) {
            ManagedObjectReference vmHomeDatastore;
            if (!vmsData.containsKey(vmRef)) continue;
            VmData vmData = vmsData.get(vmRef);
            if (!vmData.profileMismatch || (vmHomeDatastore = this.getVmHomeDatastore(vmData, vsanDatastores)) == null) continue;
            CalculateReconfigureCostSpec vmHomeSpec = new CalculateReconfigureCostSpec();
            vmHomeSpec.vmPath = vmData.vmPath;
            vmHomeSpec.profileId = profileId;
            vmHomeSpec.storageContainer = vmHomeDatastore;
            result.add(vmHomeSpec);
        }
        for (VmData vmData : vmsData.values()) {
            if (vmData.virtualDisks == null || !vmData.profileMismatch || !associatedVmDisks.containsKey(vmData.vmRef)) continue;
            Set associatedDisks = (Set)associatedVmDisks.get(vmData.vmRef);
            for (VirtualDisk virtualDisk : vmData.virtualDisks) {
                if (!associatedDisks.contains(Integer.toString(virtualDisk.key)) || !(virtualDisk.backing instanceof VirtualDisk.FlatVer2BackingInfo)) continue;
                VirtualDisk.FlatVer2BackingInfo diskBackingInfo = (VirtualDisk.FlatVer2BackingInfo)virtualDisk.backing;
                if (!vsanDatastores.containsKey(diskBackingInfo.datastore)) continue;
                CalculateReconfigureCostSpec diskSpec = this.createReconfigureCostSpecForDisk(diskBackingInfo, profileId);
                result.add(diskSpec);
            }
        }
        return result;
    }

    private void getAssociatedEntites(String vcServiceGuid, ProfileId profileId, Set<ManagedObjectReference> associatedVmHomes, Map<ManagedObjectReference, Set<String>> associatedVmDisks) throws Exception {
        PbmService pbmService = PbmSessionUtil.getService(vcServiceGuid, this._pbmServiceFactory);
        BlockingFuture vmsFuture = new BlockingFuture();
        pbmService.getProfileManager().queryAssociatedEntity(profileId, ServerObjectRef.ObjectType.virtualMachine.toString(), (Future)vmsFuture);
        ServerObjectRef[] vmSoRefs = (ServerObjectRef[])vmsFuture.get();
        if (vmSoRefs != null) {
            for (ServerObjectRef vmSoRef : vmSoRefs) {
                associatedVmHomes.add(ManagedUtil.buildMoRef(vmSoRef.key, "VirtualMachine", vcServiceGuid));
            }
        }
        BlockingFuture diskFuture = new BlockingFuture();
        pbmService.getProfileManager().queryAssociatedEntity(profileId, ServerObjectRef.ObjectType.virtualDiskId.toString(), (Future)diskFuture);
        ServerObjectRef[] diskSoRefs = (ServerObjectRef[])diskFuture.get();
        if (diskSoRefs != null) {
            for (ServerObjectRef diskSoRef : diskSoRefs) {
                String[] diskArtifacts = diskSoRef.key.split(":");
                if (diskArtifacts.length != 2) {
                    _logger.error((Object)("Failed to parse virtual disk key. Expected <vm-id>:<device-key>, got: " + diskSoRef.key));
                    continue;
                }
                ManagedObjectReference vmRef = ManagedUtil.buildMoRef(diskArtifacts[0], "VirtualMachine", vcServiceGuid);
                if (!associatedVmDisks.containsKey(vmRef)) {
                    associatedVmDisks.put(vmRef, new HashSet());
                }
                associatedVmDisks.get(vmRef).add(diskArtifacts[1]);
            }
        }
    }

    private VsanReconfigureCostData[] getSpbmReconfigureCostDataInternal(ManagedObjectReference vcRef, CalculateReconfigureCostSpec[] reconfigSpecs, boolean filterOutVsanDatastores) throws Exception {
        Map<ManagedObjectReference, List<CalculateCostSpecBase>> datastoreGroups = this.groupSpecsByDatastore(reconfigSpecs);
        Collection<ManagedObjectReference> vsanDatastores = filterOutVsanDatastores ? this.getVsanDatastores(datastoreGroups.keySet().toArray()) : datastoreGroups.keySet();
        Map<ManagedObjectReference, ManagedObjectReference> connectedVsanHosts = this.getConnectedHosts(vsanDatastores);
        Map<String, VsanReconfigureCostData> reconfigCostData = this.getVsanReconfigCostData(vcRef.getServerGuid(), connectedVsanHosts, datastoreGroups);
        VsanReconfigureCostData[] result = new VsanReconfigureCostData[reconfigSpecs.length];
        for (int i = 0; i < result.length; ++i) {
            CalculateReconfigureCostSpec reconfigSpec = reconfigSpecs[i];
            String resultKey = reconfigSpec.storageContainer.getValue() + ":";
            if (reconfigSpec.diskVsanUuid != null) {
                resultKey = resultKey + reconfigSpec.diskVsanUuid;
            } else if (reconfigSpec.vmPath != null) {
                resultKey = resultKey + reconfigSpec.vmPath;
            }
            if (reconfigCostData.containsKey(resultKey)) {
                result[i] = reconfigCostData.get(resultKey);
                continue;
            }
            result[i] = new VsanReconfigureCostData();
            result[i].vmPath = reconfigSpec.vmPath;
            result[i].diskVsanUuid = reconfigSpec.diskVsanUuid;
        }
        return result;
    }

    private Map<String, VsanCreateCostData> getVsanCreateCostData(String vcServiceGuid, Map<ManagedObjectReference, ManagedObjectReference> connectedVsanHosts, Map<ManagedObjectReference, List<CalculateCostSpecBase>> datastoreGroups) throws Exception {
        HashMap<String, VsanCreateCostData> createCostData = new HashMap<String, VsanCreateCostData>();
        if (connectedVsanHosts == null || connectedVsanHosts.isEmpty()) {
            return createCostData;
        }
        PbmService pbmService = PbmSessionUtil.getService(vcServiceGuid, this._pbmServiceFactory);
        for (ManagedObjectReference vsanDatastore : connectedVsanHosts.keySet()) {
            HashMap<String, String> profileContent = new HashMap<String, String>();
            HashMap sizes = new HashMap();
            for (CalculateCostSpecBase baseSpec : datastoreGroups.get(vsanDatastore)) {
                CalculateProvisioningCostSpec spec = (CalculateProvisioningCostSpec)baseSpec;
                String profileKey = SpbmWhatIfPropertyProvider.getUniqueId(spec.profileId);
                if (spec.sizeInBytes <= 0L) {
                    VsanCreateCostData emptyCost = new VsanCreateCostData();
                    emptyCost.cost = SpbmWhatIfPropertyProvider.getEmptyCreatePolicySatisfiability();
                    emptyCost.profileId = profileKey;
                    emptyCost.size = spec.sizeInBytes;
                    createCostData.put(SpbmWhatIfPropertyProvider.generateCreateResultKey(vsanDatastore.getValue(), profileKey, spec.sizeInBytes), emptyCost);
                    continue;
                }
                if (!sizes.containsKey(profileKey)) {
                    sizes.put(profileKey, new HashSet());
                    String content = this.getProfileContentAsString(pbmService, vsanDatastore, spec.profileId);
                    profileContent.put(profileKey, content);
                }
                ((Set)sizes.get(profileKey)).add(spec.sizeInBytes);
            }
            if (sizes.isEmpty()) continue;
            ArrayList<VsanCalculateCreateCostSpec> createCostSpecs = new ArrayList<VsanCalculateCreateCostSpec>();
            for (String profileKey : sizes.keySet()) {
                VsanCalculateCreateCostSpec createCostSpec = new VsanCalculateCreateCostSpec();
                createCostSpec.policy = (String)profileContent.get(profileKey);
                createCostSpec.size = SpbmWhatIfPropertyProvider.setOfLongsToArray((Set)sizes.get(profileKey));
                if (!profileKey.isEmpty()) {
                    createCostSpec.profileId = profileKey;
                }
                createCostSpecs.add(createCostSpec);
            }
            VsanCalculateCreateCostBatchSpec batchSpec = new VsanCalculateCreateCostBatchSpec();
            batchSpec.specs = createCostSpecs.toArray(new VsanCalculateCreateCostSpec[createCostSpecs.size()]);
            ManagedObjectReference hostRef = connectedVsanHosts.get(vsanDatastore);
            VsanCreateCostData[] data2 = this.getVsanCalculatedCreateCost(hostRef, batchSpec);
            if (data2 == null) continue;
            for (VsanCreateCostData costData : data2) {
                String resultKey = SpbmWhatIfPropertyProvider.generateCreateResultKey(vsanDatastore.getValue(), costData.profileId, costData.size);
                createCostData.put(resultKey, costData);
            }
        }
        return createCostData;
    }

    private static String generateCreateResultKey(String datastoreId, String profileId, long size) {
        String result = datastoreId + ":";
        if (profileId != null) {
            result = result + profileId;
        }
        result = result + ":" + size;
        return result;
    }

    private static VsanInternalSystem.PolicySatisfiability getEmptyCreatePolicySatisfiability() {
        VsanInternalSystem.PolicySatisfiability result = new VsanInternalSystem.PolicySatisfiability();
        result.isSatisfiable = true;
        result.cost = new VsanInternalSystem.PolicyCost();
        result.cost.changeDataSize = 0L;
        result.cost.changeFlashReadCacheSize = 0L;
        result.cost.currentDataSize = 0L;
        result.cost.currentFlashReadCacheSize = 0L;
        result.cost.diskSpaceToAddressSpaceRatio = Float.valueOf(1.0f);
        result.cost.copyDataSize = 0L;
        result.cost.tempDataSize = 0L;
        return result;
    }

    private Map<String, VsanReconfigureCostData> getVsanReconfigCostData(String vcServiceGuid, Map<ManagedObjectReference, ManagedObjectReference> connectedVsanHosts, Map<ManagedObjectReference, List<CalculateCostSpecBase>> datastoreGroups) throws Exception {
        HashMap<String, VsanReconfigureCostData> reconfigCostData = new HashMap<String, VsanReconfigureCostData>();
        if (connectedVsanHosts == null || connectedVsanHosts.isEmpty()) {
            return reconfigCostData;
        }
        PbmService pbmService = PbmSessionUtil.getService(vcServiceGuid, this._pbmServiceFactory);
        for (ManagedObjectReference vsanDatastore : connectedVsanHosts.keySet()) {
            HashMap<String, String> profileContent = new HashMap<String, String>();
            HashMap vmPaths = new HashMap();
            HashMap diskUuids = new HashMap();
            for (CalculateCostSpecBase baseSpec : datastoreGroups.get(vsanDatastore)) {
                CalculateReconfigureCostSpec reconfigSpec = (CalculateReconfigureCostSpec)baseSpec;
                String profileKey = SpbmWhatIfPropertyProvider.getUniqueId(reconfigSpec.profileId);
                if (!profileContent.containsKey(profileKey)) {
                    String content = this.getProfileContentAsString(pbmService, vsanDatastore, reconfigSpec.profileId);
                    profileContent.put(profileKey, content);
                    vmPaths.put(profileKey, new ArrayList());
                    diskUuids.put(profileKey, new ArrayList());
                }
                if (reconfigSpec.diskVsanUuid != null) {
                    ((List)diskUuids.get(profileKey)).add(reconfigSpec.diskVsanUuid);
                    continue;
                }
                if (reconfigSpec.vmPath == null) continue;
                ((List)vmPaths.get(profileKey)).add(reconfigSpec.vmPath);
            }
            ArrayList<VsanCalculateReconfigureCostSpec> reconfigureCostSpecs = new ArrayList<VsanCalculateReconfigureCostSpec>();
            for (String profileKey : profileContent.keySet()) {
                VsanCalculateReconfigureCostSpec reconfigureCostSpec = new VsanCalculateReconfigureCostSpec();
                reconfigureCostSpec.policy = (String)profileContent.get(profileKey);
                reconfigureCostSpec.vmPaths = ((List)vmPaths.get(profileKey)).toArray(new String[0]);
                reconfigureCostSpec.diskVsanUuids = ((List)diskUuids.get(profileKey)).toArray(new String[0]);
                reconfigureCostSpecs.add(reconfigureCostSpec);
            }
            VsanCalculateReconfigureCostBatchSpec batchSpec = new VsanCalculateReconfigureCostBatchSpec();
            batchSpec.specs = reconfigureCostSpecs.toArray(new VsanCalculateReconfigureCostSpec[reconfigureCostSpecs.size()]);
            ManagedObjectReference hostRef = connectedVsanHosts.get(vsanDatastore);
            VsanReconfigureCostData[] data2 = this.getVsanCalculatedReconfigureCost(hostRef, batchSpec);
            if (data2 == null) continue;
            for (VsanReconfigureCostData costData : data2) {
                String resultKey = vsanDatastore.getValue() + ":";
                if (costData.vmPath != null) {
                    resultKey = resultKey + costData.vmPath;
                } else if (costData.diskVsanUuid != null) {
                    resultKey = resultKey + costData.diskVsanUuid;
                }
                if (resultKey == null) continue;
                reconfigCostData.put(resultKey, costData);
            }
        }
        return reconfigCostData;
    }

    private static String getUniqueId(ProfileId profileId) {
        if (profileId == null) {
            return "";
        }
        return profileId.uniqueId;
    }

    private static long[] setOfLongsToArray(Set<Long> set) {
        if (set == null) {
            return null;
        }
        long[] result = new long[set.size()];
        int i = 0;
        for (Long value : set) {
            result[i] = value;
            ++i;
        }
        return result;
    }

    private Map<ManagedObjectReference, ManagedObjectReference> getConnectedHosts(Collection<ManagedObjectReference> datastores) throws Exception {
        HashMap<ManagedObjectReference, ManagedObjectReference> result = new HashMap<ManagedObjectReference, ManagedObjectReference>();
        if (datastores == null || datastores.isEmpty()) {
            return result;
        }
        ArrayList<QuerySpec> querySpecs = new ArrayList<QuerySpec>();
        for (ManagedObjectReference dsRef : datastores) {
            Constraint dsHostsConstraint = QueryUtil.createConstraintForRelationship((Object)dsRef, (String)"hostKey", (String)HostSystem.class.getSimpleName());
            PropertyConstraint connectedHostsConstraint = QueryUtil.createPropertyConstraint((String)HostSystem.class.getSimpleName(), (String)HOST_CONNECTION_STATE_PROPERTY, (Comparator)Comparator.EQUALS, (Object)HostSystem.ConnectionState.connected.name());
            Constraint dsConnectedHosts = QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{dsHostsConstraint, connectedHostsConstraint}, (Conjoiner)Conjoiner.AND);
            QuerySpec qSpec = QueryUtil.buildQuerySpec((Constraint)dsConnectedHosts, (String[])new String[]{HOST_VERSION_PROPERTY});
            qSpec.name = dsRef.getValue();
            querySpecs.add(qSpec);
        }
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = querySpecs.toArray(new QuerySpec[0]);
        Response resultSets = this._dataService.getData(requestSpec);
        if (resultSets == null || resultSets.resultSet == null) {
            return result;
        }
        block1: for (ResultSet resultSet : resultSets.resultSet) {
            if (resultSet.items == null) continue;
            for (ResultItem resultItem : resultSet.items) {
                String version;
                Version esxVersion;
                if (resultItem.properties == null || resultItem.properties.length == 0 || (esxVersion = new Version(version = (String)resultItem.properties[0].value)).compareTo(HOST_VERSION_2015) < 0) continue;
                ManagedObjectReference connectedHostRef = (ManagedObjectReference)resultSet.items[0].resourceObject;
                ManagedObjectReference dsRef = new ManagedObjectReference(Datastore.class.getSimpleName(), resultSet.queryName, connectedHostRef.getServerGuid());
                result.put(dsRef, connectedHostRef);
                continue block1;
            }
        }
        return result;
    }

    private List<ManagedObjectReference> getVsanDatastores(Object[] storageContainers) throws Exception {
        ArrayList<ManagedObjectReference> dsRefs = new ArrayList<ManagedObjectReference>();
        for (Object storageContainer : storageContainers) {
            if (!(storageContainer instanceof ManagedObjectReference)) continue;
            ManagedObjectReference storageContainerRef = (ManagedObjectReference)storageContainer;
            if (!Datastore.class.getSimpleName().equals(storageContainerRef.getType())) continue;
            dsRefs.add(storageContainerRef);
        }
        if (dsRefs.isEmpty()) {
            return dsRefs;
        }
        PropertyValue[] dsProperties = QueryUtil.getProperties((DataService)this._dataService, (Object[])dsRefs.toArray(), (String[])new String[]{DATASTORE_TYPE_PROP});
        ArrayList<ManagedObjectReference> vsanDatastores = new ArrayList<ManagedObjectReference>();
        if (dsProperties != null) {
            for (PropertyValue propValue : dsProperties) {
                String dsType = (String)propValue.value;
                ManagedObjectReference dsRef = (ManagedObjectReference)propValue.resourceObject;
                if (dsType == null || !VSAN_DS_TYPE_LOWER.equals(dsType.toLowerCase())) continue;
                vsanDatastores.add(dsRef);
            }
        }
        return vsanDatastores;
    }

    private void populateReconfigureCostsForDatastore(List<CalculateReconfigureCostSpec> specs, VsanReconfigureCostData[] reconfigureCosts, Map<ManagedObjectReference, ReapplyCostDatastoreData> datastoreDataMap) {
        if (specs.size() != reconfigureCosts.length) {
            return;
        }
        for (int i = 0; i < reconfigureCosts.length; ++i) {
            if (reconfigureCosts[i].cost == null || !(reconfigureCosts[i].cost instanceof VsanInternalSystem.PolicySatisfiability)) continue;
            VsanInternalSystem.PolicySatisfiability cost = (VsanInternalSystem.PolicySatisfiability)reconfigureCosts[i].cost;
            ManagedObjectReference dsRef = specs.get((int)i).storageContainer;
            ReapplyCostDatastoreData datastoreData = datastoreDataMap.get(dsRef);
            if (datastoreData == null) continue;
            if (datastoreData.reconfigureCosts == null) {
                datastoreData.reconfigureCosts = new ArrayList<VsanReconfigureCostData>();
            }
            datastoreData.reconfigureCosts.add(reconfigureCosts[i]);
            if (!cost.isSatisfiable || cost.cost == null) continue;
            datastoreData.currentConsumption += cost.cost.currentDataSize.longValue();
            datastoreData.currentSsdConsumption += cost.cost.currentFlashReadCacheSize.longValue();
            datastoreData.deltaConsumption += cost.cost.changeDataSize.longValue();
            datastoreData.deltaSsdConsumption += cost.cost.changeFlashReadCacheSize.longValue();
            datastoreData.copyDataSize += cost.cost.copyDataSize.longValue();
        }
    }

    private Map<ManagedObjectReference, List<CalculateCostSpecBase>> groupSpecsByDatastore(CalculateCostSpecBase[] specs) {
        HashMap<ManagedObjectReference, List<CalculateCostSpecBase>> result = new HashMap<ManagedObjectReference, List<CalculateCostSpecBase>>();
        for (CalculateCostSpecBase spec : specs) {
            if (!result.containsKey(spec.storageContainer)) {
                result.put(spec.storageContainer, new ArrayList());
            }
            result.get(spec.storageContainer).add(spec);
        }
        return result;
    }

    private String getProfileContentAsString(PbmService pbmService, ManagedObjectReference containerRef, ProfileId profileId) throws Exception {
        PlacementHub hub = PbmUtil.moRefToPlacementHub(containerRef);
        BlockingFuture future = new BlockingFuture();
        if (profileId == null && PbmUtil.isDrpSupportedByVC(containerRef)) {
            BlockingFuture profileIdFuture = new BlockingFuture();
            pbmService.getProfileManager().queryDefaultRequirementProfile(hub, (Future)profileIdFuture);
            profileId = (ProfileId)profileIdFuture.get();
        }
        if (profileId != null) {
            pbmService.getProfileManager().retrieveContentAsString(profileId, hub, null, (Future)future);
            String result = (String)future.get();
            if (result == null || result.isEmpty()) {
                _logger.warn((Object)("PbmService.retrieveContentAsString(): empty result for " + profileId.uniqueId));
                result = "";
            }
            return result;
        }
        return "";
    }

    private String getProfileContentAsStringBySpec(PbmService pbmService, ManagedObjectReference containerRef, CapabilityBasedProfileCreateSpec spec) throws Exception {
        PlacementHub hub = PbmUtil.moRefToPlacementHub(containerRef);
        BlockingFuture future = new BlockingFuture();
        pbmService.getProfileManager().retrieveContentAsStringBySpec(spec, hub, (Future)future);
        String result = (String)future.get();
        if (result == null || result.isEmpty()) {
            _logger.warn((Object)"PbmService.getProfileContentAsStringBySpec(): empty result!");
            result = "";
        }
        return result;
    }

    private Map<ManagedObjectReference, VmData> getVmData(Object[] vmRefs, boolean retrieveProfileAssingments) throws Exception {
        HashMap<ManagedObjectReference, VmData> result = new HashMap<ManagedObjectReference, VmData>();
        String[] propetiesToRetrieve = retrieveProfileAssingments ? new String[]{VM_PATH_PROPERTY, VM_DISKS_PROPERTY, VM_DATASTORE_PROPERTY, VM_STORAGE_PROFILE_ASSIGNMENTS} : new String[]{VM_PATH_PROPERTY, VM_DISKS_PROPERTY, VM_DATASTORE_PROPERTY, VM_SPBM_PROFILE_MISMATCH};
        PropertyValue[] vmProps = QueryUtil.getProperties((DataService)this._dataService, (Object[])vmRefs, (String[])propetiesToRetrieve);
        if (vmProps != null) {
            for (PropertyValue propValue : vmProps) {
                ManagedObjectReference vmRef = (ManagedObjectReference)propValue.resourceObject;
                if (!result.containsKey(vmRef)) {
                    VmData vmData = new VmData();
                    vmData.vmRef = vmRef;
                    result.put(vmRef, vmData);
                }
                if (propValue.propertyName.equals(VM_PATH_PROPERTY)) {
                    ((VmData)result.get((Object)vmRef)).vmPath = (String)propValue.value;
                    continue;
                }
                if (propValue.propertyName.equals(VM_DISKS_PROPERTY)) {
                    ((VmData)result.get((Object)vmRef)).virtualDisks = (VirtualDisk[])propValue.value;
                    continue;
                }
                if (propValue.propertyName.equals(VM_DATASTORE_PROPERTY)) {
                    ((VmData)result.get((Object)vmRef)).vmDatastores = (ManagedObjectReference[])propValue.value;
                    continue;
                }
                if (propValue.propertyName.equals(VM_STORAGE_PROFILE_ASSIGNMENTS)) {
                    ((VmData)result.get((Object)vmRef)).profileAssignments = (VmStorageProfileAssignmentsData)propValue.value;
                    continue;
                }
                if (!propValue.propertyName.equals(VM_SPBM_PROFILE_MISMATCH) || propValue == null || !(propValue.value instanceof Boolean)) continue;
                ((VmData)result.get((Object)vmRef)).profileMismatch = (Boolean)propValue.value;
            }
        }
        return result;
    }

    private Map<ManagedObjectReference, ReapplyCostDatastoreData> getVsanDatastoresForVc(ManagedObjectReference vcRef) throws Exception {
        Constraint allVcDatastores;
        HashMap<ManagedObjectReference, ReapplyCostDatastoreData> result = new HashMap<ManagedObjectReference, ReapplyCostDatastoreData>();
        PropertyConstraint vsanDatastores = QueryUtil.createPropertyConstraint((String)Datastore.class.getSimpleName(), (String)DATASTORE_TYPE_PROP, (Comparator)Comparator.EQUALS, (Object)VSAN_DS_TYPE);
        Constraint allVcVsabDatastores = QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{vsanDatastores, allVcDatastores = QueryUtil.createConstraintForRelationship((Object)vcRef, (String)"allDs", (String)Datastore.class.getSimpleName())}, (Conjoiner)Conjoiner.AND);
        QuerySpec querySpec = QueryUtil.buildQuerySpec((Constraint)allVcVsabDatastores, (String[])new String[]{DATASTORE_NAME_PROP, DATASTORE_FREE_SPACE_PROP});
        ResultSet resultSet = QueryUtil.getData((DataService)this._dataService, (QuerySpec)querySpec);
        if (resultSet == null || resultSet.items == null) {
            return result;
        }
        for (ResultItem resultItem : resultSet.items) {
            ManagedObjectReference dsRef = (ManagedObjectReference)resultItem.resourceObject;
            if (resultItem.properties == null || resultItem.properties.length == 0) continue;
            ReapplyCostDatastoreData datastoreData = (ReapplyCostDatastoreData)((Object)result.get(dsRef));
            if (datastoreData == null) {
                datastoreData = new ReapplyCostDatastoreData();
                datastoreData.datastoreRef = dsRef;
                datastoreData.datastoreType = VSAN_DS_TYPE;
                result.put(dsRef, datastoreData);
            }
            for (PropertyValue propValue : resultItem.properties) {
                if (DATASTORE_NAME_PROP.equals(propValue.propertyName)) {
                    datastoreData.datastoreName = (String)propValue.value;
                    continue;
                }
                if (!DATASTORE_FREE_SPACE_PROP.equals(propValue.propertyName)) continue;
                datastoreData.freeSpace = (Long)propValue.value;
            }
        }
        return result;
    }

    private CalculateReconfigureCostSpec createReconfigureCostSpecForDisk(VirtualDisk.FlatVer2BackingInfo diskBackingInfo, ProfileId diskProfileId) {
        CalculateReconfigureCostSpec diskSpec = new CalculateReconfigureCostSpec();
        diskSpec.diskVsanUuid = diskBackingInfo.backingObjectId;
        diskSpec.profileId = diskProfileId;
        diskSpec.storageContainer = diskBackingInfo.datastore;
        return diskSpec;
    }

    private ManagedObjectReference getVmHomeDatastore(VmData vmData, Map<ManagedObjectReference, ReapplyCostDatastoreData> vsanDatastores) {
        if (vmData == null || vmData.vmDatastores == null || vsanDatastores == null) {
            return null;
        }
        String vmHomeDatastoreName = vmData.getVmPathDatastoreName();
        if (vmHomeDatastoreName == null) {
            return null;
        }
        for (ManagedObjectReference dsRef : vmData.vmDatastores) {
            if (!vsanDatastores.containsKey(dsRef) || !vmHomeDatastoreName.equals(vsanDatastores.get((Object)dsRef).datastoreName)) continue;
            return dsRef;
        }
        return null;
    }

    private VsanCreateCostData[] getVsanCalculatedCreateCost(ManagedObjectReference hostRef, VsanCalculateCreateCostBatchSpec batchSpec) throws Exception {
        if (batchSpec == null || batchSpec.specs == null || batchSpec.specs.length == 0) {
            return null;
        }
        VsanInternalSystem vsanSystem = SpbmWhatIfPropertyProvider.getHostVsanInternalSystem(this._dataService, hostRef);
        if (vsanSystem == null) {
            return null;
        }
        VsanCalculateCreateCostSpec[] specs = batchSpec.specs;
        VsanInternalSystem.NewPolicyBatch[] newPolicyBatch = new VsanInternalSystem.NewPolicyBatch[specs.length];
        for (int i = 0; i < specs.length; ++i) {
            newPolicyBatch[i] = new VsanInternalSystem.NewPolicyBatch();
            newPolicyBatch[i].policy = specs[i].policy;
            newPolicyBatch[i].size = specs[i].size;
        }
        VsanInternalSystem.PolicySatisfiability[] costs = vsanSystem.canProvisionObjects(newPolicyBatch, Boolean.valueOf(batchSpec.ignoreSatisfiability));
        ArrayList<VsanCreateCostData> result = new ArrayList<VsanCreateCostData>();
        int index = 0;
        for (VsanCalculateCreateCostSpec spec : specs) {
            for (long size : spec.size) {
                VsanCreateCostData data2 = new VsanCreateCostData();
                data2.profileId = spec.profileId;
                data2.size = size;
                if (costs != null && index < costs.length) {
                    data2.cost = costs[index];
                    ++index;
                }
                result.add(data2);
            }
        }
        return result.toArray(new VsanCreateCostData[0]);
    }

    /*
     * WARNING - void declaration
     */
    private VsanReconfigureCostData[] getVsanCalculatedReconfigureCost(ManagedObjectReference hostRef, VsanCalculateReconfigureCostBatchSpec batchSpec) throws Exception {
        void var11_24;
        VsanInternalSystem vsanSystem = SpbmWhatIfPropertyProvider.getHostVsanInternalSystem(this._dataService, hostRef);
        if (vsanSystem == null || batchSpec == null || batchSpec.specs == null || batchSpec.specs.length == 0) {
            return null;
        }
        VsanCalculateReconfigureCostSpec[] specs = batchSpec.specs;
        VsanInternalSystem.PolicyChangeBatch[] policyChangeBatch = new VsanInternalSystem.PolicyChangeBatch[specs.length];
        for (int i = 0; i < specs.length; ++i) {
            policyChangeBatch[i] = new VsanInternalSystem.PolicyChangeBatch();
            policyChangeBatch[i].policy = specs[i].policy;
            ArrayList<String> uuid = new ArrayList<String>();
            if (specs[i].diskVsanUuids != null) {
                for (String string : specs[i].diskVsanUuids) {
                    uuid.add(string);
                }
            }
            if (specs[i].vmPaths != null) {
                for (String string : specs[i].vmPaths) {
                    String vmHomeUuid = SpbmWhatIfPropertyProvider.getVmHomeVsanUuid(string);
                    if (vmHomeUuid == null) continue;
                    uuid.add(vmHomeUuid);
                }
            }
            policyChangeBatch[i].uuid = uuid.toArray(new String[0]);
        }
        VsanInternalSystem.PolicySatisfiability[] costs = vsanSystem.reconfigurationSatisfiable(policyChangeBatch, Boolean.valueOf(batchSpec.ignoreSatisfiability));
        HashMap<String, VsanInternalSystem.PolicySatisfiability> costsMap = new HashMap<String, VsanInternalSystem.PolicySatisfiability>();
        if (costs != null) {
            for (VsanInternalSystem.PolicySatisfiability policySatisfiability : costs) {
                if (policySatisfiability == null || policySatisfiability.uuid == null) continue;
                costsMap.put(policySatisfiability.uuid, policySatisfiability);
            }
        }
        ArrayList<VsanReconfigureCostData> arrayList = new ArrayList<VsanReconfigureCostData>();
        VsanCalculateReconfigureCostSpec[] arr$ = specs;
        int len$ = arr$.length;
        boolean bl = false;
        while (var11_24 < len$) {
            VsanReconfigureCostData costData;
            VsanCalculateReconfigureCostSpec spec = arr$[var11_24];
            if (spec.vmPaths != null) {
                for (String vmPath : spec.vmPaths) {
                    costData = new VsanReconfigureCostData();
                    costData.vmPath = vmPath;
                    String vmHomeUuid = SpbmWhatIfPropertyProvider.getVmHomeVsanUuid(vmPath);
                    if (vmHomeUuid != null && costsMap.containsKey(vmHomeUuid)) {
                        costData.cost = costsMap.get(vmHomeUuid);
                    }
                    arrayList.add(costData);
                }
            }
            if (spec.diskVsanUuids != null) {
                for (String diskUuid : spec.diskVsanUuids) {
                    costData = new VsanReconfigureCostData();
                    costData.diskVsanUuid = diskUuid;
                    if (costsMap.containsKey(diskUuid)) {
                        costData.cost = costsMap.get(diskUuid);
                    }
                    arrayList.add(costData);
                }
            }
            ++var11_24;
        }
        return arrayList.toArray(new VsanReconfigureCostData[0]);
    }

    private static String getVmHomeVsanUuid(String vmFilePath) {
        if (vmFilePath == null) {
            return null;
        }
        int startIndex = vmFilePath.indexOf(93);
        int endIndex = vmFilePath.indexOf(47);
        if (startIndex >= 0 && endIndex > startIndex) {
            return vmFilePath.substring(startIndex + 1, endIndex).trim();
        }
        return null;
    }

    private static VsanInternalSystem getHostVsanInternalSystem(DataService dataService, ManagedObjectReference hostRef) throws Exception {
        ManagedObjectReference vsanInternalSystemRef = (ManagedObjectReference)QueryUtil.getProperty((DataService)dataService, (Object)hostRef, (String)HOST_VSAN_INTERNAL_SYSTEM);
        if (vsanInternalSystemRef == null) {
            _logger.error((Object)"getHostVsanInternalSystem: failed to retrieve VsanInternalSystem.");
            return null;
        }
        return (VsanInternalSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vsanInternalSystemRef);
    }

    private class VmData {
        public ManagedObjectReference vmRef;
        public String vmPath;
        public VirtualDisk[] virtualDisks;
        public VmStorageProfileAssignmentsData profileAssignments;
        public boolean profileMismatch;
        public ManagedObjectReference[] vmDatastores;

        private VmData() {
        }

        public String getVmPathDatastoreName() {
            if (this.vmPath == null || !this.vmPath.startsWith("[")) {
                return null;
            }
            int endIndex = this.vmPath.indexOf("]");
            if (endIndex > 0) {
                return this.vmPath.substring(1, endIndex).trim();
            }
            return null;
        }
    }
}

