/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.spbm.impl;

import com.vmware.vim.binding.pbm.compliance.ComplianceResult;
import com.vmware.vim.binding.pbm.compliance.RollupComplianceResult;
import com.vmware.vim.binding.pbm.profile.Profile;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vsphere.client.common.spbm.data.VirtualDiskStorageProfileAssignmentData;
import com.vmware.vsphere.client.common.spbm.data.VmStorageProfileAssignmentsData;
import com.vmware.vsphere.client.spbm.PbmService;
import com.vmware.vsphere.client.spbm.PbmServiceFactory;
import com.vmware.vsphere.client.spbm.impl.PbmServiceUnableToConnectException;
import com.vmware.vsphere.client.spbm.util.ManagedUtil;
import com.vmware.vsphere.client.spbm.util.PbmSessionUtil;
import com.vmware.vsphere.client.spbm.util.PbmUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmProfileAssignmentPropertyProviderAdapter
implements PropertyProviderAdapter {
    private static final Log _logger = LogFactory.getLog(VmProfileAssignmentPropertyProviderAdapter.class);
    private static final String VM_STORAGE_PROFILE_ASSIGNMENTS = "vmStorageProfileAssignments";
    private static final String VM_SPBM_PROFILE_MISMATCH = "vmSpbmProfileMismatch";
    private static final String VM_COMPL_STATUS_EX = "pbmStorageComplStatusEx";
    private static final String VM_COMPL_STATUS_LABEL = "pbmStorageComplStatusLabel";
    private static final String OUT_OF_DATE_STATUS = "outOfDate";
    private final PbmServiceFactory _pbmServiceFactory;

    public VmProfileAssignmentPropertyProviderAdapter(PbmServiceFactory pbmServiceFactory, DataServiceExtensionRegistry registry) {
        this._pbmServiceFactory = pbmServiceFactory;
        registry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo ti = new TypeInfo();
        ti.type = VirtualMachine.class.getSimpleName();
        ti.properties = new String[]{VM_STORAGE_PROFILE_ASSIGNMENTS, VM_SPBM_PROFILE_MISMATCH, VM_COMPL_STATUS_EX, VM_COMPL_STATUS_LABEL};
        return new TypeInfo[]{ti};
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        ArrayList<VmSpbmProperties> vmSpbmProperties;
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyRequest});
        Object[] objects = propertyRequest.objects;
        PropertySpec[] properties = propertyRequest.properties;
        boolean retrieveAssignments = this.containsProperty(properties, VM_STORAGE_PROFILE_ASSIGNMENTS);
        boolean retrieveProfileMismatch = this.containsProperty(properties, VM_SPBM_PROFILE_MISMATCH);
        boolean retrieveComplianceEx = this.containsProperty(properties, VM_COMPL_STATUS_EX);
        boolean retrieveComplianceLabel = this.containsProperty(properties, VM_COMPL_STATUS_LABEL);
        ResultSet resultSet = new ResultSet();
        if (properties == null || !retrieveAssignments && !retrieveProfileMismatch && !retrieveComplianceEx && !retrieveComplianceLabel) {
            resultSet.items = new ResultItem[0];
            return resultSet;
        }
        try {
            vmSpbmProperties = this.getVmSpbmProperties(objects, retrieveAssignments);
        }
        catch (Exception ex) {
            return this.createErrorResult(ex);
        }
        resultSet.items = new ResultItem[vmSpbmProperties.size()];
        for (int i = 0; i < vmSpbmProperties.size(); ++i) {
            resultSet.items[i] = this.newResultItem(vmSpbmProperties.get(i), retrieveAssignments, retrieveProfileMismatch, retrieveComplianceEx, retrieveComplianceLabel);
        }
        return resultSet;
    }

    private ResultItem newResultItem(VmSpbmProperties vmSpbmProperties, boolean populateAssignments, boolean populateProfileMismatch, boolean populateComplianceEx, boolean populateComplianceLabel) {
        ResultItem resultItem = new ResultItem();
        resultItem.resourceObject = vmSpbmProperties.vm;
        ArrayList<PropertyValue> propertyValues = new ArrayList<PropertyValue>();
        if (populateAssignments) {
            propertyValues.add(this.createPropValue(VM_STORAGE_PROFILE_ASSIGNMENTS, vmSpbmProperties.assignments, vmSpbmProperties.vm));
        }
        if (populateProfileMismatch) {
            PropertyValue propertyValue = this.createPropValue(VM_SPBM_PROFILE_MISMATCH, false, vmSpbmProperties.vm);
            if (vmSpbmProperties.rollupComplianceResult != null) {
                propertyValue.value = vmSpbmProperties.rollupComplianceResult.profileMismatch;
            }
            propertyValues.add(propertyValue);
        }
        if (populateComplianceEx) {
            propertyValues.add(this.createPropValue(VM_COMPL_STATUS_EX, vmSpbmProperties.getCopmlianceStatusEx(), vmSpbmProperties.vm));
        }
        if (populateComplianceLabel) {
            String formattedDate;
            String localizedComplStatus = vmSpbmProperties.getLocalizedComplianceStatusEx();
            if (vmSpbmProperties.rollupComplianceResult != null && vmSpbmProperties.rollupComplianceResult.oldestCheckTime != null && (formattedDate = FormatUtil.getDateTimeFormatted((Object)vmSpbmProperties.rollupComplianceResult.oldestCheckTime)) != null && !formattedDate.isEmpty()) {
                localizedComplStatus = PbmUtil.getLocalizedString("complianceStatusAndLastChecked.format", localizedComplStatus, formattedDate);
            }
            propertyValues.add(this.createPropValue(VM_COMPL_STATUS_LABEL, localizedComplStatus, vmSpbmProperties.vm));
        }
        resultItem.properties = propertyValues.toArray(new PropertyValue[propertyValues.size()]);
        return resultItem;
    }

    private boolean containsProperty(PropertySpec[] propertySpecArray, String propertyName) {
        for (PropertySpec propertySpec : propertySpecArray) {
            for (String property : propertySpec.propertyNames) {
                if (!propertyName.equals(property)) continue;
                return true;
            }
        }
        return false;
    }

    private ArrayList<VmSpbmProperties> getVmSpbmProperties(Object[] vms, boolean populateProfileAssignments) throws Exception {
        try {
            ArrayList<VmSpbmProperties> result = new ArrayList<VmSpbmProperties>();
            Map<String, ArrayList<ManagedObjectReference>> vmsByGuid = ManagedUtil.groupMoRefsByVcGuid(vms);
            if (vmsByGuid.size() == 0) {
                return result;
            }
            for (String vcGuid : vmsByGuid.keySet()) {
                PbmService service = PbmSessionUtil.getService(vcGuid, this._pbmServiceFactory);
                ManagedObjectReference[] vmRefs = vmsByGuid.get(vcGuid).toArray(new ManagedObjectReference[0]);
                this.addVmSpbmPropertiesToResults(service, vmRefs, result, populateProfileAssignments);
            }
            return result;
        }
        catch (PbmServiceUnableToConnectException ex) {
            _logger.error((Object)"Failed to retrieve VmStorageRollupComplianceResult: ", (Throwable)ex);
            throw PbmUtil.getMethodFault(ex);
        }
        catch (ExecutionException ex) {
            _logger.error((Object)"Failed to retrieve VmStorageRollupComplianceResult: ", (Throwable)ex);
            throw PbmUtil.getMethodFault(ex);
        }
    }

    private void addVmSpbmPropertiesToResults(PbmService service, ManagedObjectReference[] vmRefs, ArrayList<VmSpbmProperties> result, boolean populateProfileAssignments) throws Exception {
        RollupComplianceResult[] complResults = PbmUtil.getRollupComplianceResult(service, vmRefs);
        Hashtable<String, RollupComplianceResult> complResultsMap = new Hashtable<String, RollupComplianceResult>();
        if (complResults != null) {
            for (RollupComplianceResult complResult : complResults) {
                if (complResult.entity == null) continue;
                complResultsMap.put(complResult.entity.getKey(), complResult);
            }
        }
        Map<String, Profile> profilesMap = null;
        if (populateProfileAssignments) {
            profilesMap = PbmUtil.getProfilesFromRollupComplianceResult(service, complResults);
        }
        for (ManagedObjectReference vm : vmRefs) {
            VmStorageProfileAssignmentsData vmAssignmentsData = new VmStorageProfileAssignmentsData();
            vmAssignmentsData.vm = vm;
            RollupComplianceResult rollupComplianceResult = (RollupComplianceResult)complResultsMap.get(vm.getValue());
            if (populateProfileAssignments) {
                this.populateVmStorageProfileAssignments(profilesMap, rollupComplianceResult, vmAssignmentsData);
            }
            result.add(new VmSpbmProperties(vm, vmAssignmentsData, rollupComplianceResult));
        }
    }

    private void populateVmStorageProfileAssignments(Map<String, Profile> profilesMap, RollupComplianceResult rollupComplianceResult, VmStorageProfileAssignmentsData profileAssignmentsData) throws Exception {
        if (rollupComplianceResult == null || rollupComplianceResult.result == null) {
            profileAssignmentsData.diskAssignments = new VirtualDiskStorageProfileAssignmentData[0];
            return;
        }
        ArrayList<VirtualDiskStorageProfileAssignmentData> diskAssignments = new ArrayList<VirtualDiskStorageProfileAssignmentData>();
        for (ComplianceResult complianceResult : rollupComplianceResult.result) {
            if (complianceResult.profile == null) continue;
            if (ManagedUtil.isVirtualDisk(complianceResult.entity)) {
                VirtualDiskStorageProfileAssignmentData diskAssignment = new VirtualDiskStorageProfileAssignmentData();
                diskAssignment.diskId = complianceResult.entity.key;
                diskAssignment.profile = profilesMap.get(complianceResult.profile.uniqueId);
                diskAssignment.complianceResult = complianceResult;
                diskAssignments.add(diskAssignment);
                continue;
            }
            if (ManagedUtil.isVmHome(complianceResult.entity)) {
                profileAssignmentsData.homeStorageProfile = profilesMap.get(complianceResult.profile.uniqueId);
                profileAssignmentsData.homeComplianceResult = complianceResult;
                continue;
            }
            _logger.error((Object)("Unsupported ObjectType in RollupComplianceResult: " + complianceResult.entity.objectType));
        }
        profileAssignmentsData.diskAssignments = diskAssignments.toArray(new VirtualDiskStorageProfileAssignmentData[0]);
    }

    private ResultSet createErrorResult(Exception fault) {
        ResultSet resultSet = new ResultSet();
        resultSet.error = fault;
        return resultSet;
    }

    private PropertyValue createPropValue(String name, Object value, Object provider) {
        PropertyValue propValue = new PropertyValue();
        propValue.propertyName = name;
        propValue.value = value;
        propValue.resourceObject = provider;
        return propValue;
    }

    private class VmSpbmProperties {
        public VmStorageProfileAssignmentsData assignments;
        public RollupComplianceResult rollupComplianceResult;
        public ManagedObjectReference vm;

        public VmSpbmProperties(ManagedObjectReference vm, VmStorageProfileAssignmentsData vmAssignment, RollupComplianceResult rollupComplianceResult) {
            this.vm = vm;
            this.rollupComplianceResult = rollupComplianceResult;
            this.assignments = vmAssignment;
        }

        public String getCopmlianceStatusEx() {
            if (this.rollupComplianceResult == null) {
                return null;
            }
            if (this.rollupComplianceResult.profileMismatch) {
                return VmProfileAssignmentPropertyProviderAdapter.OUT_OF_DATE_STATUS;
            }
            return this.rollupComplianceResult.overallComplianceStatus;
        }

        public String getLocalizedComplianceStatusEx() {
            String complStatusEx = this.getCopmlianceStatusEx();
            if (complStatusEx != null && !complStatusEx.isEmpty()) {
                return PbmUtil.getLocalizedString("complianceStatus." + complStatusEx, new String[0]);
            }
            return PbmUtil.getLocalizedString("complianceStatus.none", new String[0]);
        }
    }
}

