/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.spbm.util;

import com.vmware.vim.binding.pbm.ExtendedElementDescription;
import com.vmware.vim.binding.pbm.capability.CapabilityMetadata;
import com.vmware.vim.binding.pbm.capability.PropertyMetadata;
import com.vmware.vim.binding.pbm.compliance.ComplianceResult;
import com.vmware.vim.binding.pbm.compliance.RollupComplianceResult;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.spbm.data.NamespaceCapabilityMetadata;

public class PbmLocalizationUtil {
    private static final String LABEL = "label";
    private static final String SUMMARY = "summary";

    public static void localizeNamespaceCapabilityMetadata(NamespaceCapabilityMetadata[] metadata, VcService vcService) {
        if (!ArrayUtil.isNullOrEmpty((Object[])metadata)) {
            for (int i = 0; i < metadata.length; ++i) {
                PbmLocalizationUtil.localizeNamespaceCapabilityMetadata(metadata[i], vcService);
            }
        }
    }

    public static void localizeNamespaceCapabilityMetadata(NamespaceCapabilityMetadata metadata, VcService vcService) {
        if (metadata == null) {
            return;
        }
        if (metadata.vendorInfo != null) {
            PbmLocalizationUtil.localizeExtendedElementDescription(metadata.vendorInfo.info);
        }
        if (metadata.namespaceInfo != null) {
            PbmLocalizationUtil.localizeExtendedElementDescription(metadata.namespaceInfo.info);
        }
        if (!ArrayUtil.isNullOrEmpty((Object[])metadata.capabilityMetadata)) {
            for (int i = 0; i < metadata.capabilityMetadata.length; ++i) {
                PbmLocalizationUtil.localizeCapabilityMetadata(metadata.capabilityMetadata[i], vcService);
            }
        }
    }

    public static void localizeCapabilityMetadata(CapabilityMetadata capabilityMetadata, VcService vcService) {
        if (capabilityMetadata == null) {
            return;
        }
        PbmLocalizationUtil.localizeExtendedElementDescription(capabilityMetadata.summary);
        if (!ArrayUtil.isNullOrEmpty((Object[])capabilityMetadata.propertyMetadata)) {
            for (int i = 0; i < capabilityMetadata.propertyMetadata.length; ++i) {
                PbmLocalizationUtil.localizePropertyMetdata(capabilityMetadata.propertyMetadata[i], vcService);
            }
        }
    }

    public static void localizePropertyMetdata(PropertyMetadata propertyMetadata, VcService vcService) {
        if (propertyMetadata == null) {
            return;
        }
        PbmLocalizationUtil.localizeExtendedElementDescription(propertyMetadata.summary);
    }

    public static void localizeRollupComplianceResult(RollupComplianceResult rollupComplianceResult) {
        if (rollupComplianceResult == null || rollupComplianceResult.result == null) {
            return;
        }
        PbmLocalizationUtil.localizeComplianceResults(rollupComplianceResult.result);
    }

    public static void localizeComplianceResults(ComplianceResult[] results) {
        if (results == null) {
            return;
        }
        for (ComplianceResult cr : results) {
            PbmLocalizationUtil.localizeComplianceResult(cr);
        }
    }

    public static void localizeComplianceResult(ComplianceResult complianceResult) {
        if (complianceResult == null) {
            return;
        }
        PbmLocalizationUtil.localizeExtendedElementDescription(complianceResult.info, true);
    }

    public static void localizeExtendedElementDescription(ExtendedElementDescription description) {
        PbmLocalizationUtil.localizeExtendedElementDescription(description, false);
    }

    public static void localizeExtendedElementDescription(ExtendedElementDescription description, boolean omitSummaryIfMissing) {
        String summaryKey;
        String descriptionSummary;
        String descriptionLabel;
        if (description == null) {
            return;
        }
        String prefix = description.messageCatalogKeyPrefix;
        if (prefix == null || prefix.length() == 0) {
            return;
        }
        if (!prefix.endsWith(".")) {
            prefix = prefix.concat(".");
        }
        if ((descriptionLabel = LocalizationUtil.getLocalizedMessage((String)(prefix + LABEL), (KeyAnyValue[])description.messageArg, (int)-1)) != null) {
            description.label = descriptionLabel;
        }
        if ((descriptionSummary = LocalizationUtil.getLocalizedMessage((String)(summaryKey = prefix + SUMMARY), (KeyAnyValue[])description.messageArg, (int)-1)) != null) {
            if (summaryKey.equals(descriptionSummary) && omitSummaryIfMissing) {
                if (description.summary != null && !description.summary.isEmpty()) {
                    description.summary = descriptionSummary;
                }
            } else {
                description.summary = descriptionSummary;
            }
        }
    }
}

