/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.api;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.SortCriterion;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.Validate;

public final class Query {
    private final List<String> _properties;
    private final List<String> _resourceModels;
    private final Filter _filter;
    private final List<SortCriterion> _sortCriteria;
    private final int _offset;
    private final int _limit;
    private final boolean _withTotalCount;
    private final Object _cursor;
    private final boolean _returnModelKey;

    private Query(List<String> properties, List<String> resourceModels, Filter filter, List<SortCriterion> sortCriteria, int offset, int limit, boolean withTotalCount, Object cursor) {
        if (limit != 0) {
            Validate.notEmpty(properties, (String)"Properties clause is required when the limit is non-zero.");
            if (limit > 0) {
                Validate.isTrue((!CollectionUtils.isEmpty(sortCriteria) || cursor != null ? 1 : 0) != 0, (String)"Either sorting criteria or cursor should be set when limit is used");
            }
        } else {
            Validate.isTrue((boolean)withTotalCount, (String)"The `withTotalCount' flag must be set when the limit is zero.");
            Validate.isTrue((boolean)CollectionUtils.isEmpty(properties), (String)"No properties should be requested when the limit is zero.");
            Validate.isTrue((CollectionUtils.isEmpty(sortCriteria) && cursor == null && offset == 0 ? 1 : 0) != 0, (String)"Sorting, offset or cursor cannot be used when the limit is zero.");
        }
        if (offset > 0) {
            Validate.notEmpty(sortCriteria, (String)"Sorting criteria is required when the offset is positive.");
            Validate.isTrue((cursor == null ? 1 : 0) != 0, (String)"Cannot set offset when using cursor");
        } else if (cursor != null) {
            Validate.isTrue((limit > 0 ? 1 : 0) != 0, (String)"Cannot use cursor with non-positive limit.");
        }
        this._properties = properties != null ? Collections.unmodifiableList(properties) : Collections.emptyList();
        this._returnModelKey = properties.contains("@modelKey");
        this._resourceModels = resourceModels;
        this._sortCriteria = sortCriteria != null ? Collections.unmodifiableList(sortCriteria) : Collections.emptyList();
        this._filter = filter;
        this._offset = offset;
        this._limit = limit;
        this._withTotalCount = withTotalCount;
        this._cursor = cursor;
    }

    public List<String> getProperties() {
        return this._properties;
    }

    public List<String> getResourceModels() {
        return this._resourceModels;
    }

    public boolean getReturnModelKey() {
        return this._returnModelKey;
    }

    public Filter getFilter() {
        return this._filter;
    }

    public List<SortCriterion> getSortCriteria() {
        return this._sortCriteria;
    }

    public int getOffset() {
        return this._offset;
    }

    public int getLimit() {
        return this._limit;
    }

    public boolean getWithTotalCount() {
        return this._withTotalCount;
    }

    public Object getCursor() {
        return this._cursor;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Query)) {
            return false;
        }
        Query other = (Query)obj;
        return this._properties.equals(other._properties) && this._resourceModels.equals(other._resourceModels) && Query.equalFilters(this._filter, other._filter) && this._sortCriteria.equals(other._sortCriteria) && this._offset == other._offset && this._limit == other._limit && this._withTotalCount == other._withTotalCount;
    }

    private static boolean equalFilters(Filter a, Filter b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        return a.equals(b);
    }

    public int hashCode() {
        int hash = 17;
        hash = 31 * hash + this._properties.hashCode();
        hash = 31 * hash + (this._filter != null ? this._filter.hashCode() : 0);
        hash = 31 * hash + this._sortCriteria.hashCode();
        hash = 31 * hash + this._resourceModels.hashCode();
        hash = 31 * hash + this._offset;
        hash = 31 * hash + this._limit;
        hash = 31 * hash + (this._withTotalCount ? 1 : 0);
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(SystemUtils.LINE_SEPARATOR);
        sb.append("Query [" + SystemUtils.LINE_SEPARATOR);
        sb.append("   _properties = " + this._properties);
        sb.append(SystemUtils.LINE_SEPARATOR);
        sb.append("   _resourceModels = " + this._resourceModels);
        sb.append(SystemUtils.LINE_SEPARATOR);
        sb.append("   _filter = " + this._filter);
        sb.append(SystemUtils.LINE_SEPARATOR);
        sb.append("   _sortCriteria = ");
        if (this._sortCriteria.size() <= 1) {
            sb.append("[" + (!this._sortCriteria.isEmpty() ? this._sortCriteria.get(0) : "") + "]");
        } else {
            sb.append("[");
            Iterator<SortCriterion> iterator = this._sortCriteria.iterator();
            while (iterator.hasNext()) {
                sb.append(SystemUtils.LINE_SEPARATOR + "      ");
                sb.append(iterator.next());
                if (!iterator.hasNext()) continue;
                sb.append(",");
            }
            sb.append(SystemUtils.LINE_SEPARATOR + "   ]");
        }
        sb.append(SystemUtils.LINE_SEPARATOR);
        sb.append("   _offset = " + this._offset);
        sb.append(SystemUtils.LINE_SEPARATOR);
        sb.append("   _limit = " + this._limit);
        sb.append(SystemUtils.LINE_SEPARATOR);
        sb.append("   _withTotalCount = " + this._withTotalCount);
        sb.append(SystemUtils.LINE_SEPARATOR);
        sb.append("   _cursor = " + this._cursor);
        sb.append(SystemUtils.LINE_SEPARATOR + "]");
        return sb.toString();
    }

    public static final class Builder {
        private final List<String> _properties;
        private List<String> _resourceModels;
        private Filter _filter;
        private List<SortCriterion> _sortCriteria;
        private int _offset = 0;
        private int _limit = -1;
        private boolean _withTotalCount = false;
        private Object _cursor;

        private Builder(List<String> properties) {
            if (properties == null) {
                properties = Collections.emptyList();
            }
            this._properties = properties;
        }

        public static Builder select(List<String> properties) {
            Builder query = new Builder(properties);
            return query;
        }

        public static Builder select(String ... properties) {
            Builder query = Builder.select(Arrays.asList(properties));
            return query;
        }

        public static Builder copy(Query query) {
            Validate.notNull((Object)query);
            return Builder.copyAndSelect(query, query.getProperties());
        }

        public static Builder copyAndSelect(Query query, List<String> properties) {
            Builder builder = new Builder(properties);
            builder._resourceModels = query.getResourceModels();
            builder._filter = query.getFilter();
            builder._sortCriteria = query.getSortCriteria();
            builder._offset = query.getOffset();
            builder._limit = query.getLimit();
            builder._withTotalCount = query.getWithTotalCount();
            builder._cursor = query.getCursor();
            return builder;
        }

        public Builder from(List<String> resourceModels) {
            Validate.notEmpty(resourceModels, (String)"Resource models clause is required.");
            this._resourceModels = resourceModels;
            return this;
        }

        public Builder from(String ... resourceModels) {
            this.from(Arrays.asList(resourceModels));
            return this;
        }

        public Builder where(Filter filter) {
            this._filter = filter;
            return this;
        }

        public Builder where(PropertyPredicate ... criteria) {
            this._filter = new Filter(Arrays.asList(criteria));
            return this;
        }

        public Builder where(LogicalOperator operator, PropertyPredicate ... criteria) {
            this._filter = new Filter(Arrays.asList(criteria), operator);
            return this;
        }

        public Builder where(LogicalOperator operator, List<PropertyPredicate> criteria) {
            this._filter = new Filter(criteria, operator);
            return this;
        }

        public Builder where(String property, PropertyPredicate.ComparisonOperator operator, Object comparableValue) {
            return this.where(property, operator, comparableValue, false);
        }

        public Builder where(String property, PropertyPredicate.ComparisonOperator operator, Object comparableValue, boolean ignoreCase) {
            PropertyPredicate predicate = new PropertyPredicate(property, operator, comparableValue, ignoreCase);
            return this.where(predicate);
        }

        public Builder orderBy(String property) {
            return this.orderBy(property, SortCriterion.SortDirection.ASCENDING, false);
        }

        public Builder orderBy(String property, SortCriterion.SortDirection sortDirection, boolean ignoreCase) {
            this._sortCriteria = Arrays.asList(new SortCriterion(property, sortDirection, ignoreCase));
            return this;
        }

        public Builder orderBy(List<SortCriterion> sortCriteria) {
            this._sortCriteria = sortCriteria;
            return this;
        }

        public Builder offset(int offset) {
            Validate.isTrue((offset >= 0 ? 1 : 0) != 0);
            this._offset = offset;
            return this;
        }

        public Builder limit(int limit) {
            this._limit = limit;
            return this;
        }

        public Builder withTotalCount(boolean withTotalCount) {
            this._withTotalCount = withTotalCount;
            return this;
        }

        public Builder withCursor(Object cursor) {
            this._cursor = cursor;
            return this;
        }

        public Query build() {
            Query query = new Query(this._properties, this._resourceModels, this._filter, this._sortCriteria, this._offset, this._limit, this._withTotalCount, this._cursor);
            return query;
        }
    }
}

