/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.api;

import com.google.common.util.concurrent.MoreExecutors;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QueryLimitsSpec;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.provider.CursoredQuerySupport;
import com.vmware.cis.data.internal.provider.QueryDecorator;
import com.vmware.cis.data.internal.provider.QueryDispatcher;
import com.vmware.cis.data.internal.provider.QueryLimitsEnforcer;
import com.vmware.cis.data.internal.provider.ext.ExtendedModelConfig;
import com.vmware.cis.data.internal.provider.ext.ExtensionConnectionSupplier;
import com.vmware.cis.data.provider.DataProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang.Validate;

public final class QueryService {
    private final DataProvider _provider;
    private final QueryDecorator _decorator = new CursoredQuerySupport();
    private final QueryLimitsEnforcer _limitsEnforcer;

    private QueryService(DataProvider provider, QueryLimitsEnforcer limitsEnforcer) {
        this._provider = provider;
        this._limitsEnforcer = limitsEnforcer;
    }

    public ResultSet executeQuery(Query query) {
        Validate.notNull((Object)query);
        this._limitsEnforcer.enforceQuerySizeLimits(query);
        ResultSet result = null;
        QueryDecorator.Decorated decorated = this._decorator.decorate(query);
        if (decorated == null) {
            result = this._provider.executeQuery(query);
        } else {
            ResultSet decoratedResult = this._provider.executeQuery(decorated.getQuery());
            result = decorated.getResultSet(decoratedResult);
        }
        this._limitsEnforcer.enforceResultSizeLimits(result);
        return result;
    }

    public QuerySchema getSchema() {
        return this._provider.getSchema();
    }

    public static final class Builder {
        private final Collection<DataProvider> _providers;
        private final boolean _useDispatcher;
        private ExecutorService _executor;
        private Collection<Class<?>> _queryModels;
        private QueryLimitsSpec _queryLimitsSpec;

        private Builder(Collection<DataProvider> providers, boolean useDispatcher) {
            this._providers = providers;
            this._useDispatcher = useDispatcher;
        }

        public static Builder forProvider(DataProvider provider) {
            Validate.notNull((Object)provider);
            return new Builder(Collections.singletonList(provider), false);
        }

        public static Builder forProviders(Collection<DataProvider> providers) {
            Validate.notNull(providers);
            return new Builder(providers, true);
        }

        public Builder withExecutor(ExecutorService executor) {
            this._executor = executor;
            return this;
        }

        public Builder withExtendedModels(Collection<Class<?>> queryModels) {
            this._queryModels = queryModels;
            return this;
        }

        public Builder withQueryLimits(QueryLimitsSpec queryLimitSpec) {
            this._queryLimitsSpec = queryLimitSpec;
            return this;
        }

        public QueryService build() {
            QueryLimitsSpec limitsSpec;
            ExecutorService executor = this._executor;
            if (this._executor == null) {
                executor = MoreExecutors.sameThreadExecutor();
            }
            DataProvider provider = null;
            provider = this._useDispatcher ? QueryDispatcher.createDispatcher(this._providers, executor) : this._providers.iterator().next();
            if (this._queryModels != null) {
                ExtendedModelConfig extendedModel = ExtendedModelConfig.Builder.create().withQueryModels(this._queryModels).withDefaultAggregatedModels(executor).build();
                provider = Builder.extendedProvider(provider, extendedModel);
            }
            if ((limitsSpec = this._queryLimitsSpec) == null) {
                limitsSpec = new QueryLimitsSpec(-1, -1, -1);
            }
            QueryLimitsEnforcer limitsEnforcer = new QueryLimitsEnforcer(limitsSpec);
            return new QueryService(provider, limitsEnforcer);
        }

        private static DataProvider extendedProvider(DataProvider provider, ExtendedModelConfig extendedModel) {
            ExtensionConnectionSupplier extConnectionSupplier = new ExtensionConnectionSupplier(provider, extendedModel.getQueryModels(), extendedModel.getAggregatedModelLookup(), extendedModel.getAggregatedModelExecutor());
            return extConnectionSupplier.getConnection();
        }
    }
}

