/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.api;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.Validate;

public final class ResourceItem {
    private final List<Object> _propertyValues;

    public ResourceItem(List<Object> propertyValues) {
        Validate.notEmpty(propertyValues);
        this._propertyValues = Collections.unmodifiableList(propertyValues);
    }

    public List<Object> getPropertyValues() {
        return this._propertyValues;
    }

    public <T> T get(int propertyIndex) {
        Object value = this._propertyValues.get(propertyIndex);
        return (T)value;
    }

    public int hashCode() {
        return this._propertyValues.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ResourceItem)) {
            return false;
        }
        ResourceItem other = (ResourceItem)obj;
        return this._propertyValues.equals(other.getPropertyValues());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ResourceItem [" + SystemUtils.LINE_SEPARATOR);
        sb.append("         _propertyValues = ");
        if (this._propertyValues.size() == 1) {
            sb.append("[" + ResourceItem.valueToString(this._propertyValues.get(0)) + "]");
        } else {
            sb.append("[");
            Iterator<Object> iterator = this._propertyValues.iterator();
            while (iterator.hasNext()) {
                sb.append(SystemUtils.LINE_SEPARATOR + "            ");
                sb.append(ResourceItem.valueToString(iterator.next()));
                if (!iterator.hasNext()) continue;
                sb.append(",");
            }
            sb.append(SystemUtils.LINE_SEPARATOR + "         ]");
        }
        sb.append(SystemUtils.LINE_SEPARATOR + "      ]");
        return sb.toString();
    }

    private static String valueToString(Object propertyValue) {
        if (propertyValue instanceof Object[]) {
            return Arrays.toString((Object[])propertyValue);
        }
        return String.valueOf(propertyValue);
    }
}

