/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.api;

import com.vmware.cis.data.api.ResourceItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.Validate;

public final class ResultSet {
    private final List<String> _properties;
    private final List<ResourceItem> _items;
    private final Integer _totalCount;
    private final Object _cursor;
    private final int _modelKeyIndex;

    public ResultSet(List<String> properties, List<ResourceItem> items, Integer totalCount, Object cursor) {
        this._properties = properties != null ? Collections.unmodifiableList(properties) : Collections.emptyList();
        this._modelKeyIndex = this._properties.indexOf("@modelKey");
        this._items = items != null ? Collections.unmodifiableList(items) : Collections.emptyList();
        this._totalCount = totalCount;
        this._cursor = cursor;
        for (ResourceItem item : this._items) {
            Validate.isTrue((this._properties.size() == item.getPropertyValues().size() ? 1 : 0) != 0);
        }
        if (this._totalCount != null && this._totalCount < this._items.size()) {
            throw new IllegalArgumentException("The number of total matches is less than the number of returned entities");
        }
    }

    public ResultSet(List<String> properties, List<ResourceItem> items, Integer totalCount) {
        this(properties, items, totalCount, null);
    }

    public ResultSet(List<String> properties, List<ResourceItem> items) {
        this(properties, items, null, null);
    }

    public List<String> getProperties() {
        return this._properties;
    }

    public <T> T getModelKey(ResourceItem item) {
        Validate.notNull((Object)item);
        Validate.isTrue((this._properties.size() == item.getPropertyValues().size() ? 1 : 0) != 0);
        if (this._modelKeyIndex < 0) {
            return null;
        }
        return (T)item.getPropertyValues().get(this._modelKeyIndex);
    }

    public List<ResourceItem> getItems() {
        return this._items;
    }

    public Integer getTotalCount() {
        return this._totalCount;
    }

    public Object getCursor() {
        return this._cursor;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ResultSet)) {
            return false;
        }
        ResultSet other = (ResultSet)obj;
        return this._properties.equals(other._properties) && this._items.equals(other._items) && (this._totalCount == null ? other._totalCount == null : this._totalCount.equals(other._totalCount));
    }

    public int hashCode() {
        int hash = 11;
        hash = 31 * hash + this._properties.hashCode();
        hash = 31 * hash + this._items.hashCode();
        hash = 31 * hash + (this._totalCount != null ? this._totalCount : 0);
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(SystemUtils.LINE_SEPARATOR);
        sb.append("ResultSet [" + SystemUtils.LINE_SEPARATOR);
        sb.append("   _properties = " + this._properties);
        sb.append(SystemUtils.LINE_SEPARATOR);
        sb.append("   _items = ");
        if (this._items.size() <= 1) {
            sb.append("[" + (!this._items.isEmpty() ? this._items.get(0) : "") + "]");
        } else {
            sb.append("[");
            Iterator<ResourceItem> iterator = this._items.iterator();
            while (iterator.hasNext()) {
                sb.append(SystemUtils.LINE_SEPARATOR + "      ");
                sb.append(iterator.next());
                if (!iterator.hasNext()) continue;
                sb.append(",");
            }
            sb.append(SystemUtils.LINE_SEPARATOR + "   ]");
        }
        sb.append(SystemUtils.LINE_SEPARATOR);
        sb.append("   _totalCount = " + this._totalCount);
        sb.append(SystemUtils.LINE_SEPARATOR);
        sb.append("   _cursor = " + this._cursor);
        sb.append(SystemUtils.LINE_SEPARATOR + "]");
        return sb.toString();
    }

    public static final class Builder {
        private final List<String> _properties;
        private final List<ResourceItem> _items;
        private Integer _totalCount = null;

        private Builder(List<String> properties) {
            assert (properties != null);
            this._properties = properties;
            this._items = new ArrayList<ResourceItem>();
        }

        public static Builder properties(List<String> properties) {
            return new Builder(properties);
        }

        public static Builder properties(String ... properties) {
            return Builder.properties(Arrays.asList(properties));
        }

        public Builder item(List<Object> propertyValues) {
            assert (propertyValues != null);
            assert (propertyValues.size() == this._properties.size());
            ResourceItem item = new ResourceItem(propertyValues);
            this._items.add(item);
            return this;
        }

        public Builder item(Object ... propertyValues) {
            return this.item(Arrays.asList(propertyValues));
        }

        public Builder totalCount(Integer totalCount) {
            this._totalCount = totalCount;
            return this;
        }

        public ResultSet build() {
            return new ResultSet(this._properties, this._items, this._totalCount);
        }
    }
}

