/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.api.typed;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.SortCriterion;
import com.vmware.cis.data.internal.provider.typed.TypedQueryModelDescriptor;
import com.vmware.cis.data.internal.provider.typed.TypedQueryModelMapper;
import com.vmware.cis.data.internal.provider.util.QueryQualifier;
import com.vmware.cis.data.provider.DataProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.Validate;

public final class TypedQuery<T> {
    private final TypedQueryModelDescriptor<T> _descriptor;
    private final TypedQueryModelMapper<T> _mapper;
    private final DataProvider _dataProvider;
    private Filter _filter = null;
    private List<SortCriterion> _sortCriteria = Collections.emptyList();

    TypedQuery(TypedQueryModelDescriptor<T> descriptor, DataProvider dataProvider) {
        assert (descriptor != null);
        assert (dataProvider != null);
        this._descriptor = descriptor;
        this._mapper = new TypedQueryModelMapper<T>(descriptor);
        this._dataProvider = dataProvider;
    }

    public TypedQuery<T> where(Filter filter) {
        this._filter = filter;
        return this;
    }

    public TypedQuery<T> where(PropertyPredicate ... criteria) {
        this._filter = new Filter(Arrays.asList(criteria));
        return this;
    }

    public TypedQuery<T> where(LogicalOperator operator, PropertyPredicate ... criteria) {
        this._filter = new Filter(Arrays.asList(criteria), operator);
        return this;
    }

    public TypedQuery<T> where(LogicalOperator operator, List<PropertyPredicate> criteria) {
        this._filter = new Filter(criteria, operator);
        return this;
    }

    public TypedQuery<T> where(String property, PropertyPredicate.ComparisonOperator operator, Object comparableValue) {
        return this.where(property, operator, comparableValue, false);
    }

    public TypedQuery<T> where(String property, PropertyPredicate.ComparisonOperator operator, Object comparableValue, boolean ignoreCase) {
        PropertyPredicate predicate = new PropertyPredicate(property, operator, comparableValue, ignoreCase);
        return this.where(predicate);
    }

    public TypedQuery<T> orderBy(String property) {
        return this.orderBy(property, SortCriterion.SortDirection.ASCENDING, false);
    }

    public TypedQuery<T> orderBy(String property, SortCriterion.SortDirection sortDirection, boolean ignoreCase) {
        SortCriterion criterion = new SortCriterion(property, sortDirection, ignoreCase);
        this.orderBy(Arrays.asList(criterion));
        return this;
    }

    public TypedQuery<T> orderBy(List<SortCriterion> sortCriteria) {
        Validate.notNull(sortCriteria);
        this._sortCriteria = Collections.unmodifiableList(sortCriteria);
        return this;
    }

    public List<T> list() {
        return this.list(-1);
    }

    public List<T> list(int limit) {
        List<String> selectedProperties = this._descriptor.getProperties();
        List<String> resourceModels = QueryQualifier.getFromClause(selectedProperties, this._filter, this._sortCriteria);
        Query query = Query.Builder.select(selectedProperties).from(resourceModels).where(this._filter).orderBy(this._sortCriteria).limit(limit).build();
        ResultSet resultSet = this._dataProvider.executeQuery(query);
        List<T> results = this._mapper.map(resultSet);
        return results;
    }

    public int totalCount() {
        Validate.isTrue((boolean)this._sortCriteria.isEmpty(), (String)"Cannot set sorting criteria when using count.");
        List<String> selectedProperties = this._descriptor.getProperties();
        List<String> resourceModels = QueryQualifier.getFromClause(selectedProperties, this._filter, null);
        Query query = Query.Builder.select(new String[0]).from(resourceModels).where(this._filter).limit(0).withTotalCount(true).build();
        ResultSet resultSet = this._dataProvider.executeQuery(query);
        return resultSet.getTotalCount();
    }

    public CountedResult<T> listWithTotalCount(int limit) {
        Validate.isTrue((limit > 0 ? 1 : 0) != 0);
        List<String> selectedProperties = this._descriptor.getProperties();
        List<String> resourceModels = QueryQualifier.getFromClause(selectedProperties, this._filter, this._sortCriteria);
        Query query = Query.Builder.select(selectedProperties).from(resourceModels).where(this._filter).orderBy(this._sortCriteria).limit(limit).withTotalCount(true).build();
        ResultSet resultSet = this._dataProvider.executeQuery(query);
        List<T> results = this._mapper.map(resultSet);
        return new CountedResult(results, resultSet.getTotalCount());
    }

    public static class CountedResult<T> {
        private final List<T> _items;
        private final int _totalCount;

        private CountedResult(List<T> items, int totalCount) {
            assert (items != null);
            this._items = items;
            this._totalCount = totalCount;
        }

        public List<T> getItems() {
            return this._items;
        }

        public int getTotalCount() {
            return this._totalCount;
        }
    }
}

