/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.api.typed;

import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.typed.TypedQuery;
import com.vmware.cis.data.internal.provider.ext.ConnectionSupplier;
import com.vmware.cis.data.internal.provider.ext.alias.AliasPropertyDescriptor;
import com.vmware.cis.data.internal.provider.ext.alias.AliasPropertyProviderConnection;
import com.vmware.cis.data.internal.provider.ext.alias.AliasPropertyRepository;
import com.vmware.cis.data.internal.provider.ext.relationship.RelatedLengthProviderConnection;
import com.vmware.cis.data.internal.provider.ext.relationship.RelatedPropertyDescriptor;
import com.vmware.cis.data.internal.provider.ext.relationship.RelatedPropertyProviderConnection;
import com.vmware.cis.data.internal.provider.ext.relationship.RelatedPropertyRepository;
import com.vmware.cis.data.internal.provider.typed.TypedQueryModelDescriptor;
import com.vmware.cis.data.provider.DataProvider;
import java.util.Map;
import org.apache.commons.lang.Validate;

public final class TypedQueryFactory {
    private final QueryService _queryService;

    public TypedQueryFactory(QueryService queryService) {
        Validate.notNull((Object)queryService);
        this._queryService = queryService;
    }

    public <T> TypedQuery<T> selectFrom(Class<T> resultType) {
        Validate.notNull(resultType);
        TypedQueryModelDescriptor<T> descriptor = new TypedQueryModelDescriptor<T>(resultType);
        ExtensionConnectionSupplier<T> supplier = new ExtensionConnectionSupplier<T>(this.toDataProvider(this._queryService), descriptor);
        DataProvider dataProvider = supplier.getConnection();
        return new TypedQuery<T>(descriptor, dataProvider);
    }

    private DataProvider toDataProvider(final QueryService queryService) {
        return new DataProvider(){

            @Override
            public QuerySchema getSchema() {
                return queryService.getSchema();
            }

            @Override
            public ResultSet executeQuery(Query query) {
                return queryService.executeQuery(query);
            }
        };
    }

    private static final class ExtensionConnectionSupplier<T>
    implements ConnectionSupplier {
        private final DataProvider _dataProvider;

        public ExtensionConnectionSupplier(DataProvider dataProvider, TypedQueryModelDescriptor<T> descriptor) {
            assert (dataProvider != null);
            assert (descriptor != null);
            this._dataProvider = this.aliasProvider(this.relatedProvider(dataProvider, this, descriptor.getRelatedDescriptorByRelatedProperty()), descriptor.getAliasDescriptorByAliasProperty());
        }

        @Override
        public DataProvider getConnection() {
            return this._dataProvider;
        }

        private DataProvider aliasProvider(DataProvider dataProvider, Map<String, AliasPropertyDescriptor> descriptorByAliasProperty) {
            return new AliasPropertyProviderConnection(dataProvider, new AliasPropertyRepository(descriptorByAliasProperty));
        }

        private DataProvider relatedProvider(DataProvider dataProvider, ConnectionSupplier supplier, Map<String, RelatedPropertyDescriptor> descriptorByRelatedProperty) {
            RelatedPropertyRepository repository = new RelatedPropertyRepository(descriptorByRelatedProperty);
            RelatedPropertyProviderConnection relatedDataProvider = new RelatedPropertyProviderConnection(dataProvider, supplier, repository);
            RelatedLengthProviderConnection relatedLengthDataProvider = new RelatedLengthProviderConnection(relatedDataProvider, repository);
            return relatedLengthDataProvider;
        }
    }
}

