/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.SortCriterion;
import com.vmware.cis.data.internal.provider.QueryDecorator;
import com.vmware.cis.data.internal.provider.util.ResultSetUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.Validate;

public final class CursoredQuerySupport
implements QueryDecorator {
    private static final String INITITAL_CURSOR = "";
    private static List<SortCriterion> CURSOR_SORT_CRITERIA = Arrays.asList(new SortCriterion("@modelKey"));

    @Override
    public QueryDecorator.Decorated decorate(final Query query) {
        Validate.notNull((Object)query);
        if (query.getCursor() == null) {
            return null;
        }
        assert (query.getLimit() > 0);
        Validate.isTrue((query.getFilter() == null ? 1 : 0) != 0, (String)"Cannot set filter when using cursor.");
        Validate.isTrue((boolean)query.getSortCriteria().isEmpty(), (String)"Cannot set sorting criteria when using cursor.");
        Query.Builder queryBuilder = this.toQueryWithModelKey(query);
        final Query cursoredQuery = queryBuilder.where(this.getCursoredFilter(query)).orderBy(CURSOR_SORT_CRITERIA).limit(query.getLimit()).build();
        return new QueryDecorator.Decorated(){

            @Override
            public Query getQuery() {
                return cursoredQuery;
            }

            @Override
            public ResultSet getResultSet(ResultSet decoratedQueryResult) {
                Validate.notNull((Object)decoratedQueryResult);
                ResultSet cursoredResult = CursoredQuerySupport.this.toCursoredResult(cursoredQuery, decoratedQueryResult);
                if (query.getReturnModelKey()) {
                    return cursoredResult;
                }
                return ResultSetUtil.removePropertyFromResultSet(cursoredResult, "@modelKey");
            }
        };
    }

    private Query.Builder toQueryWithModelKey(Query query) {
        if (query.getReturnModelKey()) {
            return Query.Builder.copy(query);
        }
        ArrayList<String> selectedProperties = new ArrayList<String>(query.getProperties());
        selectedProperties.add("@modelKey");
        return Query.Builder.copyAndSelect(query, selectedProperties);
    }

    private Filter getCursoredFilter(Query query) {
        if (query.getCursor().equals(INITITAL_CURSOR)) {
            return null;
        }
        PropertyPredicate cursorPredicate = new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.GREATER, query.getCursor());
        return new Filter(Arrays.asList(cursorPredicate));
    }

    private ResultSet toCursoredResult(Query query, ResultSet resultSet) {
        List<ResourceItem> items = resultSet.getItems();
        if (items.isEmpty() || items.size() < query.getLimit()) {
            return resultSet;
        }
        assert (items.size() == query.getLimit());
        ResourceItem lastItem = items.get(items.size() - 1);
        Object cursor = resultSet.getModelKey(lastItem);
        return new ResultSet(resultSet.getProperties(), resultSet.getItems(), resultSet.getTotalCount(), cursor);
    }
}

