/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider;

import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.provider.PropertyRetriever;
import com.vmware.cis.data.internal.provider.ProviderBySchemaLookup;
import com.vmware.cis.data.internal.provider.ProviderRepository;
import com.vmware.cis.data.internal.provider.QueryClauseAnalyzer;
import com.vmware.cis.data.internal.provider.QueryExecutor;
import com.vmware.cis.data.internal.provider.QueryQualifyingConnection;
import com.vmware.cis.data.internal.provider.join.DistributedJoinProviderConnection;
import com.vmware.cis.data.internal.provider.profiler.ProfiledDataProvider;
import com.vmware.cis.data.provider.DataProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang.Validate;

public final class QueryDispatcher
implements DataProvider {
    private final ProviderBySchemaLookup _providerLookup;
    private final QueryClauseAnalyzer _clauseAnalyzer;
    private final QueryExecutor _queryExecutor;
    private final PropertyRetriever _propertyRetriever;

    public static DataProvider createDispatcher(Collection<DataProvider> providers, ExecutorService executor) {
        Validate.notNull(providers);
        Validate.notNull((Object)executor);
        ProviderBySchemaLookup lookup = ProviderRepository.forProviders(providers);
        return new QueryQualifyingConnection(ProfiledDataProvider.create(new QueryDispatcher(lookup, executor)));
    }

    private QueryDispatcher(ProviderBySchemaLookup providerLookup, ExecutorService executor) {
        assert (providerLookup != null);
        assert (executor != null);
        this._providerLookup = providerLookup;
        this._clauseAnalyzer = new QueryClauseAnalyzer(this._providerLookup);
        this._queryExecutor = new QueryExecutor(executor);
        this._propertyRetriever = new PropertyRetriever(this._clauseAnalyzer, this._queryExecutor);
    }

    @Override
    public ResultSet executeQuery(Query query) {
        Validate.notNull((Object)query);
        Query initialQuery = query;
        DataProvider provider = this._clauseAnalyzer.getQueryProvider(query);
        if (provider == null) {
            provider = DistributedJoinProviderConnection.createDistributedJoin(this._providerLookup, this._queryExecutor);
        } else {
            List<String> properties = this.getPropertiesForProvider(query.getProperties(), provider);
            if (!query.getProperties().equals(properties)) {
                if (!properties.contains("@modelKey")) {
                    properties.add("@modelKey");
                }
                initialQuery = Query.Builder.copyAndSelect(query, properties).build();
            }
        }
        ResultSet initialResult = this._queryExecutor.executeQuery(provider, initialQuery);
        assert (initialResult != null);
        ResultSet finalResult = this._propertyRetriever.gatherRemainingProperties(query, initialResult);
        Integer totalCount = null;
        if (query.getWithTotalCount()) {
            totalCount = initialResult.getTotalCount();
        }
        return new ResultSet(finalResult.getProperties(), finalResult.getItems(), totalCount);
    }

    @Override
    public QuerySchema getSchema() {
        return this._providerLookup.getSchema();
    }

    private List<String> getPropertiesForProvider(Collection<String> properties, DataProvider provider) {
        assert (properties != null);
        assert (provider != null);
        ArrayList<String> providerProperties = new ArrayList<String>();
        for (String property : properties) {
            DataProvider propertyProvider = QueryClauseAnalyzer.isSpecialProperty(property) ? provider : this._providerLookup.getProviderForProperty(property);
            if (provider != propertyProvider) continue;
            providerProperties.add(property);
        }
        return providerProperties;
    }
}

