/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider;

import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.provider.util.QueryQualifier;
import com.vmware.cis.data.provider.DataProvider;
import org.apache.commons.lang.Validate;

public final class QueryQualifyingConnection
implements DataProvider {
    private final DataProvider _connection;
    private final QueryQualifier _queryQualifier;

    public QueryQualifyingConnection(DataProvider connection) {
        assert (connection != null);
        this._connection = connection;
        this._queryQualifier = new QueryQualifier(this._connection.getSchema());
    }

    @Override
    public ResultSet executeQuery(Query query) {
        Validate.notNull((Object)query);
        QueryQualifier.QualifierContext qualifierContext = this._queryQualifier.qualifyQuery(query);
        Query qualifiedQuery = qualifierContext.getQualifiedQuery();
        ResultSet result = this._connection.executeQuery(qualifiedQuery);
        assert (result != null);
        return this._queryQualifier.unqualifyResultSet(result, qualifierContext);
    }

    @Override
    public QuerySchema getSchema() {
        return this._connection.getSchema();
    }
}

