/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider.ext;

import com.vmware.cis.data.internal.provider.ext.aggregated.AggregatedModelLookup;
import com.vmware.cis.data.internal.provider.ext.aggregated.DefaultAggregatedModels;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang.Validate;

public final class ExtendedModelConfig {
    private final Collection<Class<?>> _queryModels;
    private final AggregatedModelLookup _aggregatedModelLookup;
    private final ExecutorService _aggregatedModelExecutor;

    private ExtendedModelConfig(Collection<Class<?>> queryModels, AggregatedModelLookup aggregatedModelLookup, ExecutorService aggregatedModelExecutor) {
        this._queryModels = queryModels;
        this._aggregatedModelLookup = aggregatedModelLookup;
        this._aggregatedModelExecutor = aggregatedModelExecutor;
    }

    public Collection<Class<?>> getQueryModels() {
        return this._queryModels;
    }

    public AggregatedModelLookup getAggregatedModelLookup() {
        return this._aggregatedModelLookup;
    }

    public ExecutorService getAggregatedModelExecutor() {
        return this._aggregatedModelExecutor;
    }

    public static final class Builder {
        private Collection<Class<?>> _queryModels;
        private AggregatedModelLookup _aggregatedModelLookup;
        private ExecutorService _aggregatedModelExecutor;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder withQueryModels(Collection<Class<?>> queryModels) {
            Validate.notNull(queryModels, (String)"QueryModels are null");
            this._queryModels = queryModels;
            return this;
        }

        public Builder withDefaultAggregatedModels(ExecutorService executor) {
            Validate.notNull((Object)executor, (String)"ExecutorService is null");
            this._aggregatedModelLookup = DefaultAggregatedModels.getModelLookup();
            assert (this._aggregatedModelLookup != null);
            this._aggregatedModelExecutor = executor;
            return this;
        }

        public ExtendedModelConfig build() {
            return new ExtendedModelConfig(this._queryModels, this._aggregatedModelLookup, this._aggregatedModelExecutor);
        }
    }
}

