/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider.ext;

import com.vmware.cis.data.internal.provider.QueryQualifyingConnection;
import com.vmware.cis.data.internal.provider.ext.ConnectionSupplier;
import com.vmware.cis.data.internal.provider.ext.aggregated.AggregatedModelLookup;
import com.vmware.cis.data.internal.provider.ext.aggregated.AggregatedModelProviderConnection;
import com.vmware.cis.data.internal.provider.ext.aggregated.AggregatedSchemaProviderConnection;
import com.vmware.cis.data.internal.provider.ext.alias.AliasPropertyProviderConnection;
import com.vmware.cis.data.internal.provider.ext.alias.AliasPropertyRepository;
import com.vmware.cis.data.internal.provider.ext.derived.DerivedPropertyProviderConnection;
import com.vmware.cis.data.internal.provider.ext.derived.DerivedPropertyRepository;
import com.vmware.cis.data.internal.provider.ext.predicate.PredicatePropertyProviderConnection;
import com.vmware.cis.data.internal.provider.ext.predicate.PredicatePropertyRepository;
import com.vmware.cis.data.internal.provider.ext.relationship.RelatedLengthProviderConnection;
import com.vmware.cis.data.internal.provider.ext.relationship.RelatedPropertyProviderConnection;
import com.vmware.cis.data.internal.provider.ext.relationship.RelatedPropertyRepository;
import com.vmware.cis.data.internal.provider.profiler.ProfiledDataProvider;
import com.vmware.cis.data.provider.DataProvider;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang.Validate;

public final class ExtensionConnectionSupplier
implements ConnectionSupplier {
    private final DataProvider _extConnection;

    public ExtensionConnectionSupplier(DataProvider connection, Collection<Class<?>> queryModels, AggregatedModelLookup aggregatedModelLookup, ExecutorService aggregatedModelExecutor) {
        Validate.notNull((Object)connection);
        this._extConnection = ExtensionConnectionSupplier.buildExtConnection(connection, this, queryModels, aggregatedModelLookup, aggregatedModelExecutor);
    }

    @Override
    public DataProvider getConnection() {
        return this._extConnection;
    }

    private static DataProvider buildExtConnection(DataProvider connection, ConnectionSupplier extConnectionSupplier, Collection<Class<?>> queryModels, AggregatedModelLookup aggregatedModelLookup, ExecutorService aggregatedModelExecutor) {
        return ExtensionConnectionSupplier.qualifyConnection(ExtensionConnectionSupplier.aggregatedConnection(ExtensionConnectionSupplier.predicateConnection(ExtensionConnectionSupplier.derivedConnection(ExtensionConnectionSupplier.aliasConnection(ExtensionConnectionSupplier.relatedConnection(ExtensionConnectionSupplier.aggregatedSchemaConnection(connection, aggregatedModelLookup), extConnectionSupplier, queryModels), queryModels), queryModels), queryModels), aggregatedModelLookup, aggregatedModelExecutor));
    }

    private static DataProvider aliasConnection(DataProvider conn, Collection<Class<?>> queryModels) {
        if (queryModels == null) {
            return conn;
        }
        return ExtensionConnectionSupplier.profileProvider(new AliasPropertyProviderConnection(conn, new AliasPropertyRepository(queryModels)));
    }

    private static DataProvider relatedConnection(DataProvider conn, ConnectionSupplier connSupplier, Collection<Class<?>> queryModels) {
        if (queryModels == null) {
            return conn;
        }
        RelatedPropertyRepository repository = new RelatedPropertyRepository(queryModels);
        RelatedPropertyProviderConnection relatedConnection = new RelatedPropertyProviderConnection(conn, connSupplier, repository);
        RelatedLengthProviderConnection relatedLengthConnection = new RelatedLengthProviderConnection(relatedConnection, repository);
        return ExtensionConnectionSupplier.profileProvider(relatedLengthConnection);
    }

    private static DataProvider derivedConnection(DataProvider conn, Collection<Class<?>> queryModels) {
        if (queryModels == null) {
            return conn;
        }
        return ExtensionConnectionSupplier.profileProvider(new DerivedPropertyProviderConnection(conn, new DerivedPropertyRepository(queryModels)));
    }

    private static DataProvider predicateConnection(DataProvider conn, Collection<Class<?>> queryModels) {
        if (queryModels == null) {
            return conn;
        }
        return ExtensionConnectionSupplier.profileProvider(new PredicatePropertyProviderConnection(conn, new PredicatePropertyRepository(queryModels)));
    }

    private static DataProvider aggregatedConnection(DataProvider conn, AggregatedModelLookup aggregatedModelLookup, ExecutorService aggregatedModelExecutor) {
        if (aggregatedModelLookup == null || aggregatedModelExecutor == null) {
            return conn;
        }
        return ExtensionConnectionSupplier.profileProvider(new AggregatedModelProviderConnection(conn, aggregatedModelLookup, aggregatedModelExecutor));
    }

    private static DataProvider aggregatedSchemaConnection(DataProvider conn, AggregatedModelLookup aggregatedModelLookup) {
        if (aggregatedModelLookup == null) {
            return conn;
        }
        return new AggregatedSchemaProviderConnection(conn, aggregatedModelLookup);
    }

    private static DataProvider profileProvider(DataProvider dataProvider) {
        return ProfiledDataProvider.create(dataProvider);
    }

    private static DataProvider qualifyConnection(DataProvider conn) {
        return new QueryQualifyingConnection(conn);
    }
}

