/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider.ext.aggregated;

import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.SortCriterion;
import com.vmware.cis.data.internal.provider.ext.aggregated.AggregatedModelLookup;
import com.vmware.cis.data.internal.provider.ext.aggregated.AggregatedModelQueryConverter;
import com.vmware.cis.data.internal.provider.ext.aggregated.AggregatedModelQueryExecutor;
import com.vmware.cis.data.internal.provider.ext.aggregated.AggregatedModelResultConverter;
import com.vmware.cis.data.internal.provider.ext.aggregated.AggregatedModelSchema;
import com.vmware.cis.data.internal.provider.merge.DefaultItemComparator;
import com.vmware.cis.data.internal.provider.merge.OrderedSequenceMergePolicy;
import com.vmware.cis.data.internal.provider.merge.ResultMergePolicy;
import com.vmware.cis.data.internal.provider.merge.SequenceMergePolicy;
import com.vmware.cis.data.internal.provider.merge.UnorderedSequenceMergePolicy;
import com.vmware.cis.data.provider.DataProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AggregatedModelProviderConnection
implements DataProvider {
    private static final Logger _logger = LoggerFactory.getLogger(AggregatedModelProviderConnection.class);
    private final DataProvider _connection;
    private final QuerySchema _schema;
    private final AggregatedModelLookup _aggregatedModelLookup;
    private final AggregatedModelQueryExecutor _queryExecutor;

    public AggregatedModelProviderConnection(DataProvider connection, AggregatedModelLookup aggregatedModelLookup, ExecutorService executor) {
        assert (connection != null);
        assert (aggregatedModelLookup != null);
        assert (executor != null);
        this._connection = connection;
        this._schema = connection.getSchema();
        this._aggregatedModelLookup = aggregatedModelLookup;
        this._queryExecutor = new AggregatedModelQueryExecutor(connection, executor);
    }

    @Override
    public ResultSet executeQuery(Query query) {
        Validate.notNull((Object)query, (String)"Query is null");
        Set<String> aggregatedModels = this.getAggregatedModels(query.getResourceModels());
        if (aggregatedModels.isEmpty()) {
            _logger.trace("Skipping query because it has no aggregated models: {}", query.getResourceModels());
            return this._connection.executeQuery(query);
        }
        this.validateAtMostOneAggregatedModel(aggregatedModels);
        String aggregatedModel = aggregatedModels.iterator().next();
        Set<String> childModels = this.getChildModels(aggregatedModel);
        this.validateAggregatedIsTheOnlyModel(query.getResourceModels(), aggregatedModel);
        _logger.debug("Query for aggregated model '{}' with child models '{}'", (Object)aggregatedModel, childModels);
        _logger.trace("Query for aggregated model '{}': {}", (Object)aggregatedModel, (Object)query);
        this.validateSelectContainsEverySortProperty(query);
        ArrayList<String> orderedChildModels = new ArrayList<String>(childModels);
        List<Query> childQueries = this.createChildQueries(query, aggregatedModel, orderedChildModels);
        List<ResultSet> childResults = this._queryExecutor.executeQueries(childQueries);
        List<ResultSet> results = this.convertChildResults(childResults, orderedChildModels, aggregatedModel, query.getProperties());
        ResultSet result = this.mergeResults(results, query);
        _logger.trace("Result for aggregated model '{}': {}", (Object)aggregatedModel, (Object)result);
        return result;
    }

    @Override
    public QuerySchema getSchema() {
        return AggregatedModelSchema.addAggregatedModels(this._schema, this._aggregatedModelLookup);
    }

    private Set<String> getChildModels(String model) {
        assert (model != null);
        return this._aggregatedModelLookup.getChildrenOfAggregatedModel(model);
    }

    private Set<String> getAggregatedModels(List<String> models) {
        assert (models != null);
        HashSet<String> aggregatedModels = new HashSet<String>(models.size());
        for (String model : models) {
            Set<String> childModels = this.getChildModels(model);
            assert (childModels != null);
            if (childModels.isEmpty()) continue;
            aggregatedModels.add(model);
        }
        return aggregatedModels;
    }

    private void validateAtMostOneAggregatedModel(Set<String> aggregatedModels) {
        if (aggregatedModels.size() > 1) {
            throw new UnsupportedOperationException(String.format("Found multiple aggregated models in the same query: %s", aggregatedModels));
        }
    }

    private void validateSelectContainsEverySortProperty(Query query) {
        assert (query != null);
        HashSet<String> selectedProperties = new HashSet<String>(query.getProperties());
        for (SortCriterion criterion : query.getSortCriteria()) {
            String property = criterion.getProperty();
            if (selectedProperties.contains(property)) continue;
            throw new UnsupportedOperationException(String.format("Query orders by property '%s' but does not select it: %s", property, query));
        }
    }

    private void validateAggregatedIsTheOnlyModel(List<String> models, String aggregatedModel) {
        assert (models != null);
        assert (!models.isEmpty());
        assert (aggregatedModel != null);
        if (!Collections.singletonList(aggregatedModel).equals(models)) {
            throw new UnsupportedOperationException(String.format("Unexpected models in query for aggregated model '%s': %s", aggregatedModel, models));
        }
    }

    private List<Query> createChildQueries(Query query, String aggregatedModel, List<String> childModels) {
        assert (query != null);
        assert (aggregatedModel != null);
        assert (childModels != null);
        ArrayList<Query> childQueries = new ArrayList<Query>(childModels.size());
        for (String childModel : childModels) {
            Set<String> childModelProperties = this.getChildModelProperties(childModel);
            Query childQuery = new AggregatedModelQueryConverter(aggregatedModel, childModel, childModelProperties).toChildQuery(query);
            childQueries.add(childQuery);
        }
        return childQueries;
    }

    private Set<String> getChildModelProperties(String childModel) {
        QuerySchema.ModelInfo modelInfo = this._schema.getModels().get(childModel);
        if (modelInfo == null) {
            throw new IllegalStateException("Aggregated model contains child model that is not supported by the schema: " + childModel);
        }
        return modelInfo.getProperties().keySet();
    }

    private List<ResultSet> convertChildResults(List<ResultSet> childResults, List<String> childModels, String aggregatedModel, List<String> aggregatedProperties) {
        assert (childResults != null);
        assert (childModels != null);
        assert (childResults.size() == childModels.size());
        assert (aggregatedModel != null);
        assert (aggregatedProperties != null);
        ArrayList<ResultSet> results = new ArrayList<ResultSet>(childResults.size());
        Iterator<ResultSet> childResultIterator = childResults.iterator();
        for (String childModel : childModels) {
            ResultSet childResult = childResultIterator.next();
            if (childResult == null) continue;
            Set<String> childModelProperties = this.getChildModelProperties(childModel);
            ResultSet result = new AggregatedModelResultConverter(aggregatedModel, childModel, childModelProperties).fromChildResult(childResult, aggregatedProperties);
            results.add(result);
        }
        return results;
    }

    private ResultSet mergeResults(List<ResultSet> results, Query query) {
        assert (results != null);
        assert (query != null);
        SequenceMergePolicy<ResourceItem> itemMergePolicy = this.getItemSequenceMergePolicy(query);
        ResultMergePolicy resultMergePolicy = new ResultMergePolicy(itemMergePolicy);
        return resultMergePolicy.merge(results, query.getWithTotalCount(), query.getOffset(), query.getLimit());
    }

    private SequenceMergePolicy<ResourceItem> getItemSequenceMergePolicy(Query query) {
        assert (query != null);
        if (query.getSortCriteria().isEmpty()) {
            return new UnorderedSequenceMergePolicy<ResourceItem>();
        }
        DefaultItemComparator itemComparator = new DefaultItemComparator(query.getProperties(), query.getSortCriteria());
        return new OrderedSequenceMergePolicy<ResourceItem>(itemComparator);
    }
}

