/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider.ext.aggregated;

import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.provider.ext.aggregated.AggregatedModelPropertyConverter;
import com.vmware.cis.data.internal.provider.util.ResourceItemUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class AggregatedModelResultConverter {
    private final AggregatedModelPropertyConverter _propertyConverter;

    public AggregatedModelResultConverter(String aggregatedModel, String childModel, Set<String> childModelPropertiesNonQualified) {
        assert (aggregatedModel != null);
        assert (childModel != null);
        assert (childModelPropertiesNonQualified != null);
        this._propertyConverter = new AggregatedModelPropertyConverter(aggregatedModel, childModel, childModelPropertiesNonQualified);
    }

    public ResultSet fromChildResult(ResultSet childResult, List<String> aggregatedProperties) {
        assert (childResult != null);
        assert (aggregatedProperties != null);
        return this.renameAndReorder(childResult, aggregatedProperties);
    }

    private ResultSet renameAndReorder(ResultSet childResult, List<String> aggregatedProperties) {
        assert (childResult != null);
        assert (aggregatedProperties != null);
        ArrayList<ResourceItem> aggregatedItems = new ArrayList<ResourceItem>(childResult.getItems().size());
        for (ResourceItem childItem : childResult.getItems()) {
            ResourceItem aggregatedItem = this.renameAndReorder(childItem, childResult.getProperties(), aggregatedProperties);
            aggregatedItems.add(aggregatedItem);
        }
        return new ResultSet(aggregatedProperties, aggregatedItems, childResult.getTotalCount());
    }

    private ResourceItem renameAndReorder(ResourceItem childItem, List<String> childProperties, List<String> aggregatedProperties) {
        assert (childItem != null);
        assert (childProperties != null);
        assert (childItem.getPropertyValues().size() == childProperties.size());
        assert (aggregatedProperties != null);
        Map<String, Object> valueByChildProperty = ResourceItemUtil.toValueByProperty(childItem, childProperties);
        ArrayList<Object> values = new ArrayList<Object>(aggregatedProperties.size());
        for (String aggregatedProperty : aggregatedProperties) {
            String childProperty = this._propertyConverter.toChildProperty(aggregatedProperty);
            Object value = null;
            if (childProperty != null) {
                value = valueByChildProperty.get(childProperty);
            }
            values.add(value);
        }
        return new ResourceItem(values);
    }
}

