/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider.ext.aggregated;

import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.internal.provider.ext.aggregated.AggregatedModelLookup;
import java.util.HashMap;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AggregatedModelSchema {
    private static final Logger _logger = LoggerFactory.getLogger(AggregatedModelSchema.class);

    AggregatedModelSchema() {
    }

    public static QuerySchema addAggregatedModels(QuerySchema schema, AggregatedModelLookup lookup) {
        assert (schema != null);
        assert (lookup != null);
        HashMap<String, QuerySchema.ModelInfo> models = new HashMap<String, QuerySchema.ModelInfo>(schema.getModels());
        for (String aggregatedModel : lookup.getAllAggregatedModels()) {
            Set<String> childModels = lookup.getChildrenOfAggregatedModel(aggregatedModel);
            if (childModels.contains(aggregatedModel)) {
                throw new UnsupportedOperationException("Aggregated model has the same name as one of its child models: " + aggregatedModel);
            }
            QuerySchema.ModelInfo aggregatedModelInfo = AggregatedModelSchema.getAggregatedModelInfo(schema, aggregatedModel, childModels);
            if (aggregatedModelInfo == null) continue;
            models.put(aggregatedModel, aggregatedModelInfo);
        }
        return QuerySchema.forModels(models);
    }

    private static QuerySchema.ModelInfo getAggregatedModelInfo(QuerySchema schema, String aggregatedModel, Set<String> childModels) {
        assert (schema != null);
        assert (aggregatedModel != null);
        assert (childModels != null);
        assert (!childModels.isEmpty());
        HashMap<String, QuerySchema.PropertyInfo> props = new HashMap<String, QuerySchema.PropertyInfo>();
        for (String childModel : childModels) {
            QuerySchema.ModelInfo childModelInfo = schema.getModels().get(childModel);
            if (childModelInfo == null) {
                _logger.info("Hide aggregated model '{}' due to missing child model '{}'", (Object)aggregatedModel, (Object)childModel);
                return null;
            }
            if (childModelInfo == null) continue;
            props.putAll(childModelInfo.getProperties());
        }
        return new QuerySchema.ModelInfo(props);
    }
}

