/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider.ext.aggregated;

import com.vmware.cis.data.internal.provider.ext.aggregated.AggregatedModelLookup;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;

public final class MapBasedAggregatedModelLookup
implements AggregatedModelLookup {
    private final Map<String, Set<String>> _childModelsByAggregatedModel;

    public MapBasedAggregatedModelLookup(Map<String, Set<String>> childModelsByAggregatedModel) {
        MapBasedAggregatedModelLookup.validateMap(childModelsByAggregatedModel);
        this._childModelsByAggregatedModel = Collections.unmodifiableMap(childModelsByAggregatedModel);
    }

    @Override
    public Set<String> getChildrenOfAggregatedModel(String resourceModel) {
        Validate.notEmpty((String)resourceModel);
        Set<String> childModels = this._childModelsByAggregatedModel.get(resourceModel);
        if (childModels != null) {
            return Collections.unmodifiableSet(childModels);
        }
        return Collections.emptySet();
    }

    @Override
    public Set<String> getAllAggregatedModels() {
        return this._childModelsByAggregatedModel.keySet();
    }

    private static void validateMap(Map<String, Set<String>> childModelsByAggregatedModel) {
        Validate.notNull(childModelsByAggregatedModel);
        for (Map.Entry<String, Set<String>> e : childModelsByAggregatedModel.entrySet()) {
            Validate.notNull((Object)e.getKey(), (String)"Aggregated model name must not be null");
            Validate.notEmpty((Collection)e.getValue(), (String)"Set of child models must not be null or empty");
        }
    }
}

