/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider.ext.alias;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.SortCriterion;
import com.vmware.cis.data.internal.provider.ext.alias.AliasLengthProperty;
import com.vmware.cis.data.internal.provider.ext.alias.AliasPropertyDescriptor;
import com.vmware.cis.data.internal.provider.ext.alias.AliasPropertyLookup;
import com.vmware.cis.data.internal.provider.util.QueryQualifier;
import com.vmware.cis.data.internal.provider.util.SchemaUtil;
import com.vmware.cis.data.internal.util.PropertyUtil;
import com.vmware.cis.data.provider.DataProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AliasPropertyProviderConnection
implements DataProvider {
    private static Logger _logger = LoggerFactory.getLogger(AliasPropertyProviderConnection.class);
    private final DataProvider _connection;
    private final AliasPropertyLookup _aliasPropertyLookup;

    public AliasPropertyProviderConnection(DataProvider connection, AliasPropertyLookup aliasPropertyLookup) {
        assert (connection != null);
        assert (aliasPropertyLookup != null);
        this._connection = connection;
        this._aliasPropertyLookup = aliasPropertyLookup;
    }

    @Override
    public ResultSet executeQuery(Query query) {
        Validate.notNull((Object)query);
        HashMap<String, String> realByAliasMapping = new HashMap<String, String>();
        Query convertedQuery = AliasPropertyProviderConnection.convertQuery(query, this._aliasPropertyLookup, realByAliasMapping);
        ResultSet result = this._connection.executeQuery(convertedQuery);
        Map<String, List<String>> aliasByRealMapping = Collections.unmodifiableMap(this.reverseMapping(realByAliasMapping));
        return AliasPropertyProviderConnection.convertResult(result, query.getProperties(), aliasByRealMapping);
    }

    @Override
    public QuerySchema getSchema() {
        QuerySchema baseSchema = this._connection.getSchema();
        QuerySchema aliasSchema = this._aliasPropertyLookup.calculateAliasPropertySchema(baseSchema);
        return SchemaUtil.merge(baseSchema, aliasSchema);
    }

    private static Query convertQuery(Query originalQuery, AliasPropertyLookup aliasPropertyLookup, Map<String, String> realByAliasMapping) {
        assert (originalQuery != null);
        assert (aliasPropertyLookup != null);
        assert (realByAliasMapping != null);
        List<String> select = AliasPropertyProviderConnection.convertSelect(originalQuery.getProperties(), aliasPropertyLookup, realByAliasMapping);
        Filter filter = AliasPropertyProviderConnection.convertFilter(originalQuery.getFilter(), aliasPropertyLookup, realByAliasMapping);
        List<SortCriterion> sort = AliasPropertyProviderConnection.convertSort(originalQuery.getSortCriteria(), aliasPropertyLookup, realByAliasMapping);
        if (realByAliasMapping.isEmpty()) {
            return originalQuery;
        }
        List<String> resourceModels = QueryQualifier.getFromClause(select, filter, sort);
        Query convertedQuery = Query.Builder.copyAndSelect(originalQuery, select).from(resourceModels).where(filter).orderBy(sort).build();
        if (_logger.isTraceEnabled()) {
            _logger.trace("[QueryModel] Processing a query containing aliases: {}", realByAliasMapping.keySet());
            _logger.trace("[QueryModel] The query to be executed is: {}", (Object)convertedQuery);
        }
        return convertedQuery;
    }

    private static List<String> convertSelect(List<String> properties, AliasPropertyLookup aliasPropertyLookup, Map<String, String> realByAliasMapping) {
        assert (properties != null);
        LinkedHashSet<String> converted = new LinkedHashSet<String>(properties.size());
        for (String property : properties) {
            String convertedProperty = AliasPropertyProviderConnection.convertProperty(property, aliasPropertyLookup, realByAliasMapping);
            converted.add(convertedProperty);
        }
        return new ArrayList<String>(converted);
    }

    private static Filter convertFilter(Filter filter, AliasPropertyLookup aliasPropertyLookup, Map<String, String> realByAliasMapping) {
        if (filter == null) {
            return null;
        }
        assert (filter.getCriteria() != null);
        assert (!filter.getCriteria().isEmpty());
        ArrayList<PropertyPredicate> predicates = new ArrayList<PropertyPredicate>(filter.getCriteria().size());
        for (PropertyPredicate predicate : filter.getCriteria()) {
            predicates.add(AliasPropertyProviderConnection.convertPredicate(predicate, aliasPropertyLookup, realByAliasMapping));
        }
        return new Filter(predicates, filter.getOperator());
    }

    private static PropertyPredicate convertPredicate(PropertyPredicate predicate, AliasPropertyLookup aliasPropertyLookup, Map<String, String> realByAliasMapping) {
        assert (predicate != null);
        return new PropertyPredicate(AliasPropertyProviderConnection.convertProperty(predicate.getProperty(), aliasPropertyLookup, realByAliasMapping), predicate.getOperator(), predicate.getComparableValue(), predicate.isIgnoreCase());
    }

    private static List<SortCriterion> convertSort(List<SortCriterion> order, AliasPropertyLookup aliasPropertyLookup, Map<String, String> realByAliasMapping) {
        assert (order != null);
        if (order.isEmpty()) {
            return order;
        }
        ArrayList<SortCriterion> converted = new ArrayList<SortCriterion>(order.size());
        for (SortCriterion criterion : order) {
            converted.add(AliasPropertyProviderConnection.convertSortCriterion(criterion, aliasPropertyLookup, realByAliasMapping));
        }
        return converted;
    }

    private static SortCriterion convertSortCriterion(SortCriterion criterion, AliasPropertyLookup aliasPropertyLookup, Map<String, String> realByAliasMapping) {
        assert (criterion != null);
        return new SortCriterion(AliasPropertyProviderConnection.convertProperty(criterion.getProperty(), aliasPropertyLookup, realByAliasMapping), criterion.getSortDirection(), criterion.isIgnoreCase());
    }

    private static String convertProperty(String property, AliasPropertyLookup aliasPropertyLookup, Map<String, String> realByAliasMapping) {
        String suffix;
        String propertyToCheck;
        AliasPropertyDescriptor propertyDescriptor;
        assert (property != null);
        if (PropertyUtil.isSpecialProperty(property)) {
            return property;
        }
        String mappedProperty = realByAliasMapping.get(property);
        if (StringUtils.isEmpty((String)mappedProperty) && (propertyDescriptor = aliasPropertyLookup.getAliasPropertyDescriptor(propertyToCheck = AliasLengthProperty.cleanSuffix(property, suffix = AliasLengthProperty.resolveSuffix(property)))) != null) {
            mappedProperty = AliasLengthProperty.appendSuffix(propertyDescriptor.getTargetName(), suffix);
            realByAliasMapping.put(AliasLengthProperty.appendSuffix(propertyDescriptor.getName(), suffix), mappedProperty);
        }
        if (StringUtils.isEmpty((String)mappedProperty)) {
            return property;
        }
        return mappedProperty;
    }

    private static ResultSet convertResult(ResultSet resultSet, List<String> queryProperties, Map<String, List<String>> aliasByRealMapping) {
        assert (resultSet != null);
        if (aliasByRealMapping.isEmpty()) {
            return resultSet;
        }
        ArrayList<Integer> propertyValueIndicesToDuplicate = new ArrayList<Integer>();
        List<String> convertedResultProperties = AliasPropertyProviderConnection.convertResultProperties(resultSet.getProperties(), queryProperties, aliasByRealMapping, propertyValueIndicesToDuplicate);
        List<ResourceItem> convertedResourceItems = AliasPropertyProviderConnection.convertResourceItems(resultSet.getItems(), propertyValueIndicesToDuplicate);
        return new ResultSet(convertedResultProperties, convertedResourceItems, resultSet.getTotalCount());
    }

    private static List<String> convertResultProperties(List<String> resultProperties, List<String> queryProperties, Map<String, List<String>> aliasByRealMapping, List<Integer> propertyValueIndicesToDuplicate) {
        assert (resultProperties != null);
        HashSet<String> queryPropertiesSet = new HashSet<String>(queryProperties);
        ArrayList<String> convertedProperties = new ArrayList<String>(resultProperties.size());
        ArrayList<String> duplicateAliasProperties = new ArrayList<String>();
        int propertyIndex = 0;
        for (String property : resultProperties) {
            List<String> mappedProperties = aliasByRealMapping.get(property);
            if (CollectionUtils.isEmpty(mappedProperties)) {
                convertedProperties.add(property);
            } else if (queryPropertiesSet.contains(property)) {
                convertedProperties.add(property);
                for (String mappedProperty : mappedProperties) {
                    if (!queryPropertiesSet.contains(mappedProperty)) continue;
                    duplicateAliasProperties.add(mappedProperty);
                    propertyValueIndicesToDuplicate.add(propertyIndex);
                }
            } else {
                convertedProperties.add(mappedProperties.get(0));
                for (int i = 1; i < mappedProperties.size(); ++i) {
                    String mappedProperty;
                    mappedProperty = mappedProperties.get(i);
                    if (!queryPropertiesSet.contains(mappedProperty)) continue;
                    duplicateAliasProperties.add(mappedProperty);
                    propertyValueIndicesToDuplicate.add(propertyIndex);
                }
            }
            ++propertyIndex;
        }
        convertedProperties.addAll(duplicateAliasProperties);
        return convertedProperties;
    }

    private static List<ResourceItem> convertResourceItems(List<ResourceItem> resourceItems, List<Integer> propertyValueIndicesToDuplicate) {
        if (resourceItems.isEmpty() || propertyValueIndicesToDuplicate.isEmpty()) {
            return resourceItems;
        }
        ArrayList<ResourceItem> convertedResourceItems = new ArrayList<ResourceItem>(resourceItems.size());
        for (ResourceItem resourceItem : resourceItems) {
            ArrayList<Object> propertyValues = new ArrayList<Object>(resourceItem.getPropertyValues());
            for (Integer duplicateIndex : propertyValueIndicesToDuplicate) {
                if (duplicateIndex >= propertyValues.size()) continue;
                Object propValue = propertyValues.get(duplicateIndex);
                propertyValues.add(propValue);
            }
            convertedResourceItems.add(new ResourceItem(propertyValues));
        }
        return convertedResourceItems;
    }

    private Map<String, List<String>> reverseMapping(Map<String, String> mapping) {
        assert (mapping != null);
        HashMap<String, List<String>> reversedMapping = new HashMap<String, List<String>>();
        for (Map.Entry<String, String> entry : mapping.entrySet()) {
            ArrayList<String> reverseValues = (ArrayList<String>)reversedMapping.get(entry.getValue());
            if (reverseValues == null) {
                reverseValues = new ArrayList<String>();
                reversedMapping.put(entry.getValue(), reverseValues);
            }
            reverseValues.add(entry.getKey());
        }
        return reversedMapping;
    }
}

