/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider.ext.derived;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.SortCriterion;
import com.vmware.cis.data.internal.provider.ext.derived.DerivedPropertyDescriptor;
import com.vmware.cis.data.internal.provider.ext.derived.DerivedPropertyLookup;
import com.vmware.cis.data.internal.provider.util.QueryQualifier;
import com.vmware.cis.data.internal.provider.util.ResourceItemUtil;
import com.vmware.cis.data.internal.provider.util.SchemaUtil;
import com.vmware.cis.data.provider.DataProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DerivedPropertyProviderConnection
implements DataProvider {
    private static Logger _logger = LoggerFactory.getLogger(DerivedPropertyProviderConnection.class);
    private final DataProvider _connection;
    private final DerivedPropertyLookup _derivedPropertyLookup;

    public DerivedPropertyProviderConnection(DataProvider connection, DerivedPropertyLookup derivedPropertyLookup) {
        assert (connection != null);
        assert (derivedPropertyLookup != null);
        this._connection = connection;
        this._derivedPropertyLookup = derivedPropertyLookup;
    }

    @Override
    public ResultSet executeQuery(Query query) {
        Validate.notNull((Object)query);
        this.validateNoDerivedProperties(query.getFilter());
        this.validateNoDerivedProperties(query.getSortCriteria());
        Map<String, DerivedPropertyDescriptor> derivedPropertyByName = DerivedPropertyProviderConnection.getDerivedProperties(query, this._derivedPropertyLookup);
        if (derivedPropertyByName.isEmpty()) {
            return this._connection.executeQuery(query);
        }
        Query executableQuery = DerivedPropertyProviderConnection.toExecutableQuery(query, derivedPropertyByName);
        if (_logger.isTraceEnabled()) {
            _logger.trace("Sending query with replaced derived properties {}", (Object)query);
        }
        ResultSet rawResult = this._connection.executeQuery(executableQuery);
        if (_logger.isTraceEnabled()) {
            _logger.trace("Received response for replaced derived properties {}", (Object)rawResult);
        }
        return DerivedPropertyProviderConnection.processResult(rawResult, query.getProperties(), derivedPropertyByName);
    }

    @Override
    public QuerySchema getSchema() {
        return SchemaUtil.merge(this._connection.getSchema(), this._derivedPropertyLookup.getDerivedPropertySchema());
    }

    private void validateNoDerivedProperties(Filter filter) {
        if (filter == null) {
            return;
        }
        for (PropertyPredicate predicate : filter.getCriteria()) {
            this.validateNoDerivedProperties(predicate);
        }
    }

    private void validateNoDerivedProperties(PropertyPredicate predicate) {
        assert (predicate != null);
        String property = predicate.getProperty();
        DerivedPropertyDescriptor descriptor = this.getDescriptor(property);
        if (descriptor != null) {
            throw new IllegalArgumentException(String.format("Derived properties cannot be used for filtering: %s", predicate));
        }
    }

    private void validateNoDerivedProperties(List<SortCriterion> sortCriteria) {
        assert (sortCriteria != null);
        for (SortCriterion sortCriterion : sortCriteria) {
            this.validateNoDerivedProperties(sortCriterion);
        }
    }

    private void validateNoDerivedProperties(SortCriterion sortCriterion) {
        assert (sortCriterion != null);
        String property = sortCriterion.getProperty();
        DerivedPropertyDescriptor descriptor = this.getDescriptor(property);
        if (descriptor != null) {
            throw new IllegalArgumentException(String.format("Derived properties cannot be used for sorting: %s", sortCriterion));
        }
    }

    private DerivedPropertyDescriptor getDescriptor(String property) {
        return this._derivedPropertyLookup.getDerivedPropertyDescriptor(property);
    }

    private static Map<String, DerivedPropertyDescriptor> getDerivedProperties(Query originalQuery, DerivedPropertyLookup derivedPropertyLookup) {
        assert (originalQuery != null);
        assert (derivedPropertyLookup != null);
        HashMap<String, DerivedPropertyDescriptor> derivedPropertyByName = new HashMap<String, DerivedPropertyDescriptor>();
        for (String property : originalQuery.getProperties()) {
            DerivedPropertyDescriptor descriptor = derivedPropertyLookup.getDerivedPropertyDescriptor(property);
            if (descriptor == null) continue;
            derivedPropertyByName.put(property, descriptor);
        }
        return derivedPropertyByName;
    }

    private static Query toExecutableQuery(Query originalQuery, Map<String, DerivedPropertyDescriptor> derivedPropertyByName) {
        assert (originalQuery != null);
        assert (derivedPropertyByName != null);
        assert (!derivedPropertyByName.isEmpty());
        List<String> properties = DerivedPropertyProviderConnection.toExecutableProperties(originalQuery.getProperties(), derivedPropertyByName);
        List<String> resourceModels = QueryQualifier.getFromClause(properties, originalQuery.getFilter(), originalQuery.getSortCriteria());
        return Query.Builder.copyAndSelect(originalQuery, properties).from(resourceModels).build();
    }

    private static List<String> toExecutableProperties(List<String> originalSelect, Map<String, DerivedPropertyDescriptor> derivedPropertyByName) {
        assert (originalSelect != null);
        assert (derivedPropertyByName != null);
        ArrayList<String> executableProperties = new ArrayList<String>();
        for (String property : originalSelect) {
            DerivedPropertyDescriptor descriptor = derivedPropertyByName.get(property);
            if (descriptor != null) {
                executableProperties.addAll(descriptor.getDependencyProperties());
                continue;
            }
            executableProperties.add(property);
        }
        return new ArrayList<String>(new LinkedHashSet(executableProperties));
    }

    private static ResultSet processResult(ResultSet rawResult, List<String> originalSelect, Map<String, DerivedPropertyDescriptor> derivedPropertyByName) {
        assert (rawResult != null);
        assert (originalSelect != null);
        assert (derivedPropertyByName != null);
        assert (!derivedPropertyByName.isEmpty());
        List<ResourceItem> items = DerivedPropertyProviderConnection.processItems(rawResult.getItems(), rawResult.getProperties(), originalSelect, derivedPropertyByName);
        return new ResultSet(originalSelect, items, rawResult.getTotalCount());
    }

    private static List<ResourceItem> processItems(List<ResourceItem> rawItems, List<String> rawItemProperties, List<String> originalSelect, Map<String, DerivedPropertyDescriptor> derivedPropertyByName) {
        assert (rawItems != null);
        assert (rawItemProperties != null);
        assert (originalSelect != null);
        assert (derivedPropertyByName != null);
        ArrayList<ResourceItem> items = new ArrayList<ResourceItem>(rawItems.size());
        for (ResourceItem rawItem : rawItems) {
            ResourceItem item = DerivedPropertyProviderConnection.processItem(rawItem, rawItemProperties, originalSelect, derivedPropertyByName);
            items.add(item);
        }
        return items;
    }

    private static ResourceItem processItem(ResourceItem rawItem, List<String> rawItemProperties, List<String> originalSelect, Map<String, DerivedPropertyDescriptor> derivedPropertyByName) {
        assert (rawItem != null);
        assert (rawItemProperties != null);
        assert (originalSelect != null);
        assert (derivedPropertyByName != null);
        Map<String, Object> valueByProperty = ResourceItemUtil.toValueByProperty(rawItem, rawItemProperties);
        ArrayList<Object> values = new ArrayList<Object>(originalSelect.size());
        for (String property : originalSelect) {
            DerivedPropertyDescriptor descriptor = derivedPropertyByName.get(property);
            Object value = descriptor != null ? descriptor.invokeDerivedPropertyMethod(valueByProperty) : valueByProperty.get(property);
            values.add(value);
        }
        return new ResourceItem(values);
    }
}

