/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider.ext.predicate;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.internal.provider.ext.predicate.PredicateAlgebra;
import java.util.ArrayList;

final class FilterAlgebra {
    FilterAlgebra() {
    }

    public static Filter negate(Filter filter) {
        assert (filter != null);
        ArrayList<PropertyPredicate> negatedPredicates = new ArrayList<PropertyPredicate>(filter.getCriteria().size());
        for (PropertyPredicate predicate : filter.getCriteria()) {
            PropertyPredicate negatedPredicate = PredicateAlgebra.negate(predicate);
            negatedPredicates.add(negatedPredicate);
        }
        return new Filter(negatedPredicates, FilterAlgebra.negate(filter.getOperator()));
    }

    private static LogicalOperator negate(LogicalOperator logicalOperator) {
        assert (logicalOperator != null);
        switch (logicalOperator) {
            case AND: {
                return LogicalOperator.OR;
            }
            case OR: {
                return LogicalOperator.AND;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported logical operator '%s'", new Object[]{logicalOperator}));
    }
}

