/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider.ext.predicate;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.internal.util.PropertyUtil;
import com.vmware.cis.data.internal.util.QualifiedProperty;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;

public final class PredicatePropertyDescriptor {
    public static final String PREDICATE_PROPERTY_METHOD_NAME_PREFIX = "get";
    private final String _propertyName;
    private final Filter _filter;

    public static PredicatePropertyDescriptor fromMethod(String resourceModel, Method predicatePropertyMethod) {
        Validate.notEmpty((String)resourceModel, (String)"Model name must not be empty");
        Validate.notNull((Object)predicatePropertyMethod, (String)"Predicate property method must not be null");
        PredicatePropertyDescriptor.validateMethod(resourceModel, predicatePropertyMethod);
        String property = PredicatePropertyDescriptor.getPredicatePropertyName(resourceModel, predicatePropertyMethod);
        Filter filter = PredicatePropertyDescriptor.getPredicatePropertyFilter(resourceModel, predicatePropertyMethod);
        PredicatePropertyDescriptor.validateFilter(property, filter);
        return new PredicatePropertyDescriptor(property, filter);
    }

    private PredicatePropertyDescriptor(String propertyName, Filter filter) {
        assert (propertyName != null);
        assert (filter != null);
        this._propertyName = propertyName;
        this._filter = filter;
    }

    public String getName() {
        return this._propertyName;
    }

    public Filter getFilter() {
        return this._filter;
    }

    private static String getPredicatePropertyName(String resourceModel, Method predicatePropertyMethod) {
        assert (resourceModel != null);
        assert (predicatePropertyMethod != null);
        String simpleProperty = PredicatePropertyDescriptor.getPredicatePropertySimpleName(predicatePropertyMethod);
        return QualifiedProperty.forModelAndSimpleProperty(resourceModel, simpleProperty).toString();
    }

    private static String getPredicatePropertySimpleName(Method predicatePropertyMethod) {
        assert (predicatePropertyMethod != null);
        String methodName = predicatePropertyMethod.getName();
        Validate.isTrue((boolean)methodName.startsWith(PREDICATE_PROPERTY_METHOD_NAME_PREFIX), (String)String.format("Predicate property method name must start with 'get' prefix: '%s'", methodName));
        Validate.isTrue((methodName.codePointCount(0, methodName.length()) == methodName.length() ? 1 : 0) != 0, (String)String.format("Predicate property method name must use only ASCII characters: '%s'", methodName));
        String rawPropertyName = methodName.substring(PREDICATE_PROPERTY_METHOD_NAME_PREFIX.length());
        Validate.notEmpty((String)rawPropertyName, (String)String.format("Predicate property method name must contain property name after the 'get' prefix: '%s'", methodName));
        return Character.toLowerCase(rawPropertyName.charAt(0)) + rawPropertyName.substring(1);
    }

    private static void validateMethod(String resourceModel, Method predicatePropertyMethod) {
        assert (resourceModel != null);
        assert (predicatePropertyMethod != null);
        Validate.isTrue((boolean)Modifier.isPublic(predicatePropertyMethod.getModifiers()), (String)String.format("Predicate property method '%s' for model '%s' must be public.", predicatePropertyMethod.getName(), resourceModel));
        Validate.isTrue((boolean)Modifier.isStatic(predicatePropertyMethod.getModifiers()), (String)String.format("Predicate property method '%s' must be static.", predicatePropertyMethod.getName()));
        Class<?> returnType = predicatePropertyMethod.getReturnType();
        Validate.isTrue((PropertyPredicate.class.equals(returnType) || Filter.class.equals(returnType) ? 1 : 0) != 0, (String)String.format("Predicate property method '%s' must return PropertyPredicate or Filter and not %s", predicatePropertyMethod.getName(), returnType.getCanonicalName()));
        Validate.isTrue((boolean)ArrayUtils.isEmpty((Object[])predicatePropertyMethod.getParameterTypes()), (String)String.format("Predicate property method '%s' must have no arguments", predicatePropertyMethod.getName()));
    }

    private static Filter getPredicatePropertyFilter(String resourceModel, Method predicatePropertyMethod) {
        Object obj;
        assert (resourceModel != null);
        assert (predicatePropertyMethod != null);
        try {
            obj = predicatePropertyMethod.invoke(null, new Object[0]);
        }
        catch (Exception ex) {
            throw new IllegalStateException(String.format("Error while invoking predicate property method '%s'", predicatePropertyMethod.getName()), ex);
        }
        if (obj instanceof Filter) {
            return (Filter)obj;
        }
        if (!(obj instanceof PropertyPredicate)) {
            throw new IllegalStateException(String.format("Predicate property method '%s' returned %s instead of Filter/PropertyPredicate", predicatePropertyMethod.getName(), obj));
        }
        return new Filter(Collections.singletonList((PropertyPredicate)obj));
    }

    private static void validateFilter(String predicatePropertyName, Filter filter) {
        assert (filter != null);
        for (PropertyPredicate predicate : filter.getCriteria()) {
            assert (predicate != null);
            String property = predicate.getProperty();
            PropertyPredicate.ComparisonOperator operator = predicate.getOperator();
            Object comparableValue = predicate.getComparableValue();
            assert (property != null);
            assert (operator != null);
            assert (comparableValue != null);
            if (PropertyUtil.isModelKey(property)) {
                throw new IllegalArgumentException(String.format("Predicate property '%s' depends on '%s'", predicatePropertyName, property));
            }
            if (!PropertyPredicate.ComparisonOperator.GREATER.equals((Object)operator) && !PropertyPredicate.ComparisonOperator.GREATER_OR_EQUAL.equals((Object)operator) && !PropertyPredicate.ComparisonOperator.LESS.equals((Object)operator) && !PropertyPredicate.ComparisonOperator.LESS_OR_EQUAL.equals((Object)operator) || comparableValue instanceof Comparable) continue;
            throw new IllegalArgumentException(String.format("Predicate property '%s' uses predicate with operator '%s' but the comparable value does not implement java.util.Comparable: %s", new Object[]{predicatePropertyName, operator, predicate}));
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PredicatePropertyDescriptor)) {
            return false;
        }
        PredicatePropertyDescriptor other = (PredicatePropertyDescriptor)obj;
        return this._propertyName.equals(other._propertyName) && this._filter.equals(other._filter);
    }

    public int hashCode() {
        int hash = 29;
        hash = 31 * hash + this._propertyName.hashCode();
        hash = 31 * hash + this._filter.hashCode();
        return hash;
    }

    public String toString() {
        return "PredicatePropertyDescriptor[_propertyName=" + this._propertyName + ", _filter=" + this._filter + "]";
    }
}

