/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider.ext.predicate;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.SortCriterion;
import com.vmware.cis.data.internal.provider.ext.predicate.PredicatePropertyDescriptor;
import com.vmware.cis.data.internal.provider.ext.predicate.PredicatePropertyFilter;
import com.vmware.cis.data.internal.provider.ext.predicate.PredicatePropertyLookup;
import com.vmware.cis.data.internal.provider.ext.predicate.PredicatePropertySelect;
import com.vmware.cis.data.internal.provider.util.QueryQualifier;
import com.vmware.cis.data.internal.provider.util.SchemaUtil;
import com.vmware.cis.data.internal.util.PropertyUtil;
import com.vmware.cis.data.provider.DataProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PredicatePropertyProviderConnection
implements DataProvider {
    private static Logger _logger = LoggerFactory.getLogger(PredicatePropertyProviderConnection.class);
    private final DataProvider _connection;
    private final PredicatePropertyLookup _predicatePropertyLookup;

    public PredicatePropertyProviderConnection(DataProvider connection, PredicatePropertyLookup predicatePropertyLookup) {
        assert (connection != null);
        assert (predicatePropertyLookup != null);
        this._connection = connection;
        this._predicatePropertyLookup = predicatePropertyLookup;
    }

    @Override
    public ResultSet executeQuery(Query query) {
        Validate.notNull((Object)query);
        this.validateNoOrderByPredicateProperty(query.getSortCriteria());
        Map<String, PredicatePropertyDescriptor> predicatePropsInFilter = this.getDescriptors(query.getFilter());
        Map<String, PredicatePropertyDescriptor> predicatePropsInSelect = this.getDescriptors(query.getProperties());
        if (predicatePropsInFilter.isEmpty() && predicatePropsInSelect.isEmpty()) {
            return this._connection.executeQuery(query);
        }
        this.logPredicateProps(query, predicatePropsInFilter, predicatePropsInSelect);
        List<String> executableSelect = PredicatePropertySelect.toExecutableSelect(query.getProperties(), predicatePropsInSelect);
        Filter executableFilter = PredicatePropertyFilter.toExecutableFilter(query.getFilter(), predicatePropsInFilter);
        List<String> resourceModels = QueryQualifier.getFromClause(executableSelect, executableFilter, query.getSortCriteria());
        Query executableQuery = Query.Builder.copyAndSelect(query, executableSelect).from(resourceModels).where(executableFilter).build();
        if (_logger.isTraceEnabled()) {
            _logger.trace("Sending query with replaced predicate properties {}", (Object)executableQuery);
        }
        ResultSet result = this._connection.executeQuery(executableQuery);
        if (_logger.isTraceEnabled()) {
            _logger.trace("Received response for query with replaced predicate property {}", (Object)executableQuery);
        }
        if (predicatePropsInSelect.isEmpty()) {
            return result;
        }
        return PredicatePropertySelect.convertResult(result, query.getProperties(), predicatePropsInSelect);
    }

    @Override
    public QuerySchema getSchema() {
        return SchemaUtil.merge(this._connection.getSchema(), this._predicatePropertyLookup.getPredicatePropertySchema());
    }

    private void validateNoOrderByPredicateProperty(List<SortCriterion> sortCriteria) {
        assert (sortCriteria != null);
        for (SortCriterion sortCriterion : sortCriteria) {
            if (this.getDescriptor(sortCriterion.getProperty()) == null) continue;
            throw new IllegalArgumentException(String.format("Predicate properties cannot be used for sorting: %s", sortCriterion));
        }
    }

    private Map<String, PredicatePropertyDescriptor> getDescriptors(Filter filter) {
        if (filter == null) {
            return Collections.emptyMap();
        }
        HashMap<String, PredicatePropertyDescriptor> descriptors = new HashMap<String, PredicatePropertyDescriptor>(filter.getCriteria().size());
        for (PropertyPredicate predicate : filter.getCriteria()) {
            this.addDescriptor(predicate.getProperty(), descriptors);
        }
        return Collections.unmodifiableMap(descriptors);
    }

    private Map<String, PredicatePropertyDescriptor> getDescriptors(List<String> select) {
        assert (select != null);
        HashMap<String, PredicatePropertyDescriptor> descriptors = new HashMap<String, PredicatePropertyDescriptor>(select.size());
        for (String property : select) {
            this.addDescriptor(property, descriptors);
        }
        return Collections.unmodifiableMap(descriptors);
    }

    private void addDescriptor(String property, Map<String, PredicatePropertyDescriptor> descriptors) {
        assert (property != null);
        assert (descriptors != null);
        if (PropertyUtil.isSpecialProperty(property)) {
            return;
        }
        if (descriptors.containsKey(property)) {
            return;
        }
        PredicatePropertyDescriptor descriptor = this.getDescriptor(property);
        if (descriptor == null) {
            return;
        }
        descriptors.put(property, descriptor);
    }

    private PredicatePropertyDescriptor getDescriptor(String property) {
        return this._predicatePropertyLookup.getPredicatePropertyDescriptor(property);
    }

    private void logPredicateProps(Query query, Map<String, PredicatePropertyDescriptor> predicatePropsInFilter, Map<String, PredicatePropertyDescriptor> predicatePropsInSelect) {
        if (!predicatePropsInFilter.isEmpty()) {
            if (_logger.isTraceEnabled()) {
                _logger.trace("Query filters on predicate properties {}: {}", predicatePropsInFilter.keySet(), (Object)query);
            } else {
                _logger.debug("Query filters on predicate properties {}", predicatePropsInFilter.keySet());
            }
        }
        if (!predicatePropsInSelect.isEmpty()) {
            if (_logger.isTraceEnabled()) {
                _logger.trace("Query selects predicate properties {}: {}", predicatePropsInSelect.keySet(), (Object)query);
            } else {
                _logger.debug("Query selects predicate properties {}", predicatePropsInSelect.keySet());
            }
        }
    }
}

