/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider.ext.predicate;

import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.internal.provider.ext.predicate.PredicatePropertyDescriptor;
import com.vmware.cis.data.internal.provider.ext.predicate.PredicatePropertyLookup;
import com.vmware.cis.data.internal.util.PropertyUtil;
import com.vmware.cis.data.model.PredicateProperty;
import com.vmware.cis.data.model.QueryModel;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public final class PredicatePropertyRepository
implements PredicatePropertyLookup {
    private final Map<String, PredicatePropertyDescriptor> _descriptorByPredicateProperty;
    private final QuerySchema _predicatePropertySchema;

    public PredicatePropertyRepository(Collection<Class<?>> registeredQueryModels) {
        this._descriptorByPredicateProperty = Collections.unmodifiableMap(PredicatePropertyRepository.registerPredicateProperties(registeredQueryModels));
        this._predicatePropertySchema = PredicatePropertyRepository.buildPredicatePropertySchema(this._descriptorByPredicateProperty);
    }

    @Override
    public PredicatePropertyDescriptor getPredicatePropertyDescriptor(String property) {
        if (PropertyUtil.isSpecialProperty(property)) {
            return null;
        }
        return this._descriptorByPredicateProperty.get(property);
    }

    @Override
    public QuerySchema getPredicatePropertySchema() {
        return this._predicatePropertySchema;
    }

    public static List<PredicatePropertyDescriptor> collectPredicatePropertyDescriptors(String resourceModel, Class<?> modelClass) {
        assert (!StringUtils.isEmpty((String)resourceModel));
        assert (modelClass != null);
        ArrayList<PredicatePropertyDescriptor> predicateProperties = new ArrayList<PredicatePropertyDescriptor>();
        for (Method method : modelClass.getMethods()) {
            PredicatePropertyDescriptor descriptor;
            if (!method.isAnnotationPresent(PredicateProperty.class)) continue;
            try {
                descriptor = PredicatePropertyDescriptor.fromMethod(resourceModel, method);
            }
            catch (RuntimeException ex) {
                throw new IllegalArgumentException(String.format("Invalid predicate property method '%s' in class '%s'", method.getName(), modelClass.getCanonicalName()), ex);
            }
            predicateProperties.add(descriptor);
        }
        return predicateProperties;
    }

    private static Map<String, PredicatePropertyDescriptor> registerPredicateProperties(Collection<Class<?>> modelClasses) {
        Validate.notNull(modelClasses);
        if (modelClasses.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, PredicatePropertyDescriptor> predicateProperties = new HashMap<String, PredicatePropertyDescriptor>();
        for (Class<?> modelClass : modelClasses) {
            PredicatePropertyRepository.registerPredicateProperties(modelClass, predicateProperties);
        }
        return predicateProperties;
    }

    private static void registerPredicateProperties(Class<?> modelClass, Map<String, PredicatePropertyDescriptor> predicateProperties) {
        Validate.notNull(modelClass);
        Validate.notNull(predicateProperties);
        List<PredicatePropertyDescriptor> predicatePropertiesDescriptors = PredicatePropertyRepository.collectPredicatePropertyDescriptors(modelClass);
        if (predicatePropertiesDescriptors.isEmpty()) {
            return;
        }
        for (PredicatePropertyDescriptor predicateProperty : predicatePropertiesDescriptors) {
            if (predicateProperties.containsKey(predicateProperty.getName())) {
                throw new IllegalArgumentException(String.format("Duplicate predicate property registration '%s' detected!", predicateProperty.getName()));
            }
            predicateProperties.put(predicateProperty.getName(), predicateProperty);
        }
    }

    private static List<PredicatePropertyDescriptor> collectPredicatePropertyDescriptors(Class<?> modelClass) {
        assert (modelClass != null);
        QueryModel modelDefinition = modelClass.getAnnotation(QueryModel.class);
        Validate.notNull((Object)modelDefinition, (String)"The provided class is not annotated with @QueryModel annotation.");
        return PredicatePropertyRepository.collectPredicatePropertyDescriptors(modelDefinition.value(), modelClass);
    }

    private static QuerySchema buildPredicatePropertySchema(Map<String, PredicatePropertyDescriptor> predicateProperties) {
        HashMap<String, QuerySchema.PropertyInfo> propertyInfoByName = new HashMap<String, QuerySchema.PropertyInfo>(predicateProperties.size());
        for (String property : predicateProperties.keySet()) {
            propertyInfoByName.put(property, QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.BOOLEAN));
        }
        return QuerySchema.forProperties(propertyInfoByName);
    }
}

