/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider.ext.predicate;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.provider.ext.predicate.PredicatePropertyDescriptor;
import com.vmware.cis.data.internal.provider.util.filter.FilterEvaluator;
import com.vmware.cis.data.internal.provider.util.property.PropertyByName;
import com.vmware.cis.data.internal.provider.util.property.PropertyByNameBackedByResourceItem;
import com.vmware.cis.data.internal.provider.util.property.ResourceItemPropertyValueByNameViaIndexMap;
import com.vmware.cis.data.internal.util.PropertyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

final class PredicatePropertySelect {
    PredicatePropertySelect() {
    }

    public static List<String> toExecutableSelect(List<String> originalSelect, Map<String, PredicatePropertyDescriptor> descriptors) {
        assert (originalSelect != null);
        assert (descriptors != null);
        if (descriptors.isEmpty()) {
            return originalSelect;
        }
        ArrayList<String> executableSelect = new ArrayList<String>();
        for (String property : originalSelect) {
            PredicatePropertyDescriptor descriptor = descriptors.get(property);
            if (descriptor == null) {
                executableSelect.add(property);
                continue;
            }
            executableSelect.addAll(PredicatePropertySelect.getDependencies(descriptor));
        }
        return new ArrayList<String>(new LinkedHashSet(executableSelect));
    }

    public static ResultSet convertResult(ResultSet rawResult, List<String> originalSelect, Map<String, PredicatePropertyDescriptor> descriptors) {
        assert (rawResult != null);
        assert (originalSelect != null);
        assert (descriptors != null);
        ArrayList<ResourceItem> items = new ArrayList<ResourceItem>(rawResult.getItems().size());
        ResourceItemPropertyValueByNameViaIndexMap propertyValueByName = new ResourceItemPropertyValueByNameViaIndexMap(rawResult.getProperties());
        for (ResourceItem rawItem : rawResult.getItems()) {
            PropertyByNameBackedByResourceItem valueByName = new PropertyByNameBackedByResourceItem(rawItem, propertyValueByName);
            ResourceItem item = PredicatePropertySelect.convertItem(valueByName, originalSelect, descriptors);
            items.add(item);
        }
        return new ResultSet(originalSelect, items, rawResult.getTotalCount());
    }

    private static ResourceItem convertItem(PropertyByName valueByName, List<String> originalSelect, Map<String, PredicatePropertyDescriptor> descriptors) {
        assert (valueByName != null);
        assert (originalSelect != null);
        assert (descriptors != null);
        ArrayList<Object> values = new ArrayList<Object>(originalSelect.size());
        for (String property : originalSelect) {
            PredicatePropertyDescriptor descriptor = descriptors.get(property);
            Object value = descriptor == null ? valueByName.getValue(property) : Boolean.valueOf(FilterEvaluator.eval(descriptor.getFilter(), valueByName));
            values.add(value);
        }
        return new ResourceItem(values);
    }

    private static Collection<String> getDependencies(PredicatePropertyDescriptor descriptor) {
        assert (descriptor != null);
        List<PropertyPredicate> predicates = descriptor.getFilter().getCriteria();
        ArrayList<String> dependencies = new ArrayList<String>(predicates.size());
        for (PropertyPredicate predicate : predicates) {
            String property = predicate.getProperty();
            if (PropertyUtil.isModelKey(property)) {
                throw new IllegalArgumentException(String.format("Predicate property '%s' depends on '%s'", descriptor.getName(), property));
            }
            dependencies.add(property);
        }
        return dependencies;
    }
}

