/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider.ext.relationship;

import com.vmware.cis.data.internal.util.PropertyUtil;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.lang.reflect.Array;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.Validate;

final class ModelKeyConverter {
    private static final String URI_PREFIX = "urn:vapi:";
    private static final char URI_TYPE_SEPARATOR = ':';
    private static final char VAPI_PACKAGE_SEPARATOR = '.';

    ModelKeyConverter() {
    }

    public static void validateModelKeyPropertyType(String propertyName, Class<?> propertyType) {
        assert (propertyName != null);
        assert (propertyType != null);
        if (!PropertyUtil.isModelKey(propertyName)) {
            return;
        }
        if (ModelKeyConverter.isModelKeySupportedStringType(propertyType) || ModelKeyConverter.isModelKeySupportedMorType(propertyType) || ModelKeyConverter.isModelKeySupportedUriType(propertyType)) {
            return;
        }
        if (propertyType.isArray()) {
            throw new UnsupportedOperationException(String.format("Unsupported return type '%s' declared for the related property '%s'!", propertyType.getComponentType().getClass().getName() + "[]", propertyName));
        }
        throw new UnsupportedOperationException(String.format("Unsupported return type '%s' declared for the related property '%s'!", propertyType.getName(), propertyName));
    }

    public static List<Object> convertModelKeyToReferences(String propertyName, Class<?> propertyType, List<Object> propertyValues, List<Object> resourceTypes) {
        assert (propertyValues != null);
        assert (!propertyValues.isEmpty());
        assert (resourceTypes != null);
        assert (!resourceTypes.isEmpty());
        assert (propertyValues.size() == resourceTypes.size());
        ModelKeyConverter.validateModelKeyPropertyType(propertyName, propertyType);
        ArrayList<Object> convertedPropertyValues = new ArrayList<Object>();
        Iterator<Object> resourceTypesIterator = resourceTypes.iterator();
        for (Object propertyValue : propertyValues) {
            convertedPropertyValues.add(ModelKeyConverter.convertModelKeyPropertyValue(propertyName, propertyType, propertyValue, resourceTypesIterator.next()));
        }
        return convertedPropertyValues;
    }

    public static Object convertReferenceToModelKey(Object propertyValue, boolean isCollectionValue) {
        assert (propertyValue != null);
        if (isCollectionValue) {
            return ModelKeyConverter.convertListValueToModelKeys(propertyValue);
        }
        return ModelKeyConverter.convertSingleValueToModelKey(propertyValue);
    }

    public static boolean isArrayIdentifier(Class<?> type) {
        return ManagedObjectReference[].class.equals(type) || URI[].class.equals(type);
    }

    private static Object convertModelKeyPropertyValue(String propertyName, Class<?> propertyType, Object propertyValue, Object resourceType) {
        if (propertyValue == null) {
            return propertyValue;
        }
        assert (resourceType != null);
        if (propertyType.isArray()) {
            return ModelKeyConverter.convertModelKeyPropertyValues(propertyName, propertyType.getComponentType(), propertyValue, resourceType);
        }
        Object modelKey = ModelKeyConverter.getSinglePropertyValue(propertyName, propertyValue);
        Object type = ModelKeyConverter.getSinglePropertyValue(propertyName, resourceType);
        if (modelKey == null) {
            return null;
        }
        if (String.class.equals(propertyType)) {
            return String.valueOf(modelKey);
        }
        if (URI.class.equals(propertyType)) {
            return type != null ? ModelKeyConverter.createUri(String.valueOf(modelKey), String.valueOf(type)) : null;
        }
        return modelKey;
    }

    private static Object convertModelKeyPropertyValues(String propertyName, Class<?> propertyType, Object propertyValue, Object resourceType) {
        assert (propertyValue != null);
        assert (resourceType != null);
        Object[] refArray = URI.class.equals(propertyType) ? ModelKeyConverter.convertModelKeyToUriArray(propertyValue, resourceType) : ModelKeyConverter.convertModelKeyToArray(propertyValue, propertyType);
        return refArray != null && refArray.length > 0 ? refArray : null;
    }

    private static Object getSinglePropertyValue(String propertyName, Object propertyValue) {
        assert (propertyValue != null);
        if (propertyValue instanceof Collection) {
            Collection collectionValue = (Collection)propertyValue;
            if (collectionValue.isEmpty()) {
                return null;
            }
            if (collectionValue.size() > 1) {
                throw new IllegalArgumentException(String.format("Property '%s' declared to return single value, but multiple values detected - [%s]!", propertyName, collectionValue));
            }
            return collectionValue.iterator().next();
        }
        if (propertyValue instanceof Object[]) {
            Object[] arrayValue = (Object[])propertyValue;
            if (arrayValue.length == 0) {
                return null;
            }
            if (arrayValue.length > 1) {
                throw new IllegalArgumentException(String.format("Property '%s' declared to return single value, but multiple values detected - [%s]!", propertyName, Arrays.toString(arrayValue)));
            }
            return arrayValue[0];
        }
        return propertyValue;
    }

    private static boolean isModelKeySupportedStringType(Class<?> propertyType) {
        return String.class.equals(propertyType) || propertyType.isArray() && String.class.equals(propertyType.getComponentType());
    }

    private static boolean isModelKeySupportedMorType(Class<?> propertyType) {
        return ManagedObjectReference.class.equals(propertyType) || propertyType.isArray() && ManagedObjectReference.class.equals(propertyType.getComponentType());
    }

    private static boolean isModelKeySupportedUriType(Class<?> propertyType) {
        return URI.class.equals(propertyType) || propertyType.isArray() && URI.class.equals(propertyType.getComponentType());
    }

    private static Object[] convertModelKeyToArray(Object propertyValue, Class<?> arrayType) {
        Object[] modelKeyArray;
        if (propertyValue instanceof Object[]) {
            return (Object[])propertyValue;
        }
        assert (propertyValue != null);
        assert (arrayType != null);
        if (propertyValue instanceof Collection) {
            Collection modelKeyCollection = (Collection)propertyValue;
            modelKeyArray = (Object[])Array.newInstance(arrayType, modelKeyCollection.size());
            int i = 0;
            for (Object modelKey : modelKeyCollection) {
                modelKeyArray[i++] = modelKey;
            }
        } else {
            modelKeyArray = (Object[])Array.newInstance(arrayType, 1);
            modelKeyArray[0] = propertyValue;
        }
        return modelKeyArray;
    }

    private static Object[] convertModelKeyToUriArray(Object propertyValue, Object resourceType) {
        assert (propertyValue != null);
        assert (resourceType != null);
        if (propertyValue instanceof Collection) {
            assert (resourceType instanceof Collection);
            Collection propertyValueCollection = (Collection)propertyValue;
            Collection resourceTypeCollection = (Collection)resourceType;
            assert (propertyValueCollection.size() == resourceTypeCollection.size());
            Object[] uriProperties = new URI[propertyValueCollection.size()];
            Iterator pvIterator = propertyValueCollection.iterator();
            Iterator rtIterator = resourceTypeCollection.iterator();
            int i = 0;
            while (pvIterator.hasNext()) {
                uriProperties[i++] = ModelKeyConverter.createUri(String.valueOf(pvIterator.next()), String.valueOf(rtIterator.next()));
            }
            return uriProperties;
        }
        if (propertyValue instanceof Object[]) {
            assert (resourceType instanceof Object[]);
            Object[] propertyValueArray = (Object[])propertyValue;
            Object[] resourceTypeArray = (Object[])resourceType;
            assert (propertyValueArray.length == resourceTypeArray.length);
            Object[] uriProperties = new URI[propertyValueArray.length];
            for (int i = 0; i < propertyValueArray.length; ++i) {
                uriProperties[i] = ModelKeyConverter.createUri(String.valueOf(propertyValueArray[i]), String.valueOf(resourceTypeArray[i]));
            }
            return uriProperties;
        }
        return new URI[]{ModelKeyConverter.createUri(String.valueOf(propertyValue), String.valueOf(resourceType))};
    }

    private static URI createUri(String modelKey, String resourceType) {
        Validate.notEmpty((String)resourceType, (String)"Resource type must not be null or empty");
        Validate.isTrue((resourceType.indexOf(58) < 0 ? 1 : 0) != 0, (String)String.format("Resource type must not contain colons: '%s'", resourceType));
        Validate.notEmpty((String)modelKey, (String)"The modelKey must not be null or empty");
        Validate.isTrue((resourceType.indexOf(46) > 0 ? 1 : 0) != 0, (String)String.format("Cannot create an URI resource reference for a VMODL1 resource type (i.e. resource type is not qualified with package name): '%s'", resourceType));
        return URI.create(URI_PREFIX + resourceType + ':' + modelKey);
    }

    private static String getId(URI uri) {
        ModelKeyConverter.validateVapiUri(uri);
        String uriString = uri.toString();
        int typeSeparatorIndex = ModelKeyConverter.getTypeSeparatorIndex(uriString);
        return uriString.substring(typeSeparatorIndex + 1);
    }

    private static void validateVapiUri(URI uri) {
        Validate.notNull((Object)uri, (String)"URI must not be null");
        Validate.isTrue((boolean)uri.toString().startsWith(URI_PREFIX), (String)String.format("Not a vAPI URI: %s", uri.toString()));
    }

    private static int getTypeSeparatorIndex(String vapiUriString) {
        int typeSeparatorIndex = vapiUriString.indexOf(58, URI_PREFIX.length());
        Validate.isTrue((typeSeparatorIndex >= 0 && typeSeparatorIndex < vapiUriString.length() - 1 ? 1 : 0) != 0, (String)String.format("Invalid vAPI URI: %s", vapiUriString));
        return typeSeparatorIndex;
    }

    private static List<Object> convertListValueToModelKeys(Object propertyValue) {
        assert (propertyValue instanceof List);
        List listValue = (List)propertyValue;
        assert (listValue.size() > 0);
        ArrayList<Object> convertedListValue = new ArrayList<Object>();
        for (Object listItem : listValue) {
            convertedListValue.add(ModelKeyConverter.convertSingleValueToModelKey(listItem));
        }
        return convertedListValue;
    }

    private static Object convertSingleValueToModelKey(Object propertyValue) {
        if (propertyValue instanceof URI) {
            URI ref = (URI)propertyValue;
            return ModelKeyConverter.getId(ref);
        }
        return propertyValue;
    }
}

