/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider.ext.relationship;

import com.vmware.cis.data.internal.provider.ext.relationship.ModelKeyConverter;
import com.vmware.cis.data.internal.provider.ext.relationship.RelationshipDescriptor;
import com.vmware.cis.data.internal.util.QualifiedProperty;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.Relationship;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public final class RelatedPropertyDescriptor {
    private final String _name;
    private final Class<?> _type;
    private final String _targetName;
    private final List<RelationshipDescriptor> _relationships;

    public static RelatedPropertyDescriptor fromField(String resourceModel, Field relatedPropertyField) {
        Validate.notEmpty((String)resourceModel, (String)"Model name must not be empty!");
        Validate.notNull((Object)relatedPropertyField, (String)"Related property field must not be null!");
        RelatedPropertyDescriptor.validateRelatedPropertyField(relatedPropertyField);
        QualifiedProperty qualifiedRelatedProperty = QualifiedProperty.forModelAndSimpleProperty(resourceModel, relatedPropertyField.getName());
        String targetPropertyName = RelatedPropertyDescriptor.getTargetPropertyName(relatedPropertyField);
        String[] relationships = RelatedPropertyDescriptor.getRelationships(relatedPropertyField);
        ArrayList<RelationshipDescriptor> relationshipDescriptors = new ArrayList<RelationshipDescriptor>();
        for (String relationship : relationships) {
            relationshipDescriptors.add(new RelationshipDescriptor(qualifiedRelatedProperty.toString(), relationship));
        }
        RelatedPropertyDescriptor.validateRelatedPropertyData(qualifiedRelatedProperty.toString(), relatedPropertyField.getType(), targetPropertyName, relationshipDescriptors);
        return new RelatedPropertyDescriptor(qualifiedRelatedProperty.toString(), relatedPropertyField.getType(), targetPropertyName, relationshipDescriptors);
    }

    RelatedPropertyDescriptor(String name, Class<?> type, String targetName, List<RelationshipDescriptor> relationships) {
        assert (name != null);
        assert (type != null);
        assert (targetName != null);
        assert (relationships != null);
        assert (!relationships.isEmpty());
        this._name = name;
        this._type = type;
        this._targetName = targetName;
        this._relationships = relationships;
    }

    public String getSourceModelProperty() {
        RelationshipDescriptor firstRelationshipDescriptor = this.getRelationships().get(0);
        String sourceModelProperty = firstRelationshipDescriptor.isDefinedByTarget() ? "@modelKey" : firstRelationshipDescriptor.getName();
        return sourceModelProperty;
    }

    public String getName() {
        return this._name;
    }

    public Class<?> getType() {
        return this._type;
    }

    public String getTargetName() {
        return this._targetName;
    }

    public List<RelationshipDescriptor> getRelationships() {
        return this._relationships;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RelatedPropertyDescriptor)) {
            return false;
        }
        RelatedPropertyDescriptor other = (RelatedPropertyDescriptor)obj;
        return this._name.equals(other._name) && this._type.equals(other._type) && this._targetName.equals(other._targetName) && this._relationships.equals(other._relationships);
    }

    public int hashCode() {
        int hash = 17;
        hash = 31 * hash + this._name.hashCode();
        hash = 31 * hash + this._type.hashCode();
        hash = 31 * hash + this._targetName.hashCode();
        hash = 31 * hash + this._relationships.hashCode();
        return hash;
    }

    public String toString() {
        return "RelatedPropertyDescriptor [_name=" + this._name + ", _type=" + this._type.getName() + ", _targetName=" + this._targetName + ", _relationships=" + this._relationships + "]";
    }

    private static String getTargetPropertyName(Field relatedPropertyField) {
        Property property = relatedPropertyField.getAnnotation(Property.class);
        return property.value();
    }

    private static String[] getRelationships(Field relatedPropertyField) {
        Relationship relationship = relatedPropertyField.getAnnotation(Relationship.class);
        String[] relationships = relationship.value();
        return relationships == null ? new String[]{} : relationships;
    }

    private static void validateRelatedPropertyField(Field relatedPropertyField) {
        assert (relatedPropertyField != null);
        assert (relatedPropertyField.isAnnotationPresent(Property.class));
        assert (relatedPropertyField.isAnnotationPresent(Relationship.class));
    }

    private static void validateRelatedPropertyData(String relatedProperty, Class<?> relatedPropertyType, String targetPropertyName, List<RelationshipDescriptor> relationshipDescriptors) {
        assert (relatedProperty != null);
        assert (relatedPropertyType != null);
        assert (relationshipDescriptors != null);
        ModelKeyConverter.validateModelKeyPropertyType(relatedProperty, relatedPropertyType);
        Validate.isTrue((boolean)StringUtils.isNotEmpty((String)targetPropertyName), (String)String.format("The target property for related property '%s' must not be empty!", relatedProperty));
        Validate.isTrue((boolean)QualifiedProperty.isSyntacticallyQualified(targetPropertyName), (String)String.format("The target property '%s' for related property '%s' must be qualified!", targetPropertyName, relatedProperty));
        Validate.isTrue((!relationshipDescriptors.isEmpty() ? 1 : 0) != 0, (String)String.format("The defined related property '%s' must have at least one relationship defined!", relatedProperty));
        Validate.isTrue((relationshipDescriptors.size() <= 3 ? 1 : 0) != 0, (String)String.format("The defined related property '%s' contains %d multi-hop relationships which is more that the allowed maximum level of %d!", relatedProperty, relationshipDescriptors.size(), 3));
    }
}

